package com.xebialabs.xlrelease.reports.excel

import com.xebialabs.xlrelease.planner.PlannerReleaseTree
import com.xebialabs.xlrelease.reports.audit._
import com.xebialabs.xlrelease.reports.domain.MaybeData.Maybe
import com.xebialabs.xlrelease.reports.domain.ReleaseTitleAndPath
import org.apache.poi.ss.usermodel.Workbook

object AuditReport {
  val LOGO_WIDTH: Integer = 53 // found by experiment, magic units
  val LOGO_HEIGHT: Integer = 9 // found by experiment, magic units

  case class Data(releaseTree: PlannerReleaseTree,
                  template: Maybe[Option[ReleaseTitleAndPath]],
                  releaseOverviewData: ReleaseOverviewReport.Data,
                  planRecordsData: TaskRecordReport.Data,
                  buildRecordsData: TaskRecordReport.Data,
                  codeComplianceRecordsData: TaskRecordReport.Data,
                  itsmRecordsData: TaskRecordReport.Data,
                  deploymentsData: TaskRecordReport.Data,
                  activityLogsData: ActivityLogReport.Data,
                  taskInputOutputData: TaskDetailsReport.Data,
                  permissionData: ReleasePermissionReport.Data)

  def getWorkBook(data: Data): Workbook =
    new AuditReport(data).getWorkBook()

}

class AuditReport(val data: AuditReport.Data) {

  val workbook: ReportWorkbook = new ReportWorkbook
  val styles = workbook.getStyles

  def getWorkBook(): Workbook = {
    val overview = new ReleaseOverviewReport(data.releaseOverviewData, workbook, styles)
    val taskTitleCellsForHyperlinks: Map[String, (Int, Int)] = overview.addContent()
    TaskDetailsReport.addSection(data.taskInputOutputData, workbook, styles, overview.sheetWriter, taskTitleCellsForHyperlinks)
    TaskRecordReport.addSection(data.planRecordsData, workbook, styles)
    TaskRecordReport.addSection(data.buildRecordsData, workbook, styles)
    TaskRecordReport.addSection(data.codeComplianceRecordsData, workbook, styles)
    TaskRecordReport.addSection(data.itsmRecordsData, workbook, styles)
    TaskRecordReport.addSection(data.deploymentsData, workbook, styles)
    ActivityLogReport.addSection(data.activityLogsData, workbook, styles)
    ReleasePermissionReport.addSection(data.permissionData, workbook, styles)

    workbook.getWorkbookWithoutErrorSheet()
  }

}
