package com.xebialabs.xlrelease.reports.job.impl

import com.xebialabs.xlplatform.cluster.ClusterMode.{Full, HotStandby, Standalone}
import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.actors.cluster.XlrCluster.ClusterAddressOps
import com.xebialabs.xlrelease.config.XlrConfig

class ReportingEngineConfiguration(actorSystemHolder: ActorSystemHolder) {

  def node: String = {
    XlrConfig.getInstance.clusterMode match {
      case Full | HotStandby => actorSystemHolder.cluster().selfAddress.nodeAddress
      case Standalone => "default"
    }
  }
}
