package com.xebialabs.xlrelease.reports.job.impl.s3

import com.xebialabs.xlrelease.reports.job.api.ReportStorage.StreamingReportStorage

import java.io.{File, FileInputStream}
import java.net.URI
import com.xebialabs.xlrelease.reports.job.impl.s3.S3ReportStorage.LocalFileExtension
import com.xebialabs.xlrelease.storage.s3.S3Storage.StringExtension
import com.xebialabs.xlrelease.storage.s3.S3StorageConfig


private[s3] class S3StreamingReportStorage(private val storage: S3ReportStorage, override val localWorkDir: File) extends StreamingReportStorage {

  private implicit val implicitS3StorageConfig: S3StorageConfig = storage.s3StorageConfig
  private implicit val implicitS3Storage: S3ReportStorage = storage

  override def finalizeReport(localResultFile: File): URI = {
    val reportUri = localResultFile.toFileKey.toKeyUri
    val fileInputStream = new FileInputStream(localResultFile)
    storage.s3Storage.put(reportUri, fileInputStream)
    localWorkDir.toURI.relativize(localResultFile.toURI)
  }

  private[s3] lazy val reportDir: URI = localWorkDir.toKey.toKeyUri
}
