package com.xebialabs.xlrelease.reports.job.repository

import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.reports.job.domain.ReportJob
import com.xebialabs.xlrelease.reports.job.repository.sql.SqlReportJobFilterQueryBuilder
import com.xebialabs.xlrelease.repository.query.FiltersQueryBuilder
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate

trait QueryBuilder {
  def from(reportJobFilter: ReportJobFilters): FiltersQueryBuilder[ReportJobFilters, ReportJob]
}

object QueryBuilder {
  def apply(dialect: Dialect, namedTemplate: NamedParameterJdbcTemplate, sqlRepositoryAdapter: SqlRepositoryAdapter) =
    new SqlQueryBuilder(dialect, namedTemplate, sqlRepositoryAdapter)
}

class SqlQueryBuilder(dialect: Dialect, namedTemplate: NamedParameterJdbcTemplate, sqlRepositoryAdapter: SqlRepositoryAdapter) extends QueryBuilder {
  override def from(reportJobFilter: ReportJobFilters): FiltersQueryBuilder[ReportJobFilters, ReportJob] =
    new SqlReportJobFilterQueryBuilder(dialect, namedTemplate, sqlRepositoryAdapter).from(reportJobFilter)
}
