/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.job.impl;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.reports.job.api.ReportDefinition;
import com.xebialabs.xlrelease.reports.job.api.ReportingEngineService;
import com.xebialabs.xlrelease.reports.job.api.StreamingReportResult;
import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.domain.ReportJobStatus;
import com.xebialabs.xlrelease.reports.job.events.ReportJobDeletedEvent;
import com.xebialabs.xlrelease.reports.job.impl.AbortReportJob;
import com.xebialabs.xlrelease.reports.job.impl.GlobalReportStorage;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstance;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstanceFactory;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobFilters;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobRepository;
import com.xebialabs.xlrelease.service.BroadcastService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001\u0002\u000e\u001c\u0001!B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"AQ\n\u0001B\u0001B\u0003%a\n\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011!A\u0006A!A!\u0002\u0013I\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011!\u0004!\u0011!Q\u0001\n%DQa\u001c\u0001\u0005\u0002ADQ!\u001f\u0001\u0005BiDq!a\r\u0001\t\u0003\n)\u0004C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V!9\u0011q\f\u0001\u0005B\u0005\u0005\u0004bBA3\u0001\u0011\u0005\u0013q\r\u0005\b\u0003K\u0002A\u0011IA9\u0011\u001d\t9\t\u0001C!\u0003\u0013Cq!a#\u0001\t\u0003\ni\tC\u0004\u0002\f\u0002!\t%!%\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\n\"9\u0011q\u0013\u0001\u0005B\u0005e\u0005bBA_\u0001\u0011%\u0011q\u0018\u0005\b\u0003K\u0002A\u0011BAb\u0011\u001d\tI\r\u0001C\u0005\u0003\u0017Dq!a4\u0001\t\u0013\t\t\u000eC\u0004\u0002V\u0002!I!a6\u0003;\u0011+g-Y;miJ+\u0007o\u001c:uS:<WI\\4j]\u0016\u001cVM\u001d<jG\u0016T!\u0001H\u000f\u0002\t%l\u0007\u000f\u001c\u0006\u0003=}\t1A[8c\u0015\t\u0001\u0013%A\u0004sKB|'\u000f^:\u000b\u0005\t\u001a\u0013!\u0003=me\u0016dW-Y:f\u0015\t!S%A\u0005yK\nL\u0017\r\\1cg*\ta%A\u0002d_6\u001c\u0001a\u0005\u0003\u0001S=*\u0004C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g\r\u0005\u00021g5\t\u0011G\u0003\u00023;\u0005\u0019\u0011\r]5\n\u0005Q\n$A\u0006*fa>\u0014H/\u001b8h\u000b:<\u0017N\\3TKJ4\u0018nY3\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014!B:mMRR'\"\u0001\u001e\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!\u0001P\u001c\u0003\u000f1{wmZ5oO\u0006\u0011\u0012\r\u001d9mS\u000e\fG/[8o\u0007>tG/\u001a=u!\tyd)D\u0001A\u0015\t\t%)A\u0004d_:$X\r\u001f;\u000b\u0005\r#\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\u0015\u000b1a\u001c:h\u0013\t9\u0005I\u0001\nBaBd\u0017nY1uS>t7i\u001c8uKb$\u0018\u0001\u0007:fa>\u0014HOS8c\u0013:\u001cH/\u00198dK\u001a\u000b7\r^8ssB\u0011!jS\u0007\u00027%\u0011Aj\u0007\u0002\u0019%\u0016\u0004xN\u001d;K_\nLen\u001d;b]\u000e,g)Y2u_JL\u0018a\u0005:fa>\u0014HOS8c%\u0016\u0004xn]5u_JL\bCA(S\u001b\u0005\u0001&BA)\u001e\u0003)\u0011X\r]8tSR|'/_\u0005\u0003'B\u00131CU3q_J$(j\u001c2SKB|7/\u001b;pef\f1c\u001a7pE\u0006d'+\u001a9peR\u001cFo\u001c:bO\u0016\u0004\"A\u0013,\n\u0005][\"aE$m_\n\fGNU3q_J$8\u000b^8sC\u001e,\u0017A\u00059fe6L7o]5p]\u0016sgm\u001c:dKJ\u0004\"AW0\u000e\u0003mS!\u0001X/\u0002\u0011M,7-\u001e:jifT!AX\u0012\u0002\u0011\u0011,\u0007\u000f\\8zSRL!\u0001Y.\u0003%A+'/\\5tg&|g.\u00128g_J\u001cWM]\u0001\tKZ,g\u000e\u001e\"vgB\u00111MZ\u0007\u0002I*\u0011Q-I\u0001\u0007KZ,g\u000e^:\n\u0005\u001d$'!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006\u0001\"M]8bI\u000e\f7\u000f^*feZL7-\u001a\t\u0003U6l\u0011a\u001b\u0006\u0003Y\u0006\nqa]3sm&\u001cW-\u0003\u0002oW\n\u0001\"I]8bI\u000e\f7\u000f^*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011E\u00148\u000f^;wob\u0004\"A\u0013\u0001\t\u000buB\u0001\u0019\u0001 \t\u000b!C\u0001\u0019A%\t\u000b5C\u0001\u0019\u0001(\t\u000bQC\u0001\u0019A+\t\u000baC\u0001\u0019A-\t\u000b\u0005D\u0001\u0019\u00012\t\u000b!D\u0001\u0019A5\u0002\rM$\u0018\r^;t)\rY\u00181\u0001\t\u0003y~l\u0011! \u0006\u0003}v\ta\u0001Z8nC&t\u0017bAA\u0001{\ny!+\u001a9peRTuNY*uCR,8\u000fC\u0004\u0002\u0006%\u0001\r!a\u0002\u0002\u000b)|'-\u00133\u0011\t\u0005%\u0011Q\u0006\b\u0005\u0003\u0017\tIC\u0004\u0003\u0002\u000e\u0005\u001db\u0002BA\b\u0003KqA!!\u0005\u0002$9!\u00111CA\u0011\u001d\u0011\t)\"a\b\u000f\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007(\u0003\u0019a$o\\8u}%\ta%\u0003\u0002%K%\u0011!eI\u0005\u0003A\u0005J!AH\u0010\n\u0005Ij\u0012bAA\u0016c\u00051\"+\u001a9peRLgnZ#oO&tWmU3sm&\u001cW-\u0003\u0003\u00020\u0005E\"a\u0003*fa>\u0014HOS8c\u0013\u0012T1!a\u000b2\u0003%9W\r\u001e*fgVdG\u000f\u0006\u0003\u00028\u0005u\u0002c\u0001\u0019\u0002:%\u0019\u00111H\u0019\u0003+M#(/Z1nS:<'+\u001a9peR\u0014Vm];mi\"9\u0011Q\u0001\u0006A\u0002\u0005\u001d\u0011a\u00029sKZLWm\u001e\u000b\u0005\u0003\u0007\nI\u0005E\u0002+\u0003\u000bJ1!a\u0012,\u0005\r\te.\u001f\u0005\b\u0003\u0017Z\u0001\u0019AA'\u0003A\u0011X\r]8si\u0012+g-\u001b8ji&|g\u000eE\u00021\u0003\u001fJ1!!\u00152\u0005A\u0011V\r]8si\u0012+g-\u001b8ji&|g.A\u0002hKR$B!a\u0016\u0002^A\u0019A0!\u0017\n\u0007\u0005mSPA\u0005SKB|'\u000f\u001e&pE\"9\u0011Q\u0001\u0007A\u0002\u0005\u001d\u0011AB:vE6LG\u000f\u0006\u0003\u0002\b\u0005\r\u0004bBA&\u001b\u0001\u0007\u0011QJ\u0001\u0006C\n|'\u000f\u001e\u000b\u0005\u0003S\ny\u0007E\u0002+\u0003WJ1!!\u001c,\u0005\u0011)f.\u001b;\t\u000f\u0005\u0015a\u00021\u0001\u0002\bQ!\u00111OAB!\u0019\t)(a \u0002\b5\u0011\u0011q\u000f\u0006\u0005\u0003s\nY(\u0001\u0003vi&d'BAA?\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0015q\u000f\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0002\u0006>\u0001\r!a\u001d\u0002\r)|'-\u00133t\u0003!\t'm\u001c:u\u00032dGCAA:\u0003\u0019!W\r\\3uKR!\u0011\u0011NAH\u0011\u001d\t)!\u0005a\u0001\u0003\u000f!B!a\u001d\u0002\u0014\"9\u0011Q\u0011\nA\u0002\u0005M\u0014!\u00033fY\u0016$X-\u00117m\u0003\u00191\u0017N\u001c3CsR1\u00111TAU\u0003g\u0003b!!(\u0002&\u0006]SBAAP\u0015\rq\u0018\u0011\u0015\u0006\u0004\u0003G\u0013\u0015\u0001\u00023bi\u0006LA!a*\u0002 \n!\u0001+Y4f\u0011\u001d\tY\u000b\u0006a\u0001\u0003[\u000b\u0001C]3q_J$(j\u001c2GS2$XM]:\u0011\u0007=\u000by+C\u0002\u00022B\u0013\u0001CU3q_J$(j\u001c2GS2$XM]:\t\u000f\u0005UF\u00031\u0001\u00028\u0006A\u0001/Y4fC\ndW\r\u0005\u0003\u0002\u001e\u0006e\u0016\u0002BA^\u0003?\u0013\u0001\u0002U1hK\u0006\u0014G.Z\u0001\u0017M&tG-\u00118e\u0003\n|'\u000f\u001e*fa>\u0014HOS8cgR!\u00111OAa\u0011\u001d\tY+\u0006a\u0001\u0003[#B!a\u0002\u0002F\"9\u0011q\u0019\fA\u0002\u0005]\u0013!\u0003:fa>\u0014HOS8c\u0003]1\u0017N\u001c3B]\u0012$U\r\\3uKJ+\u0007o\u001c:u\u0015>\u00147\u000f\u0006\u0003\u0002t\u00055\u0007bBAV/\u0001\u0007\u0011QV\u0001\u0010I\u0016dW\r^3SKB|'\u000f\u001e&pER!\u0011qKAj\u0011\u001d\t9\r\u0007a\u0001\u0003/\n\u0001c\u00195fG.\u0014V\r]8si>;h.\u001a:\u0015\t\u0005%\u0014\u0011\u001c\u0005\b\u0003\u000fL\u0002\u0019AA,\u0001")
public class DefaultReportingEngineService
implements ReportingEngineService,
Logging {
    private final ApplicationContext applicationContext;
    private final ReportJobInstanceFactory reportJobInstanceFactory;
    private final ReportJobRepository reportJobRepository;
    private final GlobalReportStorage globalReportStorage;
    private final PermissionEnforcer permissionEnforcer;
    private final XLReleaseEventBus eventBus;
    private final BroadcastService broadcastService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultReportingEngineService defaultReportingEngineService = this;
        synchronized (defaultReportingEngineService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReportJobStatus status(Integer jobId) {
        return (ReportJobStatus)((Object)this.reportJobRepository.findByJobId(jobId).map((Function1 & Serializable)reportJob -> {
            this.checkReportOwner((ReportJob)((Object)reportJob));
            return reportJob.getStatus();
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Job '" + jobId + "' could not be found.", new Object[0]);
        }));
    }

    @Override
    public StreamingReportResult getResult(Integer jobId) {
        Option<ReportJob> reportJobOption = this.reportJobRepository.findByJobId(jobId);
        return (StreamingReportResult)reportJobOption.map((Function1 & Serializable)reportJob -> {
            this.checkReportOwner((ReportJob)((Object)reportJob));
            return $this.globalReportStorage.resolve($this.globalReportStorage.reportResult((ReportJob)((Object)reportJob)));
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Result of job '" + jobId + "' could not be found.", new Object[0]);
        });
    }

    @Override
    public Object preview(ReportDefinition reportDefinition) {
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)reportDefinition);
        return reportDefinition.preview();
    }

    @Override
    public ReportJob get(Integer jobId) {
        Option<ReportJob> reportJobOption = this.reportJobRepository.findByJobId(jobId);
        return (ReportJob)((Object)reportJobOption.map((Function1 & Serializable)reportJob -> {
            this.checkReportOwner((ReportJob)((Object)reportJob));
            return reportJob;
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Job '" + jobId + "' could not be found.", new Object[0]);
        }));
    }

    @Override
    public Integer submit(ReportDefinition reportDefinition) {
        ReportJobInstance reportJobInstance = this.reportJobInstanceFactory.submit(reportDefinition);
        reportJobInstance.enqueue();
        int jobId = reportJobInstance.getJobId();
        return Predef$.MODULE$.int2Integer(jobId);
    }

    @Override
    public void abort(Integer jobId) {
        Option<ReportJob> reportJobOption = this.reportJobRepository.findByJobId(jobId);
        reportJobOption.map((Function1 & Serializable)reportJob -> this.abort((ReportJob)((Object)reportJob))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Job '" + jobId + "' could not be found.", new Object[0]);
        });
    }

    @Override
    public java.util.List<Integer> abort(java.util.List<Integer> jobIds) {
        if (jobIds.isEmpty()) {
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava();
        }
        ReportJobFilters reportJobFilters = new ReportJobFilters();
        reportJobFilters.setJobIds(jobIds);
        return this.findAndAbortReportJobs(reportJobFilters);
    }

    @Override
    public java.util.List<Integer> abortAll() {
        ReportJobFilters reportJobFilters = new ReportJobFilters();
        return this.findAndAbortReportJobs(reportJobFilters);
    }

    @Override
    public void delete(Integer jobId) {
        Option<ReportJob> reportJobOption = this.reportJobRepository.findByJobId(jobId);
        reportJobOption.map((Function1 & Serializable)reportJob -> this.deleteReportJob((ReportJob)((Object)reportJob))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Job '" + jobId + "' could not be found.", new Object[0]);
        });
    }

    @Override
    public java.util.List<Integer> delete(java.util.List<Integer> jobIds) {
        if (jobIds.isEmpty()) {
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava();
        }
        ReportJobFilters reportJobFilters = new ReportJobFilters();
        reportJobFilters.setJobIds(jobIds);
        return this.findAndDeleteReportJobs(reportJobFilters);
    }

    @Override
    public java.util.List<Integer> deleteAll() {
        ReportJobFilters reportJobFilters = new ReportJobFilters();
        reportJobFilters.statuses_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ReportJobStatus.ABORTED.name(), (List)new .colon.colon((Object)ReportJobStatus.FAILED.name(), (List)new .colon.colon((Object)ReportJobStatus.COMPLETED.name(), (List)Nil$.MODULE$)))).asJava());
        return this.findAndDeleteReportJobs(reportJobFilters);
    }

    @Override
    public Page<ReportJob> findBy(ReportJobFilters reportJobFilters, Pageable pageable) {
        block0: {
            if (this.permissionEnforcer.isCurrentUserAdmin()) break block0;
            reportJobFilters.username_$eq(Permissions.getAuthenticatedUserName());
        }
        return this.reportJobRepository.query(reportJobFilters, pageable);
    }

    private java.util.List<Integer> findAndAbortReportJobs(ReportJobFilters reportJobFilters) {
        ListBuffer abortRequestedJobIds = ListBuffer$.MODULE$.empty();
        reportJobFilters.statuses_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ReportJobStatus.SUBMITTED.name(), (List)new .colon.colon((Object)ReportJobStatus.STARTED.name(), (List)Nil$.MODULE$))).asJava());
        Page<ReportJob> result = this.findBy(reportJobFilters, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
        result.forEach(reportJob -> {
            try {
                abortRequestedJobIds.$plus$eq((Object)this.abort((ReportJob)((Object)reportJob)));
            }
            catch (Exception e) {
                this.logger().warn((Function0 & Serializable)() -> "Error while aborting a list of jobs", (Function0 & Serializable)() -> e);
            }
        });
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)abortRequestedJobIds).asJava();
    }

    private Integer abort(ReportJob reportJob) {
        this.checkReportOwner(reportJob);
        Integer jobId = reportJob.getJobId();
        .colon.colon validStatuses = new .colon.colon((Object)ReportJobStatus.SUBMITTED.name(), (List)new .colon.colon((Object)ReportJobStatus.STARTED.name(), (List)Nil$.MODULE$));
        if (validStatuses.contains((Object)reportJob.status().name())) {
            this.broadcastService.broadcast((DistributedXLReleaseEvent)new AbortReportJob(jobId), true);
            return jobId;
        }
        throw new IllegalStateException("Can not abort report job '" + jobId + "'. It is already completed, failed or aborted.");
    }

    private java.util.List<Integer> findAndDeleteReportJobs(ReportJobFilters reportJobFilters) {
        ListBuffer deletedJobIds = ListBuffer$.MODULE$.empty();
        Page<ReportJob> result = this.findBy(reportJobFilters, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
        result.forEach(reportJob -> {
            try {
                deletedJobIds.$plus$eq((Object)this.deleteReportJob((ReportJob)((Object)reportJob)).getJobId());
            }
            catch (Exception e) {
                this.logger().warn((Function0 & Serializable)() -> "Error while deleting a list of jobs", (Function0 & Serializable)() -> e);
            }
        });
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)deletedJobIds).asJava();
    }

    private ReportJob deleteReportJob(ReportJob reportJob) {
        this.checkReportOwner(reportJob);
        .colon.colon validStatuses = new .colon.colon((Object)ReportJobStatus.ABORTED.name(), (List)new .colon.colon((Object)ReportJobStatus.FAILED.name(), (List)new .colon.colon((Object)ReportJobStatus.COMPLETED.name(), (List)Nil$.MODULE$)));
        if (validStatuses.contains((Object)reportJob.status().name()) && this.globalReportStorage.cleanup(reportJob)) {
            reportJob.status_$eq(ReportJobStatus.DELETED);
            ReportJob deletedReportJob = this.reportJobRepository.update(reportJob);
            this.eventBus.publish((XLReleaseEvent)new ReportJobDeletedEvent(deletedReportJob));
            return deletedReportJob;
        }
        throw new IllegalStateException("Can not delete report job '" + reportJob.getJobId() + "'. It is either already deleted or Digital.ai Release does not have required access to the filesystem.");
    }

    private void checkReportOwner(ReportJob reportJob) {
        if (!this.permissionEnforcer.isCurrentUserAdmin()) {
            String string = reportJob.username();
            String string2 = Permissions.getAuthenticatedUserName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw PermissionDeniedException.withMessage((String)("You can not take action on report job '" + reportJob.getJobId() + "' as you are not the owner of this report job."));
            }
        }
    }

    public DefaultReportingEngineService(ApplicationContext applicationContext, ReportJobInstanceFactory reportJobInstanceFactory, ReportJobRepository reportJobRepository, GlobalReportStorage globalReportStorage, PermissionEnforcer permissionEnforcer, XLReleaseEventBus eventBus, BroadcastService broadcastService) {
        this.applicationContext = applicationContext;
        this.reportJobInstanceFactory = reportJobInstanceFactory;
        this.reportJobRepository = reportJobRepository;
        this.globalReportStorage = globalReportStorage;
        this.permissionEnforcer = permissionEnforcer;
        this.eventBus = eventBus;
        this.broadcastService = broadcastService;
        Logging.$init$((Logging)this);
    }
}

