package com.xebialabs.xlrelease.reports.domain

import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReportComponent
import com.xebialabs.xlrelease.reports.excel.AuditReport
import com.xebialabs.xlrelease.reports.job.domain.BaseStreamingReleaseReportDefinition
import com.xebialabs.xlrelease.reports.service.ReportsService
import org.springframework.beans.factory.annotation.Autowired

import jakarta.ws.rs.core.StreamingOutput
import scala.beans.BeanProperty

class ReleaseAuditExcelReport extends BaseStreamingReleaseReportDefinition {

  @BeanProperty
  @Autowired
  var reportsService: ReportsService = _

  override def reportName: String = "Digital_ai Release Audit Report"

  override def contentType: String = MultiReleaseAuditReportComponent.EXCEL_CONTENT_TYPE

  override def run(): StreamingOutput = {
    val data = reportsService.fetchAuditReportData(release)
    val workbook = AuditReport.getWorkBook(data)
    fileName = MultiReleaseAuditReportComponent.sanitizeFilename(release.getTitle) + MultiReleaseAuditReportComponent.EXCEL_EXTENSION
    val output: StreamingOutput = workbook.write
    output
  }
}
