package com.xebialabs.xlrelease.reports.job.api

import com.xebialabs.xlplatform.utils.ResourceManagement
import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReportComponent.{DATETIME_FORMATTER, EXCEL_EXTENSION, SINGLE_TITLE_SEPARATOR, sanitizeFilename}
import com.xebialabs.xlrelease.reports.job.api.ReportStorage.StreamingReportStorage
import com.xebialabs.xlrelease.reports.job.api.ReportingEngineService.ReportJobId
import com.xebialabs.xlrelease.reports.job.domain.ReportJob
import org.apache.poi.ss.usermodel.Workbook

import java.io.{File, FileOutputStream}
import java.net.URI
import java.nio.file.Path
import java.util.Date


trait ReportStorage {

  def reportStorage(jobId: ReportJobId, generatedOn: Date): StreamingReportStorage

  def resolve(reportResult: ReportResult): StreamingReportResult

  def cleanup(reportJob: ReportJob): Boolean
}

object ReportStorage {

   trait StreamingReportStorage {

     def localWorkDir: File

     def finalizeReport(localResultFile: File): URI

     def writeToLocalFile(workDir: Path, workBook: Workbook, date: Date, title: String): File = {
       val sanitizedTitle = sanitizeFilename(title)
       val reportFileName = s"${DATETIME_FORMATTER.format(date)}$SINGLE_TITLE_SEPARATOR$sanitizedTitle"
       var stored: File = workDir.resolve(s"$reportFileName$EXCEL_EXTENSION").toFile
       var fileCounter = 1
       while (localReportExists(stored)) {
         stored = workDir.resolve(s"$reportFileName$SINGLE_TITLE_SEPARATOR$fileCounter$EXCEL_EXTENSION").toFile
         fileCounter += 1
       }
       ResourceManagement.using(new FileOutputStream(stored))(workBook.write)
       stored
     }

     private def localReportExists(localFile: File): Boolean = localFile.exists()
   }
}
