package com.xebialabs.xlrelease.reports.repository

import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.repository.FacetRepository.SpecializedFacetRepository
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId


trait RepositoryExceptionUtils {
  specializedFacetRepository: SpecializedFacetRepository =>
  def targetTaskNotFoundException(recordId: CiId, targetId: CiId): NotFoundException = {
    new NotFoundException(s"Could not find facet target task by Id '$targetId' for facet '$recordId'")
  }

  def requiresInstanceOfSupportedType(recordType: Type): Unit = {
    require(recordType.instanceOf(supportedType), s"Record type '$recordType' should be a subtype of ${supportedType.toString}")
  }
}

