package com.xebialabs.xlrelease.reports.repository

import com.xebialabs.xlrelease.domain.udm.reporting.BuildRecord
import com.xebialabs.xlrelease.reports.repository.CommonRowAndParamsMapper._
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.TaskRecordTable
import com.xebialabs.xlrelease.repository.sql.persistence.Utils.{RichStringAsTruncatable, params}
import com.xebialabs.xlrelease.repository.sql.persistence.{Table, TaskCiUid}

import java.sql.ResultSet
import java.util.Date

package object build {

  class BuildTaskReportingRecordTable(tableName: String) extends Table(tableName)
    with TaskRecordTable {
    val PROJECT = "PROJECT"
    val BUILD = "BUILD"
    val OUTCOME = "OUTCOME"
    val START_DATE = "START_DATE"
    val END_DATE = "END_DATE"
    val DURATION = "DURATION"
    val BUILD_URL = "BUILD_URL"
  }

  case object BUILD_TASK_REPORTING_RECORD_LIVE extends BuildTaskReportingRecordTable("XLR_TASK_RECORD_BUILD")

  case object BUILD_TASK_REPORTING_RECORD_ARCHIVE extends BuildTaskReportingRecordTable("TASK_RECORD_BUILD")


  private[build] def asQueryParameters(record: BuildRecord, taskUid: TaskCiUid): Map[String, Any] = {
    mapCommonParams(record, taskUid) ++ params(
      "build" -> record.getBuild.truncate(SHORT_VARCHAR),
      "buildUrl" -> record.getBuild_url.truncate(LONG_VARCHAR),
      "duration" -> record.getDuration.truncate(SHORT_VARCHAR),
      "endDate" -> record.getEndDate,
      "outcome" -> record.getOutcome.truncate(SHORT_VARCHAR),
      "project" -> record.getProject.truncate(SHORT_VARCHAR),
      "startDate" -> record.getStartDate
    )
  }

  private[build] def buildItemRowMapper(rs: ResultSet, buildRecord: BuildRecord,
                                        targetId: String, buildItemTable: BuildTaskReportingRecordTable): BuildRecord = {
    mapCommonFields(rs, buildRecord, targetId, buildItemTable)
    buildRecord.setBuild(rs.getString(buildItemTable.BUILD))
    buildRecord.setBuild_url(rs.getString(buildItemTable.BUILD_URL))
    buildRecord.setDuration(rs.getString(buildItemTable.DURATION))
    buildRecord.setEndDate(Date.from(rs.getTimestamp(buildItemTable.END_DATE).toInstant))
    buildRecord.setOutcome(rs.getString(buildItemTable.OUTCOME))
    buildRecord.setProject(rs.getString(buildItemTable.PROJECT))
    buildRecord.setStartDate(Date.from(rs.getTimestamp(buildItemTable.START_DATE).toInstant))
    buildRecord
  }

}
