/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.job.impl.cleanup;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.configuration.AuditReportSettings;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.domain.ReportJobStatus;
import com.xebialabs.xlrelease.reports.job.events.ReportJobDeletedEvent;
import com.xebialabs.xlrelease.reports.job.impl.GlobalReportStorage;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstance;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstanceFactory;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobFilters;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.threeten.extra.Interval;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ec\u0001\u0002\n\u0014\u0001\tB\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!9\u0005A!A!\u0002\u0013A\u0005\"\u0002(\u0001\t\u0003y\u0005bB,\u0001\u0005\u0004%\t\u0001\u0017\u0005\u0007C\u0002\u0001\u000b\u0011B-\t\u000bQ\u0001A\u0011\u00012\t\u000b\u0019\u0004A\u0011A4\t\rU\u0004A\u0011A\u000bc\u0011\u00151\b\u0001\"\u0003c\u0011\u00159\b\u0001\"\u0001y\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017Aq!a\u000f\u0001\t\u0013\ti\u0004C\u0004\u0002B\u0001!I!a\u0011\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J\t9\"+\u001a9peR\u001cE.Z1oKJ|\u0005/\u001a:bi&|gn\u001d\u0006\u0003)U\tqa\u00197fC:,\bO\u0003\u0002\u0017/\u0005!\u0011.\u001c9m\u0015\tA\u0012$A\u0002k_\nT!AG\u000e\u0002\u000fI,\u0007o\u001c:ug*\u0011A$H\u0001\nq2\u0014X\r\\3bg\u0016T!AH\u0010\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0011\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0019\u0013\u0006\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VM\u001a\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nQa\u001d7gi)T\u0011AL\u0001\tOJL'P\u001f7fI&\u0011\u0001g\u000b\u0002\b\u0019><w-\u001b8h\u0003M\u0011X\r]8si*{'MU3q_NLGo\u001c:z!\t\u0019d'D\u00015\u0015\t)t#\u0001\u0006sKB|7/\u001b;pefL!a\u000e\u001b\u0003'I+\u0007o\u001c:u\u0015>\u0014'+\u001a9pg&$xN]=\u00021I,\u0007o\u001c:u\u0015>\u0014\u0017J\\:uC:\u001cWMR1di>\u0014\u0018\u0010\u0005\u0002;w5\tQ#\u0003\u0002=+\tA\"+\u001a9peRTuNY%ogR\fgnY3GC\u000e$xN]=\u0002/\r|gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\bCA B\u001b\u0005\u0001%BA\u001b\u001c\u0013\t\u0011\u0005IA\fD_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0006\u0019r\r\\8cC2\u0014V\r]8siN#xN]1hKB\u0011!(R\u0005\u0003\rV\u00111c\u00127pE\u0006d'+\u001a9peR\u001cFo\u001c:bO\u0016\f\u0001\"\u001a<f]R\u0014Uo\u001d\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017n\ta!\u001a<f]R\u001c\u0018BA'K\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\rA\u00136\u000bV+W!\t\t\u0006!D\u0001\u0014\u0011\u0015\td\u00011\u00013\u0011\u0015Ad\u00011\u0001:\u0011\u0015id\u00011\u0001?\u0011\u0015\u0019e\u00011\u0001E\u0011\u00159e\u00011\u0001I\u0003IIg.\u001b;jC2L'0\u0019;j_:$\u0016.\\3\u0016\u0003e\u0003\"AW0\u000e\u0003mS!\u0001X/\u0002\tU$\u0018\u000e\u001c\u0006\u0002=\u0006!!.\u0019<b\u0013\t\u00017L\u0001\u0003ECR,\u0017aE5oSRL\u0017\r\\5{CRLwN\u001c+j[\u0016\u0004C#A2\u0011\u0005\u0011\"\u0017BA3&\u0005\u0011)f.\u001b;\u0002\u00179|G-Z\"mK\u0006tW\u000f\u001d\u000b\u0003G\"DQ!\u001b\u0006A\u0002)\fAA\\8eKB\u00111N\u001d\b\u0003YB\u0004\"!\\\u0013\u000e\u00039T!a\\\u0011\u0002\rq\u0012xn\u001c;?\u0013\t\tX%\u0001\u0004Qe\u0016$WMZ\u0005\u0003gR\u0014aa\u0015;sS:<'BA9&\u00035\u0019H/\u0019;vg\u000ecW-\u00198va\u0006q1\u000f^8sC\u001e,7\t\\3b]V\u0004\u0018aE2mK\u0006tW\u000f]'jgNLgn\u001a(pI\u0016\u001cHCA2z\u0011\u0015QX\u00021\u0001|\u0003Q\u0019WO\u001d:f]Rtu\u000eZ3BI\u0012\u0014Xm]:fgB!A0a\u0001k\u001d\tixP\u0004\u0002n}&\ta%C\u0002\u0002\u0002\u0015\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0006\u0005\u001d!aA*fc*\u0019\u0011\u0011A\u0013\u0002\u0017\u0019\f\u0017\u000e\u001c(pI\u0016TuN\u0019\u000b\u0004G\u00065\u0001bBA\b\u001d\u0001\u0007\u0011\u0011C\u0001\u0006U>\u0014\u0017\n\u001a\t\u0005\u0003'\t)D\u0004\u0003\u0002\u0016\u0005=b\u0002BA\f\u0003WqA!!\u0007\u0002*9!\u00111DA\u0014\u001d\u0011\ti\"!\n\u000f\t\u0005}\u00111\u0005\b\u0004[\u0006\u0005\u0012\"\u0001\u0011\n\u0005yy\u0012B\u0001\u000f\u001e\u0013\tQ2$\u0003\u0002\u00193%\u0019\u0011QF\f\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u00022\u0005M\u0012A\u0006*fa>\u0014H/\u001b8h\u000b:<\u0017N\\3TKJ4\u0018nY3\u000b\u0007\u00055r#\u0003\u0003\u00028\u0005e\"a\u0003*fa>\u0014HOS8c\u0013\u0012TA!!\r\u00024\u00059!/Z9vKV,GcA2\u0002@!9\u0011qB\bA\u0002\u0005E\u0011\u0001\u00044bS2\u001cF/\u00197f\u0015>\u0014GcA2\u0002F!9\u0011q\u0002\tA\u0002\u0005E\u0011\u0001\u00024bS2$RaYA&\u0003\u001bBq!a\u0004\u0012\u0001\u0004\t\t\u0002\u0003\u0004\u0002PE\u0001\rA[\u0001\u0004[N<\u0007")
public class ReportCleanerOperations
implements Logging {
    private final ReportJobRepository reportJobRepository;
    private final ReportJobInstanceFactory reportJobInstanceFactory;
    private final ConfigurationRepository configurationRepository;
    private final GlobalReportStorage globalReportStorage;
    private final XLReleaseEventBus eventBus;
    private final Date initializationTime;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportCleanerOperations reportCleanerOperations = this;
        synchronized (reportCleanerOperations) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Date initializationTime() {
        return this.initializationTime;
    }

    public void cleanup() {
        this.statusCleanup();
        this.storageCleanup();
    }

    public void nodeCleanup(String node) {
        this.logger().debug((Function0 & Serializable)() -> "Report status cleanup for node " + node + " started");
        if (Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.reportJobRepository.startedNodeJobIds(node).foreach((Function1 & Serializable)jobId -> {
            this.failNodeJob(jobId);
            return BoxedUnit.UNIT;
        })).isFailure()) {
            this.logger().warn((Function0 & Serializable)() -> "Report status cleanup failed for jobs on node '" + node + "'");
        }
        if (Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.reportJobRepository.submittedNodeJobIds(node).foreach((Function1 & Serializable)jobId -> {
            this.requeue(jobId);
            return BoxedUnit.UNIT;
        })).isFailure()) {
            this.logger().warn((Function0 & Serializable)() -> "Requeue failed for jobs that were submitted on node '" + node + "'");
        }
        this.logger().debug((Function0 & Serializable)() -> "Report status cleanup for node " + node + " ended");
    }

    public void statusCleanup() {
        this.logger().debug((Function0 & Serializable)() -> "Report status cleanup started");
        try {
            this.reportJobRepository.startedStaleJobIds(this.initializationTime()).foreach((Function1 & Serializable)jobId -> {
                this.failStaleJob(jobId);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            this.logger().warn((Function0 & Serializable)() -> "Report status cleanup failed for stale jobs", (Function0 & Serializable)() -> e);
        }
        try {
            this.reportJobRepository.submittedStaleJobIds(this.initializationTime()).foreach((Function1 & Serializable)jobId -> {
                this.requeue(jobId);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            this.logger().warn((Function0 & Serializable)() -> "Requeue failed for previously submitted jobs", (Function0 & Serializable)() -> e);
        }
        this.logger().debug((Function0 & Serializable)() -> "Report status cleanup ended");
    }

    private void storageCleanup() {
        this.logger().debug((Function0 & Serializable)() -> "Report storage cleanup started");
        AuditReportSettings reportSettings = (AuditReportSettings)this.configurationRepository.read("Configuration/settings/AuditReportSettings");
        ReportJobFilters filter = new ReportJobFilters();
        ZonedDateTime retentionCutOffDate = LocalDateTime.now().minusDays(Predef$.MODULE$.Integer2int(reportSettings.getReportsRetentionPeriod())).atZone(ZoneId.systemDefault());
        filter.endTime_$eq(Interval.of((Instant)Instant.MIN, (Instant)retentionCutOffDate.toInstant()));
        filter.statuses_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ReportJobStatus.ABORTED.name(), (List)new .colon.colon((Object)ReportJobStatus.FAILED.name(), (List)new .colon.colon((Object)ReportJobStatus.COMPLETED.name(), (List)Nil$.MODULE$)))).asJava());
        Page<ReportJob> result = this.reportJobRepository.query(filter, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
        ListBuffer events = ListBuffer$.MODULE$.empty();
        result.get().forEach(reportJob -> {
            try {
                if ($this.globalReportStorage.cleanup((ReportJob)((Object)reportJob))) {
                    reportJob.status_$eq(ReportJobStatus.DELETED);
                    events.$plus$eq((Object)new ReportJobDeletedEvent($this.reportJobRepository.update((ReportJob)((Object)reportJob))));
                }
            }
            catch (Exception e) {
                this.logger().warn((Function0 & Serializable)() -> e.getMessage());
            }
        });
        events.foreach((Function1 & Serializable)event -> {
            this.eventBus.publish(event);
            return BoxedUnit.UNIT;
        });
        this.logger().debug((Function0 & Serializable)() -> "Report storage cleanup finished");
    }

    public void cleanupMissingNodes(scala.collection.immutable.Seq<String> currentNodeAddresses) {
        try {
            this.reportJobRepository.startedStaleNodeJobIds(currentNodeAddresses).foreach((Function1 & Serializable)jobId -> {
                this.failNodeJob(jobId);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            this.logger().warn((Function0 & Serializable)() -> "Report status cleanup failed for jobs on missing nodes. Current active nodes: '" + currentNodeAddresses.mkString(",") + "'", (Function0 & Serializable)() -> e);
        }
        try {
            this.reportJobRepository.submittedStaleNodeJobIds(currentNodeAddresses).foreach((Function1 & Serializable)jobId -> {
                this.requeue(jobId);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            this.logger().warn((Function0 & Serializable)() -> "Requeue failed for jobs that were submitted on missing nodes. Current active nodes: '" + currentNodeAddresses.mkString(",") + "'", (Function0 & Serializable)() -> e);
        }
        this.logger().debug((Function0 & Serializable)() -> "Report status cleanup for missing nodes ended");
    }

    private void failNodeJob(Integer jobId) {
        this.fail(jobId, "Job '" + jobId + "' marked as '" + ReportJobStatus.FAILED + "' because it was executing on a node that was removed from XLR cluster.");
    }

    private void requeue(Integer jobId) {
        ReportJobInstance reportJobInstance = (ReportJobInstance)this.reportJobRepository.findByJobId(jobId).map((Function1 & Serializable)reportJob -> $this.reportJobInstanceFactory.create((ReportJob)((Object)reportJob))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Job with id '" + jobId + "' not found.", new Object[0]);
        });
        reportJobInstance.enqueue();
    }

    private void failStaleJob(Integer jobId) {
        this.fail(jobId, "Job '" + jobId + "' is a stale report job that should be " + ReportJobStatus.FAILED);
    }

    private void fail(Integer jobId, String msg) {
        this.reportJobRepository.findByJobId(jobId).foreach((Function1 & Serializable)reportJob -> {
            ReportCleanerOperations.$anonfun$fail$1(this, msg, reportJob);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$fail$1(ReportCleanerOperations $this, String msg$1, ReportJob reportJob) {
        new Some((Object)$this.reportJobInstanceFactory.create(reportJob)).foreach((Function1 & Serializable)jobInstance -> {
            jobInstance.fail(new IllegalStateException(msg$1));
            return BoxedUnit.UNIT;
        });
    }

    public ReportCleanerOperations(ReportJobRepository reportJobRepository, ReportJobInstanceFactory reportJobInstanceFactory, ConfigurationRepository configurationRepository, GlobalReportStorage globalReportStorage, XLReleaseEventBus eventBus) {
        this.reportJobRepository = reportJobRepository;
        this.reportJobInstanceFactory = reportJobInstanceFactory;
        this.configurationRepository = configurationRepository;
        this.globalReportStorage = globalReportStorage;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        this.initializationTime = Date.from(Instant.now());
    }
}

