package com.xebialabs.xlrelease.reports.repository

import com.xebialabs.xlrelease.domain.udm.reporting.ItsmRecord
import com.xebialabs.xlrelease.reports.repository.CommonRowAndParamsMapper._
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.ItsmTaskReportingRecordTable
import com.xebialabs.xlrelease.repository.sql.persistence.Utils.{RichStringAsTruncatable, params}
import com.xebialabs.xlrelease.repository.sql.persistence.{Schema, TaskCiUid}

import java.sql.ResultSet

package object itsm {

  val ITSM_TASK_REPORTING_RECORD_LIVE: Schema.ITSM_TASK_REPORTING_RECORD.type = Schema.ITSM_TASK_REPORTING_RECORD
  val ITSM_TASK_REPORTING_RECORD_ARCHIVE: Schema.Archive.ITSM_TASK_REPORTING_RECORD.type = Schema.Archive.ITSM_TASK_REPORTING_RECORD

  private[itsm] def asQueryParameters(record: ItsmRecord, taskUid: TaskCiUid): Map[String, Any] = {
    mapCommonParams(record, taskUid) ++ params(
      "record" -> record.getRecord.truncate(SHORT_VARCHAR),
      "recordUrl" -> record.getRecord_url.truncate(URL_VARCHAR),
      "title" -> record.getTitle.truncate(SHORT_VARCHAR),
      "status" -> record.getStatus.truncate(SHORT_VARCHAR),
      "priority" -> record.getPriority.truncate(SHORT_VARCHAR),
      "createdBy" -> record.getCreatedBy.truncate(SHORT_VARCHAR)
    )
  }

  private[itsm] def itsmEntryRowMapper(rs: ResultSet,
                                       itsmRecord: ItsmRecord,
                                       targetId: String,
                                       itsmItemTable: ItsmTaskReportingRecordTable
                                      ): ItsmRecord = {
    mapCommonFields(rs, itsmRecord, targetId, itsmItemTable)
    itsmRecord.setRecord(rs.getString(itsmItemTable.RECORD))
    itsmRecord.setRecord_url(rs.getString(itsmItemTable.RECORD_URL))
    itsmRecord.setTitle(rs.getString(itsmItemTable.TITLE))
    itsmRecord.setStatus(rs.getString(itsmItemTable.STATUS))
    itsmRecord.setPriority(rs.getString(itsmItemTable.PRIORITY))
    itsmRecord.setCreatedBy(rs.getString(itsmItemTable.CREATED_BY))
    itsmRecord
  }

}
