package com.xebialabs.xlrelease.reports.job.impl.filesystem

import com.xebialabs.xlrelease.reports.job.api.ReportStorage.StreamingReportStorage
import org.apache.commons.io.FileUtils

import java.io.File
import java.net.URI

private[filesystem] class FileSystemStreamingReportStorage(override val localWorkDir: File, val reportDir: File) extends StreamingReportStorage {

  override def finalizeReport(localResultFile: File): URI = {
    if (localWorkDir == reportDir) {
      val contextUri = reportDir.toURI
      contextUri.relativize(localResultFile.toURI)
    } else {
      val localWorkUri = localWorkDir.toURI
      val contextUri = localWorkUri.relativize(localResultFile.toURI)
      val reportFileUri = reportDir.toURI.resolve(contextUri)
      val reportFile = new File(reportFileUri)
      val reportFileDir = reportFile.getParentFile
      reportFileDir.mkdirs()
      FileUtils.moveFile(localResultFile, reportFile)
      contextUri
    }
  }
}
