package com.xebialabs.xlrelease.reports.repository

import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.xlrelease.db.ArchivedReleases.{REPORT_TASKS_ID_COLUMN, REPORT_TASKS_RELEASEID_COLUMN, REPORT_TASKS_TABLE_NAME, REPORT_TASKS_UID_COLUMN}
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import com.xebialabs.xlrelease.repository.sql.persistence.{PersistenceSupport, TaskCiUid}
import com.xebialabs.xlrelease.repository.sql.persistence.Utils.params
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Repository

import scala.util.{Failure, Success, Try}

object ArchivedTasksRepository {
  val SELECT_TASK_UID_BY_ID: String =
    s"""|SELECT
        | $REPORT_TASKS_UID_COLUMN,
        | $REPORT_TASKS_ID_COLUMN
        |FROM $REPORT_TASKS_TABLE_NAME
        |WHERE $REPORT_TASKS_RELEASEID_COLUMN = :releaseId AND $REPORT_TASKS_ID_COLUMN = :taskId""".stripMargin
}

@Repository
class ArchivedTasksRepository(@Qualifier("reportingJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                              @Qualifier("reportingSqlDialect") val dialect: Dialect)
  extends PersistenceSupport with Logging {

  def taskUidById(taskId: CiId): Try[TaskCiUid] =
    Try {
      val releaseId = Ids.releaseIdFrom(taskId)
      sqlQuery(ArchivedTasksRepository.SELECT_TASK_UID_BY_ID, params("releaseId" -> releaseId, "taskId" -> taskId), _.getLong(REPORT_TASKS_UID_COLUMN))
        .headOption
    }.flatMap {
      case None => Failure(new NotFoundException(s"Could not find archived task by id '$taskId'"))
      case Some(uid) => Success(uid)
    }

}
