package com.xebialabs.xlrelease.reports.repository

import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.reports.repository.TitleRepository.{DELIVERY_TITLE_COLUMN, FETCH_TITLE_SQL}
import com.xebialabs.xlrelease.repository.Ids._
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.RichCiId
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport
import com.xebialabs.xlrelease.repository.sql.persistence.Utils.params
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Repository

object TitleRepository {
  val DELIVERY_TABLE_NAME = "XLR_DELIVERIES"
  val DELIVERY_TITLE_COLUMN = "TITLE"
  val FETCH_TITLE_SQL = s"SELECT $DELIVERY_TITLE_COLUMN FROM $DELIVERY_TABLE_NAME WHERE ID = :deliveryId"
}

@Repository
class TitleRepository @Autowired()(@Qualifier("xlrRepositoryJdbcTemplate") implicit val jdbcTemplate: JdbcTemplate,
                                   @Qualifier("xlrRepositorySqlDialect") implicit val dialect: Dialect) extends PersistenceSupport {

  def getDeliveryTitleById(deliveryId: String): Option[String] = {
    sqlQuery(FETCH_TITLE_SQL, params("deliveryId" -> getName(deliveryId.normalized)), (rs, _) => rs.getString(DELIVERY_TITLE_COLUMN)).headOption
  }

}
