package com.xebialabs.xlrelease.reports.service;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xebialabs.xlrelease.reports.db.ArchivedPhasesReports;
import com.xebialabs.xlrelease.reports.db.ArchivedReleasesReports;
import com.xebialabs.xlrelease.reports.db.ArchivedTasksReports;
import com.xebialabs.xlrelease.reports.dto.*;
import com.xebialabs.xlrelease.views.Point;

import io.micrometer.core.annotation.Timed;

@Service
public class ReportService {
    public static final int TOP_REPORT_SIZE = 100;

    private final ArchivedReleasesReports archivedReleasesReports;
    private final ArchivedPhasesReports archivedPhasesReports;
    private final ArchivedTasksReports archivedTasksReports;

    @Autowired
    public ReportService(final ArchivedReleasesReports archivedReleasesReports,
                         final ArchivedPhasesReports archivedPhasesReports,
                         final ArchivedTasksReports archivedTasksReports) {
        this.archivedReleasesReports = archivedReleasesReports;
        this.archivedPhasesReports = archivedPhasesReports;
        this.archivedTasksReports = archivedTasksReports;
    }

    @Timed
    public ReleasesDuration getReleaseDuration(ReportParams params) {
        List<Point> releaseDuration = archivedReleasesReports.getReleaseDuration(params);
        List<ReleaseDuration> topLongestReleases = archivedReleasesReports.getLongestReleases(params);

        return new ReleasesDuration(releaseDuration, topLongestReleases);
    }

    @Timed
    public CompletedReleases getCompletedReleases(ReportParams params) {
        return archivedReleasesReports.getCompletedReleases(params);
    }

    @Timed
    public AverageAndLongestReleaseDuration getAverageAndLongestReleaseDuration(ReportParams params) {
        return archivedReleasesReports.getAverageAndLongestReleaseDuration(params);
    }

    @Timed
    public List<UserParticipation> getTopPeopleMostInvolved(ReportParams params) {
        return archivedTasksReports.getTopPeopleInvolved(params);
    }

    @Timed
    public List<TaskDuration> getTopLongestTasks(ReportParams params) {
        return archivedTasksReports.getTopLongestTasks(params);
    }

    @Timed
    public List<LongestTaskType> getTopLongestTaskTypes(ReportParams params) {
        return archivedTasksReports.getTopLongestTaskTypes(params);
    }

    @Timed
    public AverageAndLongestTaskDuration getAverageAndLongestTaskDuration(ReportParams params) {
        return archivedTasksReports.getAverageAndLongestTaskDuration(params);
    }

    @Timed
    public ReleasesAutomation getReleaseAutomationSeries(ReportParams params) {
        ReleaseEfficiency releaseEfficiency = archivedTasksReports.getReleaseEfficiency(params);
        List<ReleaseAutomationData> releaseAutomationData = getReleaseAutomation(params);
        ReleaseAutomationComputer computer = new ReleaseAutomationComputer(releaseAutomationData, releaseEfficiency);
        return computer.get();
    }

    @Timed
    public List<PhaseDuration> getTopLongestPhases(ReportParams params) {
        return archivedPhasesReports.getTopLongestPhases(params);
    }

    @Timed
    public List<Point> getNumberOfReleaseByMonth(ReportParams params) {
        return archivedReleasesReports.getNumberOfReleaseByMonth(params);
    }

    @Timed
    public List<ReleaseAutomationData> getReleaseAutomation(ReportParams params) {
        return archivedReleasesReports.getReleaseAutomation(params);
    }
}
