/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.filters.impl;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.db.sql.archiving.BaseSelectArchivedBuilder;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Metadata(label="TagsFilter", versioned=false)
public class TagsFilter
extends ReportFilter {
    @Property(description="Operator to apply when filtering tags.", defaultValue="CONTAINS_ANY")
    private Operator operator = Operator.CONTAINS_ANY;
    @Property(description="The tags to filter.")
    private List<String> tags = new ArrayList<String>();

    public TagsFilter() {
    }

    public TagsFilter(List<String> tags) {
        this.tags = tags;
    }

    public TagsFilter(Operator operator, List<String> tags) {
        this.operator = operator;
        this.tags = tags;
    }

    public void visit(BaseSelectArchivedBuilder<?> builder) {
        if (this.operator == Operator.CONTAINS_ALL) {
            builder.withAllTags(this.tags);
        } else {
            builder.withAnyOfTags(this.tags);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TagsFilter that = (TagsFilter)((Object)o);
        return this.operator == that.operator && Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.operator, this.tags});
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public static enum Operator {
        CONTAINS_ANY("CONTAINS_ANY"),
        CONTAINS_ALL("CONTAINS_ALL");

        private String value;

        private Operator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

