from org.springframework.web.context import ContextLoader
from com.xebialabs.xlrelease.reports.filters.impl import DateFilter
from com.xebialabs.xlrelease.reports.service import ReportParams

dataSource = tile.getProperty('dataSource')
reportService = applicationContext.getBean('reportServiceCache')
dataSourceMethod = None

for method in reportService.getClass().getMethods():
    methodName = method.getName()
    if str(methodName) == ("get" + dataSource):
        dataSourceMethod = method

if dataSourceMethod is None:
    raise Exception("DataSource '%s' not found" % (dataSource))

timeFrame = None
dateFrom = None
dateTo = None

for filter in filters:
 if isinstance(filter, DateFilter):
    timeFrame = filter.timeFrame
    dateFrom = filter.from
    dateTo = filter.to

params = ReportParams.apply(timeFrame, dateFrom, dateTo, None, filters)
data = dataSourceMethod.invoke(reportService, params)
