/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.audit;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.xlplatform.io.ZipUtils$;
import com.xebialabs.xlplatform.utils.ResourceManagement$;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.utils.ReleaseIdInDatabase;
import com.xebialabs.xlrelease.planner.PlannerReleaseItem;
import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReport;
import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReportComponent$;
import com.xebialabs.xlrelease.reports.audit.ReleaseOverviewReport;
import com.xebialabs.xlrelease.reports.audit.ReportFilterMapper;
import com.xebialabs.xlrelease.reports.excel.AuditReport;
import com.xebialabs.xlrelease.reports.excel.AuditReport$;
import com.xebialabs.xlrelease.reports.excel.ExcelSheetWriter;
import com.xebialabs.xlrelease.reports.excel.MultiReleaseAuditReport;
import com.xebialabs.xlrelease.reports.excel.MultiReleaseAuditReport$;
import com.xebialabs.xlrelease.reports.excel.ReportGenerator;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.reports.job.api.ReportJobProgressMonitor;
import com.xebialabs.xlrelease.reports.job.api.ReportJobRunContext;
import com.xebialabs.xlrelease.reports.service.ReportsService;
import com.xebialabs.xlrelease.search.ReleaseCountResults;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.udm.reporting.AuditReportRequest;
import com.xebialabs.xlrelease.views.converters.ReleaseViewConverter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.joda.time.Duration;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try;

@Service
@ScalaSignature(bytes="\u0006\u0001\r\u001dv!B\"E\u0011\u0003ye!B)E\u0011\u0003\u0011\u0006\"B-\u0002\t\u0003Q\u0006bB.\u0002\u0005\u0004%\t\u0001\u0018\u0005\u0007K\u0006\u0001\u000b\u0011B/\t\u000f\u0019\f!\u0019!C\u00019\"1q-\u0001Q\u0001\nuCq\u0001[\u0001C\u0002\u0013\u0005A\f\u0003\u0004j\u0003\u0001\u0006I!\u0018\u0005\bU\u0006\u0011\r\u0011\"\u0001]\u0011\u0019Y\u0017\u0001)A\u0005;\"9A.\u0001b\u0001\n\u0003a\u0006BB7\u0002A\u0003%Q\fC\u0004o\u0003\t\u0007I\u0011\u0001/\t\r=\f\u0001\u0015!\u0003^\u0011\u001d\u0001\u0018A1A\u0005\u0002EDa\u0001_\u0001!\u0002\u0013\u0011\bbB=\u0002\u0005\u0004%\tA\u001f\u0005\u0007}\u0006\u0001\u000b\u0011B>\t\u000f}\f!\u0019!C\u0001u\"9\u0011\u0011A\u0001!\u0002\u0013Y\b\"CA\u0002\u0003\t\u0007I\u0011AA\u0003\u0011!\tY\"\u0001Q\u0001\n\u0005\u001d\u0001bBA\u000f\u0003\u0011\u0005\u0011q\u0004\u0004\u0007\u0003s\t\u0001)a\u000f\t\u0015\u0005%\u0003D!f\u0001\n\u0003\tY\u0005\u0003\u0006\u0002Na\u0011\t\u0012)A\u0005\u0003CA!\"a\u0014\u0019\u0005+\u0007I\u0011AA)\u0011)\ty\u0006\u0007B\tB\u0003%\u00111\u000b\u0005\u000b\u0003CB\"Q3A\u0005\u0002\u0005\r\u0004BCAB1\tE\t\u0015!\u0003\u0002f!1\u0011\f\u0007C\u0001\u0003\u000bC\u0011\"!%\u0019\u0003\u0003%\t!a%\t\u0013\u0005m\u0005$%A\u0005\u0002\u0005u\u0005\"CAZ1E\u0005I\u0011AA[\u0011%\tI\fGI\u0001\n\u0003\tY\f\u0003\u0005\u0002@b\t\t\u0011\"\u0011]\u0011!\t\t\rGA\u0001\n\u0003Q\b\"CAb1\u0005\u0005I\u0011AAc\u0011%\t\t\u000eGA\u0001\n\u0003\n\u0019\u000eC\u0005\u0002bb\t\t\u0011\"\u0001\u0002d\"I\u0011Q\u001e\r\u0002\u0002\u0013\u0005\u0013q\u001e\u0005\n\u0003cD\u0012\u0011!C!\u0003gD\u0011\"!>\u0019\u0003\u0003%\t%a>\b\u0013\u0005m\u0018!!A\t\u0002\u0005uh!CA\u001d\u0003\u0005\u0005\t\u0012AA\u0000\u0011\u0019IV\u0006\"\u0001\u0003\u000e!I\u0011\u0011_\u0017\u0002\u0002\u0013\u0015\u00131\u001f\u0005\n\u0005\u001fi\u0013\u0011!CA\u0005#A\u0011B!\u0007.\u0003\u0003%\tIa\u0007\t\u0013\t5R&!A\u0005\n\t=b!B)E\u0001\t]\u0002B\u0003B\u001dg\t\u0005\t\u0015!\u0003\u0003<!Q!qI\u001a\u0003\u0002\u0003\u0006IA!\u0013\t\u0015\tU3G!A!\u0002\u0013\u00119\u0006\u0003\u0006\u0003bM\u0012\t\u0011)A\u0005\u0005GB!B!\u001b4\u0005\u0003\u0005\u000b\u0011\u0002B6\u0011)\u00119h\rB\u0001B\u0003%!\u0011\u0010\u0005\u000b\u0005\u0013\u001b$\u0011!Q\u0001\n\t-\u0005B\u0003BIg\t\u0005\t\u0015!\u0003\u0003\u0014\"1\u0011l\rC\u0001\u00053CqA!34\t\u0003\u0011Y\rC\u0004\u0003vN\"IAa>\t\u000f\r\r3\u0007\"\u0003\u0004F!91QN\u001a\u0005\n\r=\u0004bBBBg\u0011\u00051Q\u0011\u0005\b\u0007\u0013\u001bD\u0011BBF\u0003\u0001jU\u000f\u001c;j%\u0016dW-Y:f\u0003V$\u0017\u000e\u001e*fa>\u0014HoQ8na>tWM\u001c;\u000b\u0005\u00153\u0015!B1vI&$(BA$I\u0003\u001d\u0011X\r]8siNT!!\u0013&\u0002\u0013ad'/\u001a7fCN,'BA&M\u0003%AXMY5bY\u0006\u00147OC\u0001N\u0003\r\u0019w.\\\u0002\u0001!\t\u0001\u0016!D\u0001E\u0005\u0001jU\u000f\u001c;j%\u0016dW-Y:f\u0003V$\u0017\u000e\u001e*fa>\u0014HoQ8na>tWM\u001c;\u0014\u0005\u0005\u0019\u0006C\u0001+X\u001b\u0005)&\"\u0001,\u0002\u000bM\u001c\u0017\r\\1\n\u0005a+&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u001f\u0006yQ\tW\"F\u0019~+\u0005\fV#O'&{e*F\u0001^!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0003mC:<'\"\u00012\u0002\t)\fg/Y\u0005\u0003I~\u0013aa\u0015;sS:<\u0017\u0001E#Y\u0007\u0016cu,\u0012-U\u000b:\u001b\u0016j\u0014(!\u00035Q\u0016\nU0F1R+ejU%P\u001d\u0006q!,\u0013)`\u000bb#VIT*J\u001f:\u0003\u0013\u0001D'B'R+%k\u0018+J)2+\u0015!D'B'R+%k\u0018+J)2+\u0005%\u0001\fN\u0003N#VIU0U\u0013RcUiX*F!\u0006\u0013\u0016\tV(S\u0003]i\u0015i\u0015+F%~#\u0016\n\u0016'F?N+\u0005+\u0011*B)>\u0013\u0006%\u0001\fT\u0013:;E*R0U\u0013RcUiX*F!\u0006\u0013\u0016\tV(S\u0003]\u0019\u0016JT$M\u000b~#\u0016\n\u0016'F?N+\u0005+\u0011*B)>\u0013\u0006%\u0001\nT\u0013:;E*R0S\u000bB{%\u000bV*`\t&\u0013\u0016aE*J\u001d\u001ecUi\u0018*F!>\u0013FkU0E\u0013J\u0003\u0013A\u0005#B)\u0016#\u0016*T#`\r>\u0013V*\u0011+U\u000bJ+\u0012A\u001d\t\u0003gZl\u0011\u0001\u001e\u0006\u0003k\u0006\fA\u0001^3yi&\u0011q\u000f\u001e\u0002\u0011'&l\u0007\u000f\\3ECR,gi\u001c:nCR\f1\u0003R!U\u000bRKU*R0G\u001fJk\u0015\t\u0016+F%\u0002\n1CR%M\u000b:\u000bU*R0N\u0003b{F*\u0012(H)\"+\u0012a\u001f\t\u0003)rL!!`+\u0003\u0007%sG/\u0001\u000bG\u00132+e*Q'F?6\u000b\u0005l\u0018'F\u001d\u001e#\u0006\nI\u0001\u0012\t\u00163\u0015)\u0016'U?B\u000bu)R0T\u0013j+\u0015A\u0005#F\r\u0006+F\nV0Q\u0003\u001e+ulU%[\u000b\u0002\n!\u0003R#G\u0003VcEkX(S\t\u0016\u0013v,T(E\u000bV\u0011\u0011q\u0001\t\u0005\u0003\u0013\t9\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u00151wN]7t\u0015\u0011\t\t\"a\u0005\u0002\u0005Y\f$bAA\u000b\u0011\u0006\u0019\u0011\r]5\n\t\u0005e\u00111\u0002\u0002\u0011%\u0016dW-Y:f\u001fJ$WM]'pI\u0016\f1\u0003R#G\u0003VcEkX(S\t\u0016\u0013v,T(E\u000b\u0002\n\u0001c]1oSRL'0\u001a$jY\u0016t\u0017-\\3\u0015\t\u0005\u0005\u0012Q\u0007\t\u0005\u0003G\t\tD\u0004\u0003\u0002&\u00055\u0002cAA\u0014+6\u0011\u0011\u0011\u0006\u0006\u0004\u0003Wq\u0015A\u0002\u001fs_>$h(C\u0002\u00020U\u000ba\u0001\u0015:fI\u00164\u0017b\u00013\u00024)\u0019\u0011qF+\t\u000f\u0005]r\u00031\u0001\u0002\"\u0005Aa-\u001b7f]\u0006lWM\u0001\u0003ECR\f7C\u0002\rT\u0003{\t\u0019\u0005E\u0002U\u0003\u007fI1!!\u0011V\u0005\u001d\u0001&o\u001c3vGR\u00042\u0001VA#\u0013\r\t9%\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\fO\u0016tWM]1uK\u0012\u0014\u00150\u0006\u0002\u0002\"\u0005aq-\u001a8fe\u0006$X\r\u001a\"zA\u0005Yq-\u001a8fe\u0006$X\rZ(o+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005mSBAA,\u0015\r\tI&Y\u0001\u0005kRLG.\u0003\u0003\u0002^\u0005]#\u0001\u0002#bi\u0016\fAbZ3oKJ\fG/\u001a3P]\u0002\nQB]3q_J$h)\u001b7uKJ\u001cXCAA3!\u0019\t9'!\u001d\u0002x9!\u0011\u0011NA7\u001d\u0011\t9#a\u001b\n\u0003YK1!a\u001cV\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001d\u0002v\t\u00191+Z9\u000b\u0007\u0005=T\u000b\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\tiHR\u0001\bM&dG/\u001a:t\u0013\u0011\t\t)a\u001f\u0003\u0019I+\u0007o\u001c:u\r&dG/\u001a:\u0002\u001dI,\u0007o\u001c:u\r&dG/\u001a:tAQA\u0011qQAF\u0003\u001b\u000by\tE\u0002\u0002\nbi\u0011!\u0001\u0005\b\u0003\u0013z\u0002\u0019AA\u0011\u0011\u001d\tye\ba\u0001\u0003'Bq!!\u0019 \u0001\u0004\t)'\u0001\u0003d_BLH\u0003CAD\u0003+\u000b9*!'\t\u0013\u0005%\u0003\u0005%AA\u0002\u0005\u0005\u0002\"CA(AA\u0005\t\u0019AA*\u0011%\t\t\u0007\tI\u0001\u0002\u0004\t)'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}%\u0006BA\u0011\u0003C[#!a)\u0011\t\u0005\u0015\u0016qV\u0007\u0003\u0003OSA!!+\u0002,\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003[+\u0016AC1o]>$\u0018\r^5p]&!\u0011\u0011WAT\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t9L\u000b\u0003\u0002T\u0005\u0005\u0016AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003{SC!!\u001a\u0002\"\u0006i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002H\u00065\u0007c\u0001+\u0002J&\u0019\u00111Z+\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002P\u001a\n\t\u00111\u0001|\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u001b\t\u0007\u0003/\fi.a2\u000e\u0005\u0005e'bAAn+\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0017\u0011\u001c\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002f\u0006-\bc\u0001+\u0002h&\u0019\u0011\u0011^+\u0003\u000f\t{w\u000e\\3b]\"I\u0011q\u001a\u0015\u0002\u0002\u0003\u0007\u0011qY\u0001\tQ\u0006\u001c\bnQ8eKR\t10\u0001\u0005u_N#(/\u001b8h)\u0005i\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002f\u0006e\b\"CAhW\u0005\u0005\t\u0019AAd\u0003\u0011!\u0015\r^1\u0011\u0007\u0005%UfE\u0003.\u0005\u0003\t\u0019\u0005\u0005\u0007\u0003\u0004\t%\u0011\u0011EA*\u0003K\n9)\u0004\u0002\u0003\u0006)\u0019!qA+\u0002\u000fI,h\u000e^5nK&!!1\u0002B\u0003\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003{\fQ!\u00199qYf$\u0002\"a\"\u0003\u0014\tU!q\u0003\u0005\b\u0003\u0013\u0002\u0004\u0019AA\u0011\u0011\u001d\ty\u0005\ra\u0001\u0003'Bq!!\u00191\u0001\u0004\t)'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tu!\u0011\u0006\t\u0006)\n}!1E\u0005\u0004\u0005C)&AB(qi&|g\u000eE\u0005U\u0005K\t\t#a\u0015\u0002f%\u0019!qE+\u0003\rQ+\b\u000f\\34\u0011%\u0011Y#MA\u0001\u0002\u0004\t9)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u0007\t\u0004=\nM\u0012b\u0001B\u001b?\n1qJ\u00196fGR\u001c\"aM*\u0002\u001dI,\u0007o\u001c:ugN+'O^5dKB!!Q\bB\"\u001b\t\u0011yDC\u0002\u0003B\u0019\u000bqa]3sm&\u001cW-\u0003\u0003\u0003F\t}\"A\u0004*fa>\u0014Ho]*feZL7-Z\u0001\u0010e\u0016\u0004xN\u001d;HK:,'/\u0019;peB!!1\nB)\u001b\t\u0011iEC\u0002\u0003P\u0019\u000bQ!\u001a=dK2LAAa\u0015\u0003N\ty!+\u001a9peR<UM\\3sCR|'/\u0001\u000bsK2,\u0017m]3TK\u0006\u00148\r[*feZL7-\u001a\t\u0005\u00053\u0012i&\u0004\u0002\u0003\\)\u0019!\u0011\t%\n\t\t}#1\f\u0002\u0015%\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u0002\u001dI,G.Z1tKN+'O^5dKB!!\u0011\fB3\u0013\u0011\u00119Ga\u0017\u0003\u001dI+G.Z1tKN+'O^5dK\u0006\u00192/\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]B!!Q\u000eB:\u001b\t\u0011yGC\u0002\u0003r)\u000b\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0005k\u0012yGA\nTKJ4XM]\"p]\u001aLw-\u001e:bi&|g.\u0001\u000bsK2,\u0017m]3WS\u0016<8i\u001c8wKJ$XM\u001d\t\u0005\u0005w\u0012))\u0004\u0002\u0003~)!!q\u0010BA\u0003)\u0019wN\u001c<feR,'o\u001d\u0006\u0004\u0005\u0007C\u0015!\u0002<jK^\u001c\u0018\u0002\u0002BD\u0005{\u0012ACU3mK\u0006\u001cXMV5fo\u000e{gN^3si\u0016\u0014\u0018!\u0005;bg.\f5mY3tgN+'O^5dKB!!\u0011\fBG\u0013\u0011\u0011yIa\u0017\u0003#Q\u000b7o[!dG\u0016\u001c8oU3sm&\u001cW-\u0001\nsKB|'\u000f\u001e$jYR,'/T1qa\u0016\u0014\bc\u0001)\u0003\u0016&\u0019!q\u0013#\u0003%I+\u0007o\u001c:u\r&dG/\u001a:NCB\u0004XM\u001d\u000b\u0013\u00057\u0013iJa(\u0003\"\n\r&Q\u0015BT\u0005S\u0013Y\u000b\u0005\u0002Qg!9!\u0011\b\u001fA\u0002\tm\u0002b\u0002B$y\u0001\u0007!\u0011\n\u0005\b\u0005+b\u0004\u0019\u0001B,\u0011\u001d\u0011\t\u0007\u0010a\u0001\u0005GBqA!\u001b=\u0001\u0004\u0011Y\u0007C\u0004\u0003xq\u0002\rA!\u001f\t\u000f\t%E\b1\u0001\u0003\f\"9!\u0011\u0013\u001fA\u0002\tM\u0005f\u0001\u001f\u00030B!!\u0011\u0017Bc\u001b\t\u0011\u0019L\u0003\u0003\u0002.\nU&\u0002\u0002B\\\u0005s\u000bqAZ1di>\u0014\u0018P\u0003\u0003\u0003<\nu\u0016!\u00022fC:\u001c(\u0002\u0002B`\u0005\u0003\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0005\u0007\f1a\u001c:h\u0013\u0011\u00119Ma-\u0003\u0013\u0005+Ho\\<je\u0016$\u0017AD4f]\u0016\u0014\u0018\r^3SKB|'\u000f\u001e\u000b\u0007\u0005\u001b\u0014INa9\u0011\t\t='Q[\u0007\u0003\u0005#T1Aa5b\u0003\tIw.\u0003\u0003\u0003X\nE'\u0001\u0002$jY\u0016DqAa7>\u0001\u0004\u0011i.\u0001\tsKB|'\u000f\u001e#fM&t\u0017\u000e^5p]B\u0019\u0001Ka8\n\u0007\t\u0005HIA\fNk2$\u0018NU3mK\u0006\u001cX-Q;eSR\u0014V\r]8si\"9!Q]\u001fA\u0002\t\u001d\u0018a\u0005:fa>\u0014HOS8c%Vt7i\u001c8uKb$\b\u0003\u0002Bu\u0005cl!Aa;\u000b\t\u0005U!Q\u001e\u0006\u0004\u0005_4\u0015a\u00016pE&!!1\u001fBv\u0005M\u0011V\r]8si*{'MU;o\u0007>tG/\u001a=u\u0003m9WM\\3sCR,7+\u001b8hY\u0016\u0014V\r\\3bg\u0016\u0014V\r]8siR1!\u0011`B\u000e\u0007_\u0001BAa?\u0004\u00169!!Q`B\t\u001d\u0011\u0011ypa\u0004\u000f\t\r\u00051Q\u0002\b\u0005\u0007\u0007\u0019YA\u0004\u0003\u0004\u0006\r%a\u0002BA\u0014\u0007\u000fI\u0011!T\u0005\u0003\u00172K!!\u0013&\n\u0005\u001dC\u0015b\u0001B(\r&!11\u0003B'\u0003]iU\u000f\u001c;j%\u0016dW-Y:f\u0003V$\u0017\u000e\u001e*fa>\u0014H/\u0003\u0003\u0004\u0018\re!A\u0004)feJ+G.Z1tK\u0012\u000bG/\u0019\u0006\u0005\u0007'\u0011i\u0005C\u0004\u0004\u001ey\u0002\raa\b\u0002\u000f]|'o\u001b#jeB!1\u0011EB\u0016\u001b\t\u0019\u0019C\u0003\u0003\u0004&\r\u001d\u0012\u0001\u00024jY\u0016T1a!\u000bb\u0003\rq\u0017n\\\u0005\u0005\u0007[\u0019\u0019C\u0001\u0003QCRD\u0007bBB\u0019}\u0001\u000711G\u0001\ne\u0016dW-Y:f\u0013\u0012\u0004Ba!\u000e\u0004@5\u00111q\u0007\u0006\u0005\u0007s\u0019Y$A\u0003vi&d7OC\u0002\u0004>!\u000ba\u0001Z8nC&t\u0017\u0002BB!\u0007o\u00111CU3mK\u0006\u001cX-\u00133J]\u0012\u000bG/\u00192bg\u0016\f1b\u001e:ji\u0016$vNR5mKRQ!QZB$\u0007\u0013\u001a)g!\u001b\t\u000f\ruq\b1\u0001\u0004 !911J A\u0002\r5\u0013\u0001C<pe.\u0014un\\6\u0011\t\r=3\u0011M\u0007\u0003\u0007#RAaa\u0015\u0004V\u0005IQo]3s[>$W\r\u001c\u0006\u0005\u0007/\u001aI&\u0001\u0002tg*!11LB/\u0003\r\u0001x.\u001b\u0006\u0005\u0007?\u0012\t-\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0007G\u001a\tF\u0001\u0005X_J\\'m\\8l\u0011\u001d\u00199g\u0010a\u0001\u0003'\nA\u0001Z1uK\"911N A\u0002\u0005\u0005\u0012!\u0002;ji2,\u0017\u0001D5ogR\fgnY3ECR\fWCAB9!\u0011\u0019\u0019h! \u000f\t\rU4\u0011\u0010\b\u0005\u0005\u007f\u001c9(\u0003\u0002F\r&\u001911\u0010#\u0002+I+G.Z1tK>3XM\u001d<jK^\u0014V\r]8si&!1qPBA\u00051Ien\u001d;b]\u000e,G)\u0019;b\u0015\r\u0019Y\bR\u0001\baJ,g/[3x)\u0011\t9ma\"\t\u000f\tm\u0017\t1\u0001\u0003^\u0006qam\u001c:nCR$UO]1uS>tG\u0003BA\u0011\u0007\u001bCqaa$C\u0001\u0004\u0019\t*A\u0004sK2,\u0017m]3\u0011\t\rM5QS\u0007\u0003\u0007wIAaa&\u0004<\t9!+\u001a7fCN,\u0007fA\u001a\u0004\u001cB!1QTBR\u001b\t\u0019yJ\u0003\u0003\u0004\"\nu\u0016AC:uKJ,w\u000e^=qK&!1QUBP\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class MultiReleaseAuditReportComponent {
    private final ReportsService reportsService;
    private final ReleaseSearchService releaseSearchService;
    private final ServerConfiguration serverConfiguration;
    private final ReleaseViewConverter releaseViewConverter;
    private final TaskAccessService taskAccessService;
    private final ReportFilterMapper reportFilterMapper;

    public static String sanitizeFilename(String string) {
        return MultiReleaseAuditReportComponent$.MODULE$.sanitizeFilename(string);
    }

    public static ReleaseOrderMode DEFAULT_ORDER_MODE() {
        return MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_ORDER_MODE();
    }

    public static int DEFAULT_PAGE_SIZE() {
        return MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_PAGE_SIZE();
    }

    public static int FILENAME_MAX_LENGTH() {
        return MultiReleaseAuditReportComponent$.MODULE$.FILENAME_MAX_LENGTH();
    }

    public static SimpleDateFormat DATETIME_FORMATTER() {
        return MultiReleaseAuditReportComponent$.MODULE$.DATETIME_FORMATTER();
    }

    public static String SINGLE_REPORTS_DIR() {
        return MultiReleaseAuditReportComponent$.MODULE$.SINGLE_REPORTS_DIR();
    }

    public static String SINGLE_TITLE_SEPARATOR() {
        return MultiReleaseAuditReportComponent$.MODULE$.SINGLE_TITLE_SEPARATOR();
    }

    public static String MASTER_TITLE_SEPARATOR() {
        return MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE_SEPARATOR();
    }

    public static String MASTER_TITLE() {
        return MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE();
    }

    public static String ZIP_EXTENSION() {
        return MultiReleaseAuditReportComponent$.MODULE$.ZIP_EXTENSION();
    }

    public static String EXCEL_EXTENSION() {
        return MultiReleaseAuditReportComponent$.MODULE$.EXCEL_EXTENSION();
    }

    public File generateReport(MultiReleaseAuditReport reportDefinition, ReportJobRunContext reportJobRunContext) {
        Data data = new Data(reportDefinition.getGeneratedBy(), reportDefinition.getGeneratedOn(), (Seq<ReportFilter>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(reportDefinition.filters()).asScala()));
        Seq releaseIds = this.releaseSearchService.searchAllIdsWithoutPermissionsCheck(data.reportFilters(), (Option)new Some((Object)ReleaseOrderMode.start_date), this.releaseSearchService.searchAllIdsWithoutPermissionsCheck$default$3(), this.releaseSearchService.searchAllIdsWithoutPermissionsCheck$default$4());
        int totalWorkItems = releaseIds.length() + 3;
        ReportJobProgressMonitor progressMonitor = reportJobRunContext.reportJobProgressMonitor();
        progressMonitor.sendTotalWorkItems(totalWorkItems);
        File workDir = reportJobRunContext.reportStorage().workdir();
        String reportDirName = new StringBuilder(0).append(MultiReleaseAuditReportComponent$.MODULE$.DATETIME_FORMATTER().format(data.generatedOn())).append(MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE_SEPARATOR()).append(MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE()).toString();
        Path reportDir = Paths.get(workDir.getPath(), reportDirName);
        Path reportsDir = reportDir.resolve(MultiReleaseAuditReportComponent$.MODULE$.SINGLE_REPORTS_DIR());
        reportsDir.toFile().mkdirs();
        scala.collection.immutable.Map releasesData = (scala.collection.immutable.Map)releaseIds.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Map done = (scala.collection.immutable.Map)tuple2._1();
            ReleaseIdInDatabase id = (ReleaseIdInDatabase)tuple2._2();
            scala.collection.immutable.Map toR = done.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)id.adaptiveReleaseId()), (Object)this.generateSingleReleaseReport(reportsDir, id)));
            progressMonitor.sendCompletedWorkItems(toR.keys().size());
            scala.collection.immutable.Map map = toR;
            return map;
        });
        MultiReleaseAuditReport.Data masterData = new MultiReleaseAuditReport.Data(data.generatedBy(), data.generatedOn(), this.instanceData(), this.reportFilterMapper.map(data.reportFilters()), (Seq<MultiReleaseAuditReport.PerReleaseData>)releasesData.values().toSeq());
        Workbook masterWorkBook = MultiReleaseAuditReport$.MODULE$.getWorkBook(masterData);
        File masterFile = this.writeToFile(reportDir, masterWorkBook, data.generatedOn(), MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE());
        progressMonitor.sendCompletedWorkItems(releaseIds.length() + 1);
        File file2 = masterFile;
        scala.collection.immutable.Map allFilesMap = ((TraversableOnce)((TraversableLike)((TraversableOnce)releasesData.values().map((Function1 & Serializable & scala.Serializable)x$1 -> (File)((Tuple2)x$1.storedPath().get())._1(), Iterable$.MODULE$.canBuildFrom())).toSeq().$plus$colon((Object)file2, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)file -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(file.getPath())).stripPrefix(workDir.getPath()))).stripPrefix(File.separator)), (Object)new FileInputStream((File)file)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        File fullReport = ZipUtils$.MODULE$.create(allFilesMap, reportDir.resolve(new StringBuilder(0).append(MultiReleaseAuditReportComponent$.MODULE$.DATETIME_FORMATTER().format(data.generatedOn())).append(MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE_SEPARATOR()).append(MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE()).append(MultiReleaseAuditReportComponent$.MODULE$.ZIP_EXTENSION()).toString()).toFile());
        progressMonitor.sendCompletedWorkItems(releaseIds.length() + 2);
        FileUtils.deleteDirectory((File)reportsDir.toFile());
        masterFile.delete();
        progressMonitor.sendCompletedWorkItems(totalWorkItems);
        return fullReport;
    }

    private MultiReleaseAuditReport.PerReleaseData generateSingleReleaseReport(Path workDir, ReleaseIdInDatabase releaseId) {
        MultiReleaseAuditReport.PerReleaseData perReleaseData;
        try {
            Release release = this.reportsService.findReleaseByReleaseIdInDatabase(releaseId);
            AuditReport.Data data = this.reportsService.fetchAuditReportData(release);
            Workbook workBook = AuditReport$.MODULE$.getWorkBook(data);
            Try<Either<Tuple2<Throwable, String>, String>> folder = this.reportsService.formattedReleaseFolderPath(release.getId());
            File stored = this.writeToFile(workDir, workBook, data.releaseTree().release().getStartOrScheduledDate(), data.releaseTree().release().getTitle());
            PlannerReleaseItem root = data.releaseTree().root();
            perReleaseData = new MultiReleaseAuditReport.PerReleaseData(release.getTitle(), release.getOwner(), folder, (Date)Option$.MODULE$.apply((Object)release.getStartDate()).getOrElse((Function0 & Serializable & scala.Serializable)() -> release.getScheduledStartDate()), (Either<Date, Date>)((Either)root.endDate().map((Function1 & Serializable & scala.Serializable)dt -> package$.MODULE$.Left().apply((Object)dt.toDate())).orElse((Function0 & Serializable & scala.Serializable)() -> root.dueDate().map((Function1 & Serializable & scala.Serializable)dt -> package$.MODULE$.Right().apply((Object)dt.toDate()))).get()), this.formatDuration(release), release.getStatus(), data.releaseOverviewData().startedBy(), (Option<Tuple2<File, String>>)new Some((Object)new Tuple2((Object)stored, (Object)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(stored.getPath())).stripPrefix(workDir.getParent().toFile().getPath()))).stripPrefix(File.separator))), data.releaseOverviewData().templateInfo());
        }
        catch (Exception e) {
            throw new IllegalStateException(new StringBuilder(41).append("Unable to generate individual report for ").append(releaseId).toString(), e);
        }
        return perReleaseData;
    }

    private File writeToFile(Path workDir, Workbook workBook, Date date, String title) {
        String sanitizedTitle = MultiReleaseAuditReportComponent$.MODULE$.sanitizeFilename(title);
        String reportFileName = new StringBuilder(0).append(MultiReleaseAuditReportComponent$.MODULE$.DATETIME_FORMATTER().format(date)).append(MultiReleaseAuditReportComponent$.MODULE$.SINGLE_TITLE_SEPARATOR()).append(sanitizedTitle).toString();
        File stored = workDir.resolve(new StringBuilder(0).append(reportFileName).append(MultiReleaseAuditReportComponent$.MODULE$.EXCEL_EXTENSION()).toString()).toFile();
        int fileCounter = 1;
        while (stored.exists()) {
            stored = workDir.resolve(new StringBuilder(0).append(reportFileName).append(MultiReleaseAuditReportComponent$.MODULE$.SINGLE_TITLE_SEPARATOR()).append(fileCounter).append(MultiReleaseAuditReportComponent$.MODULE$.EXCEL_EXTENSION()).toString()).toFile();
            ++fileCounter;
        }
        ResourceManagement$.MODULE$.using((Closeable)new FileOutputStream(stored), (Function1 & Serializable & scala.Serializable)x$1 -> {
            workBook.write(x$1);
            return BoxedUnit.UNIT;
        });
        return stored;
    }

    private ReleaseOverviewReport.InstanceData instanceData() {
        Option<String> instanceName = this.reportsService.getInstanceName();
        Option instanceUrl = Option$.MODULE$.apply((Object)this.serverConfiguration.getServerUrl());
        Option<String> xlrVersion = this.reportsService.getInstanceVersion();
        return new ReleaseOverviewReport.InstanceData(instanceName, (Option<String>)instanceUrl, xlrVersion);
    }

    public Object preview(MultiReleaseAuditReport reportDefinition) {
        AuditReportRequest reportRequest = new AuditReportRequest((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(reportDefinition.filters()).asScala(), Option$.MODULE$.apply((Object)MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_ORDER_MODE()));
        List<Release> releases = this.reportsService.getReleasesForPreview(reportRequest, 0L, MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_PAGE_SIZE());
        ReleaseCountResults releaseCount = this.reportsService.getReleasesCountByStatus(reportRequest);
        List properties = Collections.emptyList();
        List<String> extensions = Collections.singletonList("progress");
        Buffer views = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(releases).asScala()).map((Function1 & Serializable & scala.Serializable)r -> $this.releaseViewConverter.toFullView(r, $this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser(), properties, extensions, 2), Buffer$.MODULE$.canBuildFrom());
        return JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releases"), JavaConverters$.MODULE$.bufferAsJavaListConverter(views).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releaseCount"), (Object)releaseCount)}))).asJava();
    }

    private String formatDuration(Release release) {
        Duration duration = (Duration)Option$.MODULE$.apply((Object)release.getActualDuration()).getOrElse((Function0 & Serializable & scala.Serializable)() -> release.getComputedPlannedDuration());
        return ExcelSheetWriter.PERIOD_FORMATTER.print((ReadablePeriod)duration.toPeriod().normalizedStandard(PeriodType.dayTime()));
    }

    @Autowired
    public MultiReleaseAuditReportComponent(ReportsService reportsService, ReportGenerator reportGenerator, ReleaseSearchService releaseSearchService, ReleaseService releaseService, ServerConfiguration serverConfiguration, ReleaseViewConverter releaseViewConverter, TaskAccessService taskAccessService, ReportFilterMapper reportFilterMapper) {
        this.reportsService = reportsService;
        this.releaseSearchService = releaseSearchService;
        this.serverConfiguration = serverConfiguration;
        this.releaseViewConverter = releaseViewConverter;
        this.taskAccessService = taskAccessService;
        this.reportFilterMapper = reportFilterMapper;
    }

    public static class Data
    implements Product,
    scala.Serializable {
        private final String generatedBy;
        private final Date generatedOn;
        private final Seq<ReportFilter> reportFilters;

        public String generatedBy() {
            return this.generatedBy;
        }

        public Date generatedOn() {
            return this.generatedOn;
        }

        public Seq<ReportFilter> reportFilters() {
            return this.reportFilters;
        }

        public Data copy(String generatedBy, Date generatedOn, Seq<ReportFilter> reportFilters) {
            return new Data(generatedBy, generatedOn, reportFilters);
        }

        public String copy$default$1() {
            return this.generatedBy();
        }

        public Date copy$default$2() {
            return this.generatedOn();
        }

        public Seq<ReportFilter> copy$default$3() {
            return this.reportFilters();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Seq<ReportFilter> seq;
            int n = x$1;
            switch (n) {
                case 0: {
                    seq = this.generatedBy();
                    break;
                }
                case 1: {
                    seq = this.generatedOn();
                    break;
                }
                case 2: {
                    seq = this.reportFilters();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return seq;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            String string = this.generatedBy();
            String string2 = data.generatedBy();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Date date = this.generatedOn();
            Date date2 = data.generatedOn();
            if (date == null) {
                if (date2 != null) {
                    return false;
                }
            } else if (!((Object)date).equals(date2)) return false;
            Seq<ReportFilter> seq = this.reportFilters();
            Seq<ReportFilter> seq2 = data.reportFilters();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(String generatedBy, Date generatedOn, Seq<ReportFilter> reportFilters) {
            this.generatedBy = generatedBy;
            this.generatedOn = generatedOn;
            this.reportFilters = reportFilters;
            Product.$init$((Product)this);
        }
    }
}

