/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.api;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.utils.ResponseHelper;
import com.xebialabs.xlrelease.api.v1.UserApi;
import com.xebialabs.xlrelease.api.v1.forms.TimeFrame;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.reports.api.ReportForm;
import com.xebialabs.xlrelease.reports.dto.AverageAndLongestReleaseDuration;
import com.xebialabs.xlrelease.reports.dto.AverageAndLongestTaskDuration;
import com.xebialabs.xlrelease.reports.dto.CompletedReleases;
import com.xebialabs.xlrelease.reports.dto.LongestTaskType;
import com.xebialabs.xlrelease.reports.dto.PhaseDuration;
import com.xebialabs.xlrelease.reports.dto.ReleaseAutomationData;
import com.xebialabs.xlrelease.reports.dto.ReleasesAutomation;
import com.xebialabs.xlrelease.reports.dto.ReleasesDuration;
import com.xebialabs.xlrelease.reports.dto.TaskDuration;
import com.xebialabs.xlrelease.reports.dto.UserParticipation;
import com.xebialabs.xlrelease.reports.job.api.ReportDefinition;
import com.xebialabs.xlrelease.reports.job.api.ReportingEngineService;
import com.xebialabs.xlrelease.reports.job.api.StreamingReportResult;
import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.domain.ReportJobStatus;
import com.xebialabs.xlrelease.reports.service.ReportParams;
import com.xebialabs.xlrelease.reports.service.ReportServiceCache;
import com.xebialabs.xlrelease.reports.utils.ReportUtils;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.views.Point;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/reports")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ReportResource {
    private PermissionChecker permissions;
    private ReportServiceCache reportService;
    private ReportingEngineService reportingEngineService;
    private UserProfileService userProfileService;

    @Autowired
    public ReportResource(PermissionChecker permissions, ReportServiceCache reportService, ReportingEngineService reportingEngineService, UserProfileService userProfileService) {
        this.permissions = permissions;
        this.reportService = reportService;
        this.reportingEngineService = reportingEngineService;
        this.userProfileService = userProfileService;
    }

    @POST
    @Timed
    @Path(value="releases/duration")
    public ReleasesDuration getReleaseDuration(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getReleaseDuration(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="most-involved-people")
    public List<UserParticipation> getTopPeopleMostInvolved(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getTopPeopleMostInvolved(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="longest-tasks")
    public List<TaskDuration> getTopLongestTasks(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getTopLongestTasks(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="longest-task-types")
    public List<LongestTaskType> getTopLongestTaskTypes(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getTopLongestTaskTypes(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="average-and-longest-task-duration")
    public AverageAndLongestTaskDuration getAverageAndLongestTaskDuration(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getAverageAndLongestTaskDuration(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="release/completed")
    public CompletedReleases getCompletedReleases(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getCompletedReleases(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="release/average-and-longest-release-duration")
    public AverageAndLongestReleaseDuration getAverageAndLongestReleaseDuration(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getAverageAndLongestReleaseDuration(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="releases/automation")
    public ReleasesAutomation getReleaseAutomation(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getReleaseAutomationSeries(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="longest-phases")
    public List<PhaseDuration> getTopLongestPhases(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getTopLongestPhases(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="releases/number-by-month")
    public List<Point> getNumberOfReleaseByMonth(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getNumberOfReleaseByMonth(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="releases/most-recent/{limit}")
    public List<ReleaseAutomationData> getMostRecentReleaseData(@PathParam(value="limit") Integer limit, ReportForm reportForm) {
        this.checkPermission(reportForm);
        ReportParams params = ReportParams.apply(TimeFrame.RANGE, reportForm.getFrom(), reportForm.getTo(), ReportUtils.splitTags(reportForm.getTags()), reportForm.getFilters(), reportForm.isUserSpecific(), limit, reportForm.isRefresh());
        return this.reportService.getMostRecentReleasesData(params);
    }

    private void checkPermission(ReportForm reportForm) {
        if (!this.permissions.hasGlobalPermission(XLReleasePermissions.AUDIT_ALL) && reportForm.isUserSpecific()) {
            this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        }
    }

    @POST
    @Path(value="preview")
    @Produces(value={"application/json"})
    public Response preview(ReportDefinition report) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        String generatedBy = Permissions.getAuthenticatedUserName();
        report.setGeneratedBy(generatedBy);
        Map response = (Map)this.reportingEngineService.preview(report);
        return Response.ok((Object)response).build();
    }

    @POST
    @Path(value="submit")
    @Produces(value={"application/json"})
    public Response submit(ReportDefinition report) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        String generatedBy = Permissions.getAuthenticatedUserName();
        UserProfile userProfile = this.userProfileService.findByUsername(generatedBy);
        if (this.isValidEmailConfigured(userProfile.getEmail())) {
            report.setGeneratedBy(generatedBy);
            Integer jobId = this.reportingEngineService.submit(report);
            return Response.ok(Collections.singletonMap("jobId", jobId)).build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="download/{jobId}")
    @Produces(value={"application/octet-stream"})
    public Response download(@PathParam(value="jobId") Integer jobId) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        StreamingReportResult reportResult = this.reportingEngineService.getResult(jobId);
        return ResponseHelper.streamFile((String)reportResult.fileName(), reportResult::write, (String)reportResult.contentType());
    }

    @GET
    @Path(value="status/{jobId}")
    @Produces(value={"application/json"})
    public Response status(@PathParam(value="jobId") Integer jobId) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        ReportJobStatus status = this.reportingEngineService.status(jobId);
        return Response.ok((Object)((Object)status)).build();
    }

    @GET
    @Path(value="{jobId}")
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="jobId") Integer jobId) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        ReportJob reportJob = this.reportingEngineService.get(jobId);
        return Response.ok((Object)((Object)reportJob)).build();
    }

    @POST
    @Path(value="run")
    @Produces(value={"application/octet-stream"})
    public Response run(ReportDefinition report) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        String generatedBy = Permissions.getAuthenticatedUserName();
        report.setGeneratedBy(generatedBy);
        StreamingReportResult reportResult = this.reportingEngineService.run(report);
        return ResponseHelper.streamFile((String)reportResult.fileName(), reportResult::write, (String)reportResult.contentType());
    }

    private boolean isValidEmailConfigured(String email) {
        return Strings.isNotBlank((String)email) && UserApi.isValidEmailAddress((String)email);
    }

    public static enum ReportType {
        RELEASE_DURATION,
        RELEASE_AUTOMATION,
        TOP_PEOPLE_MOST_INVOLVED,
        TOP_LONGEST_TASK,
        TOP_LONGEST_PHASE,
        TOP_LONGEST_RELEASE,
        NUMBER_OF_RELEASE_BY_MONTH;

    }
}

