/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.job.handlers;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.configuration.AuditReportSettings;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.notifications.AuditReportJobCompleted;
import com.xebialabs.xlrelease.notifications.AuditReportJobFailed;
import com.xebialabs.xlrelease.notifications.NotificationService;
import com.xebialabs.xlrelease.notifications.NotificationTrigger;
import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReport;
import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.events.ReportJobCompletedEvent;
import com.xebialabs.xlrelease.reports.job.events.ReportJobFailedEvent;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001\u0002\u0005\n\u0001YA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A1\u0007\u0001B\u0001B\u0003%A\u0007C\u0003;\u0001\u0011\u00051\bC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003d\u0001\u0011\u0005A\rC\u0003k\u0001\u0011%1NA\u0011SKB|'\u000f\u001e&pE:{G/\u001b4jG\u0006$\u0018n\u001c8Fm\u0016tG\u000fS1oI2,'O\u0003\u0002\u000b\u0017\u0005A\u0001.\u00198eY\u0016\u00148O\u0003\u0002\r\u001b\u0005\u0019!n\u001c2\u000b\u00059y\u0011a\u0002:fa>\u0014Ho\u001d\u0006\u0003!E\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005I\u0019\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005!\u0012aA2p[\u000e\u00011c\u0001\u0001\u0018;A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u0004\"AH\u0012\u000e\u0003}Q!\u0001I\u0011\u0002\u000bMdg\r\u000e6\u000b\u0003\t\n\u0001b\u001a:jujdW\rZ\u0005\u0003I}\u0011q\u0001T8hO&tw-A\no_RLg-[2bi&|gnU3sm&\u001cW\r\u0005\u0002(U5\t\u0001F\u0003\u0002*\u001f\u0005ian\u001c;jM&\u001c\u0017\r^5p]NL!a\u000b\u0015\u0003'9{G/\u001b4jG\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0002'M,'O^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u00059\nT\"A\u0018\u000b\u0005A\n\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005Iz#aE*feZ,'oQ8oM&<WO]1uS>t\u0017aF2p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z!\t)\u0004(D\u00017\u0015\t9t\"\u0001\u0006sKB|7/\u001b;pefL!!\u000f\u001c\u0003/\r{gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\u0018A\u0002\u001fj]&$h\b\u0006\u0003=}}\u0002\u0005CA\u001f\u0001\u001b\u0005I\u0001\"B\u0013\u0005\u0001\u00041\u0003\"\u0002\u0017\u0005\u0001\u0004i\u0003\"B\u001a\u0005\u0001\u0004!\u0004F\u0001\u0003C!\t\u0019e*D\u0001E\u0015\t)e)\u0001\u0006b]:|G/\u0019;j_:T!a\u0012%\u0002\u000f\u0019\f7\r^8ss*\u0011\u0011JS\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u00172\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u001b\u0006\u0019qN]4\n\u0005=#%!C!vi><\u0018N]3e\u0003QygNU3q_J$(j\u001c2D_6\u0004H.\u001a;fIR\u0011!+\u0016\t\u00031MK!\u0001V\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006-\u0016\u0001\raV\u0001\u0006KZ,g\u000e\u001e\t\u00031nk\u0011!\u0017\u0006\u00035.\ta!\u001a<f]R\u001c\u0018B\u0001/Z\u0005]\u0011V\r]8si*{'mQ8na2,G/\u001a3Fm\u0016tG\u000f\u000b\u0002\u0006=B\u0011q,Y\u0007\u0002A*\u0011!lD\u0005\u0003E\u0002\u0014\u0011bU;cg\u000e\u0014\u0018NY3\u0002#=t'+\u001a9peRTuN\u0019$bS2,G\r\u0006\u0002SK\")aK\u0002a\u0001MB\u0011\u0001lZ\u0005\u0003Qf\u0013ACU3q_J$(j\u001c2GC&dW\rZ#wK:$\bF\u0001\u0004_\u0003E9W\r\u001e*fa>\u0014HOR5mK:\u000bW.\u001a\u000b\u0003Yj\u00042\u0001G7p\u0013\tq\u0017D\u0001\u0004PaRLwN\u001c\t\u0003a^t!!];\u0011\u0005ILR\"A:\u000b\u0005Q,\u0012A\u0002\u001fs_>$h(\u0003\u0002w3\u00051\u0001K]3eK\u001aL!\u0001_=\u0003\rM#(/\u001b8h\u0015\t1\u0018\u0004C\u0003|\u000f\u0001\u0007q.A\u0005sKN,H\u000e^+sS\"\u0012\u0001! \t\u0003?zL!a 1\u0003\u001b\u00153XM\u001c;MSN$XM\\3sQ\r\u0001\u00111\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002&\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002\u000e\u0005\u001d!!C\"p[B|g.\u001a8u\u0001")
public class ReportJobNotificationEventHandler
implements Logging {
    private final NotificationService notificationService;
    private final ServerConfiguration serverConfiguration;
    private final ConfigurationRepository configurationRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportJobNotificationEventHandler reportJobNotificationEventHandler = this;
        synchronized (reportJobNotificationEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void onReportJobCompleted(ReportJobCompletedEvent event) {
        ReportJob reportJob = event.reportJob();
        String fileName = (String)this.getReportFileName(reportJob.resultUri()).getOrElse((Function0 & Serializable & scala.Serializable)() -> reportJob.reportName());
        Type AuditReport2 = Type.valueOf(MultiReleaseAuditReport.class);
        AuditReportSettings reportSettings = (AuditReportSettings)this.configurationRepository.read("Configuration/settings/AuditReportSettings");
        Type type = Type.valueOf((String)reportJob.reportType());
        Type type2 = AuditReport2;
        Type type3 = type;
        if (!(type2 != null ? !type2.equals(type3) : type3 != null)) {
            Integer retentionPeriod = reportSettings.getReportsRetentionPeriod();
            this.notificationService.notify((NotificationTrigger)new AuditReportJobCompleted(new StringBuilder(24).append(this.serverConfiguration.getServerUrl()).append("#/audit-report-download/").append(reportJob.jobId()).toString(), fileName, retentionPeriod, reportJob.username()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Unable to send job completion notification for report type: ").append((Object)reportJob).append(".reportType").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Subscribe
    public void onReportJobFailed(ReportJobFailedEvent event) {
        ReportJob reportJob = event.reportJob();
        Type AuditReport2 = Type.valueOf(MultiReleaseAuditReport.class);
        Type type = Type.valueOf((String)reportJob.reportType());
        Type type2 = AuditReport2;
        Type type3 = type;
        if (!(type2 != null ? !type2.equals(type3) : type3 != null)) {
            this.notificationService.notify((NotificationTrigger)new AuditReportJobFailed(reportJob.reportName(), reportJob.username()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Unable to send job failure notification for report type: ").append((Object)reportJob).append(".reportType").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Option<String> getReportFileName(String resultUri) {
        None$ none$;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new URI(resultUri));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            URI uri = (URI)success.value();
            none$ = new Some((Object)new File(uri.getPath()).getName());
        } else if (try_ instanceof Failure) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Unable to get file name from ").append(resultUri).append(". Setting default filename.").toString());
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return none$;
    }

    @Autowired
    public ReportJobNotificationEventHandler(NotificationService notificationService, ServerConfiguration serverConfiguration, ConfigurationRepository configurationRepository) {
        this.notificationService = notificationService;
        this.serverConfiguration = serverConfiguration;
        this.configurationRepository = configurationRepository;
        Logging.$init$((Logging)this);
    }
}

