/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.excel;

import com.xebialabs.xlrelease.reports.api.ReportResource;
import com.xebialabs.xlrelease.reports.dto.PhaseDuration;
import com.xebialabs.xlrelease.reports.dto.ReleaseDuration;
import com.xebialabs.xlrelease.reports.dto.TaskDuration;
import com.xebialabs.xlrelease.reports.dto.UserParticipation;
import com.xebialabs.xlrelease.reports.excel.TopLongestPhaseExport;
import com.xebialabs.xlrelease.reports.excel.TopLongestReleaseExport;
import com.xebialabs.xlrelease.reports.excel.TopLongestTaskExport;
import com.xebialabs.xlrelease.reports.excel.TopPeopleMostInvolvedExport;
import com.xebialabs.xlrelease.reports.service.ReportParams;
import com.xebialabs.xlrelease.reports.service.ReportServiceCache;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportExcel {
    private ReportServiceCache reportService;

    @Autowired
    public ReportExcel(ReportServiceCache reportService) {
        this.reportService = reportService;
    }

    public Workbook getWorkBook(ReportResource.ReportType report, ReportParams reportParams) {
        switch (report) {
            case TOP_LONGEST_RELEASE: {
                return this.exportTopLongestRelease(reportParams);
            }
            case TOP_LONGEST_PHASE: {
                return this.exportTopLongestPhase(reportParams);
            }
            case TOP_LONGEST_TASK: {
                return this.exportTopLongestTask(reportParams);
            }
            case TOP_PEOPLE_MOST_INVOLVED: {
                return this.exportTopPeopleMostInvolved(reportParams);
            }
        }
        throw new IllegalArgumentException("Can't generate excel for report " + report.name());
    }

    private Workbook exportTopLongestRelease(ReportParams reportParams) {
        List<ReleaseDuration> topLongestReleases = this.reportService.getReleaseDuration(reportParams).getLongestReleases();
        return new TopLongestReleaseExport(topLongestReleases).getWorkBook();
    }

    private Workbook exportTopLongestPhase(ReportParams reportParams) {
        List<PhaseDuration> topLongestPhases = this.reportService.getTopLongestPhases(reportParams);
        return new TopLongestPhaseExport(topLongestPhases).getWorkBook();
    }

    private Workbook exportTopLongestTask(ReportParams reportParams) {
        List<TaskDuration> topLongestTasks = this.reportService.getTopLongestTasks(reportParams);
        return new TopLongestTaskExport(topLongestTasks).getWorkBook();
    }

    private Workbook exportTopPeopleMostInvolved(ReportParams reportParams) {
        List<UserParticipation> topPeopleMostInvolved = this.reportService.getTopPeopleMostInvolved(reportParams);
        return new TopPeopleMostInvolvedExport(topPeopleMostInvolved).getWorkBook();
    }
}

