/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.audit;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.xlplatform.io.ZipUtils$;
import com.xebialabs.xlplatform.utils.ResourceManagement$;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.utils.ReleaseIdInDatabase;
import com.xebialabs.xlrelease.planner.PlannerReleaseItem;
import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReport;
import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReportComponent$;
import com.xebialabs.xlrelease.reports.audit.ReleaseOverviewReport;
import com.xebialabs.xlrelease.reports.audit.ReportFilterMapper;
import com.xebialabs.xlrelease.reports.excel.AuditReport;
import com.xebialabs.xlrelease.reports.excel.AuditReport$;
import com.xebialabs.xlrelease.reports.excel.ExcelSheetWriter;
import com.xebialabs.xlrelease.reports.excel.MultiReleaseAuditReport;
import com.xebialabs.xlrelease.reports.excel.MultiReleaseAuditReport$;
import com.xebialabs.xlrelease.reports.excel.ReportGenerator;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.reports.job.api.ReportJobProgressMonitor;
import com.xebialabs.xlrelease.reports.job.api.ReportJobRunContext;
import com.xebialabs.xlrelease.reports.service.ReportsService;
import com.xebialabs.xlrelease.search.ReleaseCountResults;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.udm.reporting.AuditReportRequest;
import com.xebialabs.xlrelease.views.converters.ReleaseViewConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.joda.time.Duration;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try;

@Service
@ScalaSignature(bytes="\u0006\u0001\r]v!B\"E\u0011\u0003ye!B)E\u0011\u0003\u0011\u0006\"B-\u0002\t\u0003Q\u0006bB.\u0002\u0005\u0004%\t\u0001\u0018\u0005\u0007K\u0006\u0001\u000b\u0011B/\t\u000f\u0019\f!\u0019!C\u00019\"1q-\u0001Q\u0001\nuCq\u0001[\u0001C\u0002\u0013\u0005A\f\u0003\u0004j\u0003\u0001\u0006I!\u0018\u0005\bU\u0006\u0011\r\u0011\"\u0001]\u0011\u0019Y\u0017\u0001)A\u0005;\"9A.\u0001b\u0001\n\u0003a\u0006BB7\u0002A\u0003%Q\fC\u0004o\u0003\t\u0007I\u0011\u0001/\t\r=\f\u0001\u0015!\u0003^\u0011\u001d\u0001\u0018A1A\u0005\u0002EDa\u0001_\u0001!\u0002\u0013\u0011\bbB=\u0002\u0005\u0004%\tA\u001f\u0005\u0007}\u0006\u0001\u000b\u0011B>\t\u000f}\f!\u0019!C\u0001u\"9\u0011\u0011A\u0001!\u0002\u0013Y\b\"CA\u0002\u0003\t\u0007I\u0011AA\u0003\u0011!\tY\"\u0001Q\u0001\n\u0005\u001d\u0001bBA\u000f\u0003\u0011\u0005\u0011q\u0004\u0004\u0007\u0003s\t\u0001)a\u000f\t\u0015\u0005%\u0003D!f\u0001\n\u0003\tY\u0005\u0003\u0006\u0002Na\u0011\t\u0012)A\u0005\u0003CA!\"a\u0014\u0019\u0005+\u0007I\u0011AA)\u0011)\ty\u0006\u0007B\tB\u0003%\u00111\u000b\u0005\u000b\u0003CB\"Q3A\u0005\u0002\u0005\r\u0004BCAB1\tE\t\u0015!\u0003\u0002f!1\u0011\f\u0007C\u0001\u0003\u000bC\u0011\"!%\u0019\u0003\u0003%\t!a%\t\u0013\u0005m\u0005$%A\u0005\u0002\u0005u\u0005\"CAZ1E\u0005I\u0011AA[\u0011%\tI\fGI\u0001\n\u0003\tY\f\u0003\u0005\u0002@b\t\t\u0011\"\u0011]\u0011!\t\t\rGA\u0001\n\u0003Q\b\"CAb1\u0005\u0005I\u0011AAc\u0011%\t\t\u000eGA\u0001\n\u0003\n\u0019\u000eC\u0005\u0002bb\t\t\u0011\"\u0001\u0002d\"I\u0011Q\u001e\r\u0002\u0002\u0013\u0005\u0013q\u001e\u0005\n\u0003cD\u0012\u0011!C!\u0003gD\u0011\"!>\u0019\u0003\u0003%\t%a>\b\u0013\u0005m\u0018!!A\t\u0002\u0005uh!CA\u001d\u0003\u0005\u0005\t\u0012AA\u0000\u0011\u0019IV\u0006\"\u0001\u0003\u000e!I\u0011\u0011_\u0017\u0002\u0002\u0013\u0015\u00131\u001f\u0005\n\u0005\u001fi\u0013\u0011!CA\u0005#A\u0011B!\u0007.\u0003\u0003%\tIa\u0007\t\u0013\t5R&!A\u0005\n\t=b!B)E\u0001\t]\u0002B\u0003B%g\t\u0005\t\u0015!\u0003\u0003L!Q!qK\u001a\u0003\u0002\u0003\u0006IA!\u0017\t\u0015\t\u00154G!A!\u0002\u0013\u00119\u0007\u0003\u0006\u0003rM\u0012\t\u0011)A\u0005\u0005gB!B!\u001f4\u0005\u0003\u0005\u000b\u0011\u0002B>\u0011)\u00119i\rB\u0001B\u0003%!\u0011\u0012\u0005\u000b\u00053\u001b$\u0011!Q\u0001\n\tm\u0005B\u0003BQg\t\u0005\t\u0015!\u0003\u0003$\"1\u0011l\rC\u0001\u0005SCqA!74\t\u0003\u0011Y\u000eC\u0004\u0004\u0006M\"Iaa\u0002\t\u000f\rM3\u0007\"\u0003\u0004V!91QP\u001a\u0005\n\r}\u0004bBBJg\u0011\u00051Q\u0013\u0005\b\u00073\u001bD\u0011BBN\u0003\u0001jU\u000f\u001c;j%\u0016dW-Y:f\u0003V$\u0017\u000e\u001e*fa>\u0014HoQ8na>tWM\u001c;\u000b\u0005\u00153\u0015!B1vI&$(BA$I\u0003\u001d\u0011X\r]8siNT!!\u0013&\u0002\u0013ad'/\u001a7fCN,'BA&M\u0003%AXMY5bY\u0006\u00147OC\u0001N\u0003\r\u0019w.\\\u0002\u0001!\t\u0001\u0016!D\u0001E\u0005\u0001jU\u000f\u001c;j%\u0016dW-Y:f\u0003V$\u0017\u000e\u001e*fa>\u0014HoQ8na>tWM\u001c;\u0014\u0005\u0005\u0019\u0006C\u0001+X\u001b\u0005)&\"\u0001,\u0002\u000bM\u001c\u0017\r\\1\n\u0005a+&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u001f\u0006yQ\tW\"F\u0019~+\u0005\fV#O'&{e*F\u0001^!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0003mC:<'\"\u00012\u0002\t)\fg/Y\u0005\u0003I~\u0013aa\u0015;sS:<\u0017\u0001E#Y\u0007\u0016cu,\u0012-U\u000b:\u001b\u0016j\u0014(!\u00035Q\u0016\nU0F1R+ejU%P\u001d\u0006q!,\u0013)`\u000bb#VIT*J\u001f:\u0003\u0013\u0001D'B'R+%k\u0018+J)2+\u0015!D'B'R+%k\u0018+J)2+\u0005%\u0001\fN\u0003N#VIU0U\u0013RcUiX*F!\u0006\u0013\u0016\tV(S\u0003]i\u0015i\u0015+F%~#\u0016\n\u0016'F?N+\u0005+\u0011*B)>\u0013\u0006%\u0001\fT\u0013:;E*R0U\u0013RcUiX*F!\u0006\u0013\u0016\tV(S\u0003]\u0019\u0016JT$M\u000b~#\u0016\n\u0016'F?N+\u0005+\u0011*B)>\u0013\u0006%\u0001\nT\u0013:;E*R0S\u000bB{%\u000bV*`\t&\u0013\u0016aE*J\u001d\u001ecUi\u0018*F!>\u0013FkU0E\u0013J\u0003\u0013A\u0005#B)\u0016#\u0016*T#`\r>\u0013V*\u0011+U\u000bJ+\u0012A\u001d\t\u0003gZl\u0011\u0001\u001e\u0006\u0003k\u0006\fA\u0001^3yi&\u0011q\u000f\u001e\u0002\u0011'&l\u0007\u000f\\3ECR,gi\u001c:nCR\f1\u0003R!U\u000bRKU*R0G\u001fJk\u0015\t\u0016+F%\u0002\n1CR%M\u000b:\u000bU*R0N\u0003b{F*\u0012(H)\"+\u0012a\u001f\t\u0003)rL!!`+\u0003\u0007%sG/\u0001\u000bG\u00132+e*Q'F?6\u000b\u0005l\u0018'F\u001d\u001e#\u0006\nI\u0001\u0012\t\u00163\u0015)\u0016'U?B\u000bu)R0T\u0013j+\u0015A\u0005#F\r\u0006+F\nV0Q\u0003\u001e+ulU%[\u000b\u0002\n!\u0003R#G\u0003VcEkX(S\t\u0016\u0013v,T(E\u000bV\u0011\u0011q\u0001\t\u0005\u0003\u0013\t9\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u00151wN]7t\u0015\u0011\t\t\"a\u0005\u0002\u0005Y\f$bAA\u000b\u0011\u0006\u0019\u0011\r]5\n\t\u0005e\u00111\u0002\u0002\u0011%\u0016dW-Y:f\u001fJ$WM]'pI\u0016\f1\u0003R#G\u0003VcEkX(S\t\u0016\u0013v,T(E\u000b\u0002\n\u0001c]1oSRL'0\u001a$jY\u0016t\u0017-\\3\u0015\t\u0005\u0005\u0012Q\u0007\t\u0005\u0003G\t\tD\u0004\u0003\u0002&\u00055\u0002cAA\u0014+6\u0011\u0011\u0011\u0006\u0006\u0004\u0003Wq\u0015A\u0002\u001fs_>$h(C\u0002\u00020U\u000ba\u0001\u0015:fI\u00164\u0017b\u00013\u00024)\u0019\u0011qF+\t\u000f\u0005]r\u00031\u0001\u0002\"\u0005Aa-\u001b7f]\u0006lWM\u0001\u0003ECR\f7C\u0002\rT\u0003{\t\u0019\u0005E\u0002U\u0003\u007fI1!!\u0011V\u0005\u001d\u0001&o\u001c3vGR\u00042\u0001VA#\u0013\r\t9%\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\fO\u0016tWM]1uK\u0012\u0014\u00150\u0006\u0002\u0002\"\u0005aq-\u001a8fe\u0006$X\r\u001a\"zA\u0005Yq-\u001a8fe\u0006$X\rZ(o+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005mSBAA,\u0015\r\tI&Y\u0001\u0005kRLG.\u0003\u0003\u0002^\u0005]#\u0001\u0002#bi\u0016\fAbZ3oKJ\fG/\u001a3P]\u0002\nQB]3q_J$h)\u001b7uKJ\u001cXCAA3!\u0019\t9'!\u001d\u0002x9!\u0011\u0011NA7\u001d\u0011\t9#a\u001b\n\u0003YK1!a\u001cV\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001d\u0002v\t\u00191+Z9\u000b\u0007\u0005=T\u000b\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\tiHR\u0001\bM&dG/\u001a:t\u0013\u0011\t\t)a\u001f\u0003\u0019I+\u0007o\u001c:u\r&dG/\u001a:\u0002\u001dI,\u0007o\u001c:u\r&dG/\u001a:tAQA\u0011qQAF\u0003\u001b\u000by\tE\u0002\u0002\nbi\u0011!\u0001\u0005\b\u0003\u0013z\u0002\u0019AA\u0011\u0011\u001d\tye\ba\u0001\u0003'Bq!!\u0019 \u0001\u0004\t)'\u0001\u0003d_BLH\u0003CAD\u0003+\u000b9*!'\t\u0013\u0005%\u0003\u0005%AA\u0002\u0005\u0005\u0002\"CA(AA\u0005\t\u0019AA*\u0011%\t\t\u0007\tI\u0001\u0002\u0004\t)'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}%\u0006BA\u0011\u0003C[#!a)\u0011\t\u0005\u0015\u0016qV\u0007\u0003\u0003OSA!!+\u0002,\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003[+\u0016AC1o]>$\u0018\r^5p]&!\u0011\u0011WAT\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t9L\u000b\u0003\u0002T\u0005\u0005\u0016AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003{SC!!\u001a\u0002\"\u0006i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002H\u00065\u0007c\u0001+\u0002J&\u0019\u00111Z+\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002P\u001a\n\t\u00111\u0001|\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u001b\t\u0007\u0003/\fi.a2\u000e\u0005\u0005e'bAAn+\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0017\u0011\u001c\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002f\u0006-\bc\u0001+\u0002h&\u0019\u0011\u0011^+\u0003\u000f\t{w\u000e\\3b]\"I\u0011q\u001a\u0015\u0002\u0002\u0003\u0007\u0011qY\u0001\tQ\u0006\u001c\bnQ8eKR\t10\u0001\u0005u_N#(/\u001b8h)\u0005i\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002f\u0006e\b\"CAhW\u0005\u0005\t\u0019AAd\u0003\u0011!\u0015\r^1\u0011\u0007\u0005%UfE\u0003.\u0005\u0003\t\u0019\u0005\u0005\u0007\u0003\u0004\t%\u0011\u0011EA*\u0003K\n9)\u0004\u0002\u0003\u0006)\u0019!qA+\u0002\u000fI,h\u000e^5nK&!!1\u0002B\u0003\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003{\fQ!\u00199qYf$\u0002\"a\"\u0003\u0014\tU!q\u0003\u0005\b\u0003\u0013\u0002\u0004\u0019AA\u0011\u0011\u001d\ty\u0005\ra\u0001\u0003'Bq!!\u00191\u0001\u0004\t)'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tu!\u0011\u0006\t\u0006)\n}!1E\u0005\u0004\u0005C)&AB(qi&|g\u000eE\u0005U\u0005K\t\t#a\u0015\u0002f%\u0019!qE+\u0003\rQ+\b\u000f\\34\u0011%\u0011Y#MA\u0001\u0002\u0004\t9)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u0007\t\u0004=\nM\u0012b\u0001B\u001b?\n1qJ\u00196fGR\u001cBaM*\u0003:A!!1\bB#\u001b\t\u0011iD\u0003\u0003\u0003@\t\u0005\u0013!B:mMRR'B\u0001B\"\u0003!9'/\u001b>{Y\u0016$\u0017\u0002\u0002B$\u0005{\u0011q\u0001T8hO&tw-\u0001\bsKB|'\u000f^:TKJ4\u0018nY3\u0011\t\t5#1K\u0007\u0003\u0005\u001fR1A!\u0015G\u0003\u001d\u0019XM\u001d<jG\u0016LAA!\u0016\u0003P\tq!+\u001a9peR\u001c8+\u001a:wS\u000e,\u0017a\u0004:fa>\u0014HoR3oKJ\fGo\u001c:\u0011\t\tm#\u0011M\u0007\u0003\u0005;R1Aa\u0018G\u0003\u0015)\u0007pY3m\u0013\u0011\u0011\u0019G!\u0018\u0003\u001fI+\u0007o\u001c:u\u000f\u0016tWM]1u_J\fAC]3mK\u0006\u001cXmU3be\u000eD7+\u001a:wS\u000e,\u0007\u0003\u0002B5\u0005[j!Aa\u001b\u000b\u0007\tE\u0003*\u0003\u0003\u0003p\t-$\u0001\u0006*fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW-\u0001\bsK2,\u0017m]3TKJ4\u0018nY3\u0011\t\t%$QO\u0005\u0005\u0005o\u0012YG\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\u0002'M,'O^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\t\tu$1Q\u0007\u0003\u0005\u007fR1A!!K\u0003!!W\r\u001d7ps&$\u0018\u0002\u0002BC\u0005\u007f\u00121cU3sm\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\fAC]3mK\u0006\u001cXMV5fo\u000e{gN^3si\u0016\u0014\b\u0003\u0002BF\u0005+k!A!$\u000b\t\t=%\u0011S\u0001\u000bG>tg/\u001a:uKJ\u001c(b\u0001BJ\u0011\u0006)a/[3xg&!!q\u0013BG\u0005Q\u0011V\r\\3bg\u00164\u0016.Z<D_:4XM\u001d;fe\u0006\tB/Y:l\u0003\u000e\u001cWm]:TKJ4\u0018nY3\u0011\t\t%$QT\u0005\u0005\u0005?\u0013YGA\tUCN\\\u0017iY2fgN\u001cVM\u001d<jG\u0016\f!C]3q_J$h)\u001b7uKJl\u0015\r\u001d9feB\u0019\u0001K!*\n\u0007\t\u001dFI\u0001\nSKB|'\u000f\u001e$jYR,'/T1qa\u0016\u0014HC\u0005BV\u0005[\u0013yK!-\u00034\nU&q\u0017B]\u0005w\u0003\"\u0001U\u001a\t\u000f\t%C\b1\u0001\u0003L!9!q\u000b\u001fA\u0002\te\u0003b\u0002B3y\u0001\u0007!q\r\u0005\b\u0005cb\u0004\u0019\u0001B:\u0011\u001d\u0011I\b\u0010a\u0001\u0005wBqAa\"=\u0001\u0004\u0011I\tC\u0004\u0003\u001ar\u0002\rAa'\t\u000f\t\u0005F\b1\u0001\u0003$\"\u001aAHa0\u0011\t\t\u0005'Q[\u0007\u0003\u0005\u0007TA!!,\u0003F*!!q\u0019Be\u0003\u001d1\u0017m\u0019;pefTAAa3\u0003N\u0006)!-Z1og*!!q\u001aBi\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'B\u0001Bj\u0003\ry'oZ\u0005\u0005\u0005/\u0014\u0019MA\u0005BkR|w/\u001b:fI\u0006qq-\u001a8fe\u0006$XMU3q_J$HC\u0002Bo\u0005S\u0014\u0019\u0010\u0005\u0003\u0003`\n\u0015XB\u0001Bq\u0015\r\u0011\u0019/Y\u0001\u0003S>LAAa:\u0003b\n!a)\u001b7f\u0011\u001d\u0011Y/\u0010a\u0001\u0005[\f\u0001C]3q_J$H)\u001a4j]&$\u0018n\u001c8\u0011\u0007A\u0013y/C\u0002\u0003r\u0012\u0013q#T;mi&\u0014V\r\\3bg\u0016\fU\u000fZ5u%\u0016\u0004xN\u001d;\t\u000f\tUX\b1\u0001\u0003x\u0006\u0019\"/\u001a9peRTuN\u0019*v]\u000e{g\u000e^3yiB!!\u0011`B\u0001\u001b\t\u0011YP\u0003\u0003\u0002\u0016\tu(b\u0001B\u0000\r\u0006\u0019!n\u001c2\n\t\r\r!1 \u0002\u0014%\u0016\u0004xN\u001d;K_\n\u0014VO\\\"p]R,\u0007\u0010^\u0001\u001cO\u0016tWM]1uKNKgn\u001a7f%\u0016dW-Y:f%\u0016\u0004xN\u001d;\u0015\r\r%11FB !\u0011\u0019Ya!\n\u000f\t\r51\u0011\u0005\b\u0005\u0007\u001f\u0019yB\u0004\u0003\u0004\u0012\rua\u0002BB\n\u00077qAa!\u0006\u0004\u001a9!\u0011qEB\f\u0013\u0005i\u0015BA&M\u0013\tI%*\u0003\u0002H\u0011&\u0019!q\f$\n\t\r\r\"QL\u0001\u0018\u001bVdG/\u001b*fY\u0016\f7/Z!vI&$(+\u001a9peRLAaa\n\u0004*\tq\u0001+\u001a:SK2,\u0017m]3ECR\f'\u0002BB\u0012\u0005;Bqa!\f?\u0001\u0004\u0019y#A\u0004x_J\\G)\u001b:\u0011\t\rE21H\u0007\u0003\u0007gQAa!\u000e\u00048\u0005!a-\u001b7f\u0015\r\u0019I$Y\u0001\u0004]&|\u0017\u0002BB\u001f\u0007g\u0011A\u0001U1uQ\"91\u0011\t A\u0002\r\r\u0013!\u0003:fY\u0016\f7/Z%e!\u0011\u0019)ea\u0014\u000e\u0005\r\u001d#\u0002BB%\u0007\u0017\nQ!\u001e;jYNT1a!\u0014I\u0003\u0019!w.\\1j]&!1\u0011KB$\u0005M\u0011V\r\\3bg\u0016LE-\u00138ECR\f'-Y:f\u0003-9(/\u001b;f)>4\u0015\u000e\\3\u0015\u0015\tu7qKB-\u0007k\u001aI\bC\u0004\u0004.}\u0002\raa\f\t\u000f\rms\b1\u0001\u0004^\u0005Aqo\u001c:l\u0005>|7\u000e\u0005\u0003\u0004`\rETBAB1\u0015\u0011\u0019\u0019g!\u001a\u0002\u0013U\u001cXM]7pI\u0016d'\u0002BB4\u0007S\n!a]:\u000b\t\r-4QN\u0001\u0004a>L'\u0002BB8\u0005#\fa!\u00199bG\",\u0017\u0002BB:\u0007C\u0012\u0001bV8sW\n|wn\u001b\u0005\b\u0007oz\u0004\u0019AA*\u0003\u0011!\u0017\r^3\t\u000f\rmt\b1\u0001\u0002\"\u0005)A/\u001b;mK\u0006a\u0011N\\:uC:\u001cW\rR1uCV\u00111\u0011\u0011\t\u0005\u0007\u0007\u001biI\u0004\u0003\u0004\u0006\u000e%e\u0002BB\b\u0007\u000fK!!\u0012$\n\u0007\r-E)A\u000bSK2,\u0017m]3Pm\u0016\u0014h/[3x%\u0016\u0004xN\u001d;\n\t\r=5\u0011\u0013\u0002\r\u0013:\u001cH/\u00198dK\u0012\u000bG/\u0019\u0006\u0004\u0007\u0017#\u0015a\u00029sKZLWm\u001e\u000b\u0005\u0003\u000f\u001c9\nC\u0004\u0003l\u0006\u0003\rA!<\u0002\u001d\u0019|'/\\1u\tV\u0014\u0018\r^5p]R!\u0011\u0011EBO\u0011\u001d\u0019yJ\u0011a\u0001\u0007C\u000bqA]3mK\u0006\u001cX\r\u0005\u0003\u0004$\u000e\u0015VBAB&\u0013\u0011\u00199ka\u0013\u0003\u000fI+G.Z1tK\"\u001a1ga+\u0011\t\r561W\u0007\u0003\u0007_SAa!-\u0003N\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\rU6q\u0016\u0002\b'\u0016\u0014h/[2f\u0001")
public class MultiReleaseAuditReportComponent
implements Logging {
    private final ReportsService reportsService;
    private final ReleaseSearchService releaseSearchService;
    private final ServerConfiguration serverConfiguration;
    private final ReleaseViewConverter releaseViewConverter;
    private final TaskAccessService taskAccessService;
    private final ReportFilterMapper reportFilterMapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String sanitizeFilename(String string) {
        return MultiReleaseAuditReportComponent$.MODULE$.sanitizeFilename(string);
    }

    public static ReleaseOrderMode DEFAULT_ORDER_MODE() {
        return MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_ORDER_MODE();
    }

    public static int DEFAULT_PAGE_SIZE() {
        return MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_PAGE_SIZE();
    }

    public static int FILENAME_MAX_LENGTH() {
        return MultiReleaseAuditReportComponent$.MODULE$.FILENAME_MAX_LENGTH();
    }

    public static SimpleDateFormat DATETIME_FORMATTER() {
        return MultiReleaseAuditReportComponent$.MODULE$.DATETIME_FORMATTER();
    }

    public static String SINGLE_REPORTS_DIR() {
        return MultiReleaseAuditReportComponent$.MODULE$.SINGLE_REPORTS_DIR();
    }

    public static String SINGLE_TITLE_SEPARATOR() {
        return MultiReleaseAuditReportComponent$.MODULE$.SINGLE_TITLE_SEPARATOR();
    }

    public static String MASTER_TITLE_SEPARATOR() {
        return MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE_SEPARATOR();
    }

    public static String MASTER_TITLE() {
        return MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE();
    }

    public static String ZIP_EXTENSION() {
        return MultiReleaseAuditReportComponent$.MODULE$.ZIP_EXTENSION();
    }

    public static String EXCEL_EXTENSION() {
        return MultiReleaseAuditReportComponent$.MODULE$.EXCEL_EXTENSION();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        MultiReleaseAuditReportComponent multiReleaseAuditReportComponent = this;
        synchronized (multiReleaseAuditReportComponent) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public File generateReport(MultiReleaseAuditReport reportDefinition, ReportJobRunContext reportJobRunContext) {
        Data data = new Data(reportDefinition.getGeneratedBy(), reportDefinition.getGeneratedOn(), (Seq<ReportFilter>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(reportDefinition.filters()).asScala()));
        Seq releaseIds = this.releaseSearchService.searchAllIdsWithoutPermissionsCheck(data.reportFilters(), (Option)new Some((Object)ReleaseOrderMode.start_date), this.releaseSearchService.searchAllIdsWithoutPermissionsCheck$default$3(), this.releaseSearchService.searchAllIdsWithoutPermissionsCheck$default$4());
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Creating report for ").append(releaseIds.length()).append(" releases in job with id '").append(reportJobRunContext.jobId()).append("'.").toString());
        int totalWorkItems = releaseIds.length() + 3;
        ReportJobProgressMonitor progressMonitor = reportJobRunContext.reportJobProgressMonitor();
        progressMonitor.sendTotalWorkItems(totalWorkItems);
        File workDir = reportJobRunContext.reportStorage().workdir();
        String reportDirName = new StringBuilder(0).append(MultiReleaseAuditReportComponent$.MODULE$.DATETIME_FORMATTER().format(data.generatedOn())).append(MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE_SEPARATOR()).append(MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE()).toString();
        Path reportDir = Paths.get(workDir.getPath(), reportDirName);
        Path reportsDir = reportDir.resolve(MultiReleaseAuditReportComponent$.MODULE$.SINGLE_REPORTS_DIR());
        reportsDir.toFile().mkdirs();
        scala.collection.immutable.Map releasesData = (scala.collection.immutable.Map)releaseIds.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Map done = (scala.collection.immutable.Map)tuple2._1();
            ReleaseIdInDatabase id = (ReleaseIdInDatabase)tuple2._2();
            scala.collection.immutable.Map toR = done.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)id.adaptiveReleaseId()), (Object)this.generateSingleReleaseReport(reportsDir, id)));
            progressMonitor.sendCompletedWorkItems(toR.keys().size());
            scala.collection.immutable.Map map = toR;
            return map;
        });
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Creating master report with all releases");
        MultiReleaseAuditReport.Data masterData = new MultiReleaseAuditReport.Data(data.generatedBy(), data.generatedOn(), this.instanceData(), this.reportFilterMapper.map(data.reportFilters()), (Seq<MultiReleaseAuditReport.PerReleaseData>)releasesData.values().toSeq());
        Workbook masterWorkBook = MultiReleaseAuditReport$.MODULE$.getWorkBook(masterData);
        File masterFile = this.writeToFile(reportDir, masterWorkBook, data.generatedOn(), MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE());
        progressMonitor.sendCompletedWorkItems(releaseIds.length() + 1);
        File file = masterFile;
        File fullReport = ZipUtils$.MODULE$.archive((Seq)((TraversableOnce)releasesData.values().map((Function1 & Serializable & scala.Serializable)x$1 -> (File)((Tuple2)x$1.storedPath().get())._1(), Iterable$.MODULE$.canBuildFrom())).toSeq().$plus$colon((Object)file, Seq$.MODULE$.canBuildFrom()), reportDir.resolve(new StringBuilder(0).append(MultiReleaseAuditReportComponent$.MODULE$.DATETIME_FORMATTER().format(data.generatedOn())).append(MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE_SEPARATOR()).append(MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE()).append(MultiReleaseAuditReportComponent$.MODULE$.ZIP_EXTENSION()).toString()).toFile(), (Option)new Some((Object)workDir.getPath()));
        progressMonitor.sendCompletedWorkItems(releaseIds.length() + 2);
        FileUtils.deleteDirectory((File)reportsDir.toFile());
        masterFile.delete();
        progressMonitor.sendCompletedWorkItems(totalWorkItems);
        return fullReport;
    }

    private MultiReleaseAuditReport.PerReleaseData generateSingleReleaseReport(Path workDir, ReleaseIdInDatabase releaseId) {
        MultiReleaseAuditReport.PerReleaseData perReleaseData;
        try {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Working on report for [").append(releaseId.adaptiveReleaseId().folderlessReleaseId()).append("]").toString());
            Release release = this.reportsService.findReleaseByReleaseIdInDatabase(releaseId);
            AuditReport.Data data = this.reportsService.fetchAuditReportData(release);
            Workbook workBook = AuditReport$.MODULE$.getWorkBook(data);
            Try<Either<Tuple2<Throwable, String>, String>> folder = this.reportsService.formattedReleaseFolderPath(release.getId());
            File stored = this.writeToFile(workDir, workBook, data.releaseTree().release().getStartOrScheduledDate(), data.releaseTree().release().getTitle());
            PlannerReleaseItem root = data.releaseTree().root();
            perReleaseData = new MultiReleaseAuditReport.PerReleaseData(release.getTitle(), release.getOwner(), folder, (Date)Option$.MODULE$.apply((Object)release.getStartDate()).getOrElse((Function0 & Serializable & scala.Serializable)() -> release.getScheduledStartDate()), (Either<Date, Date>)((Either)root.endDate().map((Function1 & Serializable & scala.Serializable)dt -> package$.MODULE$.Left().apply((Object)dt.toDate())).orElse((Function0 & Serializable & scala.Serializable)() -> root.dueDate().map((Function1 & Serializable & scala.Serializable)dt -> package$.MODULE$.Right().apply((Object)dt.toDate()))).get()), this.formatDuration(release), release.getStatus(), data.releaseOverviewData().startedBy(), (Option<Tuple2<File, String>>)new Some((Object)new Tuple2((Object)stored, (Object)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(stored.getPath())).stripPrefix(workDir.getParent().toFile().getPath()))).stripPrefix(File.separator))), data.releaseOverviewData().templateInfo());
        }
        catch (Exception e) {
            throw new IllegalStateException(new StringBuilder(41).append("Unable to generate individual report for ").append(releaseId).toString(), e);
        }
        return perReleaseData;
    }

    private File writeToFile(Path workDir, Workbook workBook, Date date, String title) {
        String sanitizedTitle = MultiReleaseAuditReportComponent$.MODULE$.sanitizeFilename(title);
        String reportFileName = new StringBuilder(0).append(MultiReleaseAuditReportComponent$.MODULE$.DATETIME_FORMATTER().format(date)).append(MultiReleaseAuditReportComponent$.MODULE$.SINGLE_TITLE_SEPARATOR()).append(sanitizedTitle).toString();
        File stored = workDir.resolve(new StringBuilder(0).append(reportFileName).append(MultiReleaseAuditReportComponent$.MODULE$.EXCEL_EXTENSION()).toString()).toFile();
        int fileCounter = 1;
        while (stored.exists()) {
            stored = workDir.resolve(new StringBuilder(0).append(reportFileName).append(MultiReleaseAuditReportComponent$.MODULE$.SINGLE_TITLE_SEPARATOR()).append(fileCounter).append(MultiReleaseAuditReportComponent$.MODULE$.EXCEL_EXTENSION()).toString()).toFile();
            ++fileCounter;
        }
        ResourceManagement$.MODULE$.using((Closeable)new FileOutputStream(stored), (Function1 & Serializable & scala.Serializable)x$1 -> {
            workBook.write(x$1);
            return BoxedUnit.UNIT;
        });
        return stored;
    }

    private ReleaseOverviewReport.InstanceData instanceData() {
        Option<String> instanceName = this.reportsService.getInstanceName();
        Option instanceUrl = Option$.MODULE$.apply((Object)this.serverConfiguration.getServerUrl());
        Option<String> xlrVersion = this.reportsService.getInstanceVersion();
        return new ReleaseOverviewReport.InstanceData(instanceName, (Option<String>)instanceUrl, xlrVersion);
    }

    public Object preview(MultiReleaseAuditReport reportDefinition) {
        AuditReportRequest reportRequest = new AuditReportRequest((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(reportDefinition.filters()).asScala(), Option$.MODULE$.apply((Object)MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_ORDER_MODE()));
        List<Release> releases = this.reportsService.getReleasesForPreview(reportRequest, 0L, MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_PAGE_SIZE());
        ReleaseCountResults releaseCount = this.reportsService.getReleasesCountByStatus(reportRequest);
        List properties = Collections.emptyList();
        List<String> extensions = Collections.singletonList("progress");
        Buffer views = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(releases).asScala()).map((Function1 & Serializable & scala.Serializable)r -> $this.releaseViewConverter.toFullView(r, $this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser(), properties, extensions, 2), Buffer$.MODULE$.canBuildFrom());
        return JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releases"), JavaConverters$.MODULE$.bufferAsJavaListConverter(views).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releaseCount"), (Object)releaseCount)}))).asJava();
    }

    private String formatDuration(Release release) {
        Duration duration = (Duration)Option$.MODULE$.apply((Object)release.getActualDuration()).getOrElse((Function0 & Serializable & scala.Serializable)() -> release.getComputedPlannedDuration());
        return ExcelSheetWriter.PERIOD_FORMATTER.print((ReadablePeriod)duration.toPeriod().normalizedStandard(PeriodType.dayTime()));
    }

    @Autowired
    public MultiReleaseAuditReportComponent(ReportsService reportsService, ReportGenerator reportGenerator, ReleaseSearchService releaseSearchService, ReleaseService releaseService, ServerConfiguration serverConfiguration, ReleaseViewConverter releaseViewConverter, TaskAccessService taskAccessService, ReportFilterMapper reportFilterMapper) {
        this.reportsService = reportsService;
        this.releaseSearchService = releaseSearchService;
        this.serverConfiguration = serverConfiguration;
        this.releaseViewConverter = releaseViewConverter;
        this.taskAccessService = taskAccessService;
        this.reportFilterMapper = reportFilterMapper;
        Logging.$init$((Logging)this);
    }

    public static class Data
    implements Product,
    scala.Serializable {
        private final String generatedBy;
        private final Date generatedOn;
        private final Seq<ReportFilter> reportFilters;

        public String generatedBy() {
            return this.generatedBy;
        }

        public Date generatedOn() {
            return this.generatedOn;
        }

        public Seq<ReportFilter> reportFilters() {
            return this.reportFilters;
        }

        public Data copy(String generatedBy, Date generatedOn, Seq<ReportFilter> reportFilters) {
            return new Data(generatedBy, generatedOn, reportFilters);
        }

        public String copy$default$1() {
            return this.generatedBy();
        }

        public Date copy$default$2() {
            return this.generatedOn();
        }

        public Seq<ReportFilter> copy$default$3() {
            return this.reportFilters();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Seq<ReportFilter> seq;
            int n = x$1;
            switch (n) {
                case 0: {
                    seq = this.generatedBy();
                    break;
                }
                case 1: {
                    seq = this.generatedOn();
                    break;
                }
                case 2: {
                    seq = this.reportFilters();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return seq;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            String string = this.generatedBy();
            String string2 = data.generatedBy();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Date date = this.generatedOn();
            Date date2 = data.generatedOn();
            if (date == null) {
                if (date2 != null) {
                    return false;
                }
            } else if (!((Object)date).equals(date2)) return false;
            Seq<ReportFilter> seq = this.reportFilters();
            Seq<ReportFilter> seq2 = data.reportFilters();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(String generatedBy, Date generatedOn, Seq<ReportFilter> reportFilters) {
            this.generatedBy = generatedBy;
            this.generatedOn = generatedOn;
            this.reportFilters = reportFilters;
            Product.$init$((Product)this);
        }
    }
}

