/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.audit;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.xlplatform.io.ZipUtils$;
import com.xebialabs.xlplatform.utils.ResourceManagement$;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.utils.ReleaseIdInDatabase;
import com.xebialabs.xlrelease.planner.PlannerReleaseItem;
import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReport;
import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReportComponent$;
import com.xebialabs.xlrelease.reports.audit.ReleaseOverviewReport;
import com.xebialabs.xlrelease.reports.audit.ReportFilterMapper;
import com.xebialabs.xlrelease.reports.excel.AuditReport;
import com.xebialabs.xlrelease.reports.excel.AuditReport$;
import com.xebialabs.xlrelease.reports.excel.ExcelSheetWriter;
import com.xebialabs.xlrelease.reports.excel.MultiReleaseAuditReport;
import com.xebialabs.xlrelease.reports.excel.MultiReleaseAuditReport$;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.reports.job.api.ReportJobProgressMonitor;
import com.xebialabs.xlrelease.reports.job.api.ReportJobRunContext;
import com.xebialabs.xlrelease.reports.service.ReportsService;
import com.xebialabs.xlrelease.search.ReleaseCountResults;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.udm.reporting.AuditReportRequest;
import com.xebialabs.xlrelease.views.converters.ReleaseViewConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.joda.time.Duration;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try;

@Service
@ScalaSignature(bytes="\u0006\u0001\rEv!\u0002#F\u0011\u0003\u0001f!\u0002*F\u0011\u0003\u0019\u0006\"\u0002.\u0002\t\u0003Y\u0006b\u0002/\u0002\u0005\u0004%\t!\u0018\u0005\u0007M\u0006\u0001\u000b\u0011\u00020\t\u000f\u001d\f!\u0019!C\u0001;\"1\u0001.\u0001Q\u0001\nyCq![\u0001C\u0002\u0013\u0005Q\f\u0003\u0004k\u0003\u0001\u0006IA\u0018\u0005\bW\u0006\u0011\r\u0011\"\u0001^\u0011\u0019a\u0017\u0001)A\u0005=\"9Q.\u0001b\u0001\n\u0003i\u0006B\u00028\u0002A\u0003%a\fC\u0004p\u0003\t\u0007I\u0011A/\t\rA\f\u0001\u0015!\u0003_\u0011\u001d\t\u0018A1A\u0005\u0002uCaA]\u0001!\u0002\u0013q\u0006bB:\u0002\u0005\u0004%\t\u0001\u001e\u0005\u0007w\u0006\u0001\u000b\u0011B;\t\u000fq\f!\u0019!C\u0001{\"9\u00111A\u0001!\u0002\u0013q\b\u0002CA\u0003\u0003\t\u0007I\u0011A?\t\u000f\u0005\u001d\u0011\u0001)A\u0005}\"I\u0011\u0011B\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003C\t\u0001\u0015!\u0003\u0002\u000e!9\u00111E\u0001\u0005\u0002\u0005\u0015bABA \u0003\u0001\u000b\t\u0005\u0003\u0006\u0002Pi\u0011)\u001a!C\u0001\u0003#B!\"a\u0015\u001b\u0005#\u0005\u000b\u0011BA\u0014\u0011)\t)F\u0007BK\u0002\u0013\u0005\u0011q\u000b\u0005\u000b\u0003KR\"\u0011#Q\u0001\n\u0005e\u0003BCA45\tU\r\u0011\"\u0001\u0002j!Q\u0011\u0011\u0012\u000e\u0003\u0012\u0003\u0006I!a\u001b\t\riSB\u0011AAF\u0011%\t9JGA\u0001\n\u0003\tI\nC\u0005\u0002\"j\t\n\u0011\"\u0001\u0002$\"I\u0011\u0011\u0018\u000e\u0012\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u007fS\u0012\u0013!C\u0001\u0003\u0003D\u0001\"!2\u001b\u0003\u0003%\t%\u0018\u0005\t\u0003\u000fT\u0012\u0011!C\u0001{\"I\u0011\u0011\u001a\u000e\u0002\u0002\u0013\u0005\u00111\u001a\u0005\n\u0003/T\u0012\u0011!C!\u00033D\u0011\"a:\u001b\u0003\u0003%\t!!;\t\u0013\u0005M($!A\u0005B\u0005U\b\"CA|5\u0005\u0005I\u0011IA}\u0011%\tYPGA\u0001\n\u0003\nipB\u0005\u0003\u0002\u0005\t\t\u0011#\u0001\u0003\u0004\u0019I\u0011qH\u0001\u0002\u0002#\u0005!Q\u0001\u0005\u00075>\"\tAa\u0005\t\u0013\u0005]x&!A\u0005F\u0005e\b\"\u0003B\u000b_\u0005\u0005I\u0011\u0011B\f\u0011%\u0011ybLA\u0001\n\u0003\u0013\t\u0003C\u0005\u00034=\n\t\u0011\"\u0003\u00036\u0019)!+\u0012\u0001\u0003>!Q!qJ\u001b\u0003\u0002\u0003\u0006IA!\u0015\t\u0015\tuSG!A!\u0002\u0013\u0011y\u0006\u0003\u0006\u0003jU\u0012\t\u0011)A\u0005\u0005WB!B!\u001d6\u0005\u0003\u0005\u000b\u0011\u0002B:\u0011)\u0011y(\u000eB\u0001B\u0003%!\u0011\u0011\u0005\u000b\u0005#+$\u0011!Q\u0001\n\tM\u0005B\u0003BMk\t\u0005\t\u0015!\u0003\u0003\u001c\"1!,\u000eC\u0001\u0005CCqAa46\t\u0003\u0011\t\u000eC\u0004\u0003|V\"IA!@\t\u000f\r5S\u0007\"\u0003\u0004P!91qO\u001b\u0005\n\re\u0004bBBGk\u0011\u00051q\u0012\u0005\b\u0007'+D\u0011BBK\u0003\u0001jU\u000f\u001c;j%\u0016dW-Y:f\u0003V$\u0017\u000e\u001e*fa>\u0014HoQ8na>tWM\u001c;\u000b\u0005\u0019;\u0015!B1vI&$(B\u0001%J\u0003\u001d\u0011X\r]8siNT!AS&\u0002\u0013ad'/\u001a7fCN,'B\u0001'N\u0003%AXMY5bY\u0006\u00147OC\u0001O\u0003\r\u0019w.\\\u0002\u0001!\t\t\u0016!D\u0001F\u0005\u0001jU\u000f\u001c;j%\u0016dW-Y:f\u0003V$\u0017\u000e\u001e*fa>\u0014HoQ8na>tWM\u001c;\u0014\u0005\u0005!\u0006CA+Y\u001b\u00051&\"A,\u0002\u000bM\u001c\u0017\r\\1\n\u0005e3&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002!\u0006yQ\tW\"F\u0019~+\u0005\fV#O'&{e*F\u0001_!\tyF-D\u0001a\u0015\t\t'-\u0001\u0003mC:<'\"A2\u0002\t)\fg/Y\u0005\u0003K\u0002\u0014aa\u0015;sS:<\u0017\u0001E#Y\u0007\u0016cu,\u0012-U\u000b:\u001b\u0016j\u0014(!\u0003I)\u0005lQ#M?\u000e{e\nV#O)~#\u0016\fU#\u0002'\u0015C6)\u0012'`\u0007>sE+\u0012(U?RK\u0006+\u0012\u0011\u0002\u001biK\u0005kX#Y)\u0016s5+S(O\u00039Q\u0016\nU0F1R+ejU%P\u001d\u0002\nA\"T!T)\u0016\u0013v\fV%U\u0019\u0016\u000bQ\"T!T)\u0016\u0013v\fV%U\u0019\u0016\u0003\u0013AF'B'R+%k\u0018+J)2+ulU#Q\u0003J\u000bEk\u0014*\u0002/5\u000b5\u000bV#S?RKE\u000bT#`'\u0016\u0003\u0016IU!U\u001fJ\u0003\u0013AF*J\u001d\u001ecUi\u0018+J)2+ulU#Q\u0003J\u000bEk\u0014*\u0002/MKej\u0012'F?RKE\u000bT#`'\u0016\u0003\u0016IU!U\u001fJ\u0003\u0013AE*J\u001d\u001ecUi\u0018*F!>\u0013FkU0E\u0013J\u000b1cU%O\u000f2+uLU#Q\u001fJ#6k\u0018#J%\u0002\n!\u0003R!U\u000bRKU*R0G\u001fJk\u0015\t\u0016+F%V\tQ\u000f\u0005\u0002ws6\tqO\u0003\u0002yE\u0006!A/\u001a=u\u0013\tQxO\u0001\tTS6\u0004H.\u001a#bi\u00164uN]7bi\u0006\u0019B)\u0011+F)&kUi\u0018$P%6\u000bE\u000bV#SA\u0005\u0019b)\u0013'F\u001d\u0006kUiX'B1~cUIT$U\u0011V\ta\u0010\u0005\u0002V\u007f&\u0019\u0011\u0011\u0001,\u0003\u0007%sG/\u0001\u000bG\u00132+e*Q'F?6\u000b\u0005l\u0018'F\u001d\u001e#\u0006\nI\u0001\u0012\t\u00163\u0015)\u0016'U?B\u000bu)R0T\u0013j+\u0015A\u0005#F\r\u0006+F\nV0Q\u0003\u001e+ulU%[\u000b\u0002\n!\u0003R#G\u0003VcEkX(S\t\u0016\u0013v,T(E\u000bV\u0011\u0011Q\u0002\t\u0005\u0003\u001f\ti\"\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003\u00151wN]7t\u0015\u0011\t9\"!\u0007\u0002\u0005Y\f$bAA\u000e\u0013\u0006\u0019\u0011\r]5\n\t\u0005}\u0011\u0011\u0003\u0002\u0011%\u0016dW-Y:f\u001fJ$WM]'pI\u0016\f1\u0003R#G\u0003VcEkX(S\t\u0016\u0013v,T(E\u000b\u0002\n\u0001c]1oSRL'0\u001a$jY\u0016t\u0017-\\3\u0015\t\u0005\u001d\u00121\b\t\u0005\u0003S\t9D\u0004\u0003\u0002,\u0005M\u0002cAA\u0017-6\u0011\u0011q\u0006\u0006\u0004\u0003cy\u0015A\u0002\u001fs_>$h(C\u0002\u00026Y\u000ba\u0001\u0015:fI\u00164\u0017bA3\u0002:)\u0019\u0011Q\u0007,\t\u000f\u0005u\u0012\u00041\u0001\u0002(\u0005Aa-\u001b7f]\u0006lWM\u0001\u0003ECR\f7C\u0002\u000eU\u0003\u0007\nI\u0005E\u0002V\u0003\u000bJ1!a\u0012W\u0005\u001d\u0001&o\u001c3vGR\u00042!VA&\u0013\r\tiE\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\fO\u0016tWM]1uK\u0012\u0014\u00150\u0006\u0002\u0002(\u0005aq-\u001a8fe\u0006$X\r\u001a\"zA\u0005Yq-\u001a8fe\u0006$X\rZ(o+\t\tI\u0006\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\tyFY\u0001\u0005kRLG.\u0003\u0003\u0002d\u0005u#\u0001\u0002#bi\u0016\fAbZ3oKJ\fG/\u001a3P]\u0002\nQB]3q_J$h)\u001b7uKJ\u001cXCAA6!\u0019\ti'a\u001e\u0002~9!\u0011qNA:\u001d\u0011\ti#!\u001d\n\u0003]K1!!\u001eW\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001f\u0002|\t\u00191+Z9\u000b\u0007\u0005Ud\u000b\u0005\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\r\t\u0019iR\u0001\bM&dG/\u001a:t\u0013\u0011\t9)!!\u0003\u0019I+\u0007o\u001c:u\r&dG/\u001a:\u0002\u001dI,\u0007o\u001c:u\r&dG/\u001a:tAQA\u0011QRAI\u0003'\u000b)\nE\u0002\u0002\u0010ji\u0011!\u0001\u0005\b\u0003\u001f\n\u0003\u0019AA\u0014\u0011\u001d\t)&\ta\u0001\u00033Bq!a\u001a\"\u0001\u0004\tY'\u0001\u0003d_BLH\u0003CAG\u00037\u000bi*a(\t\u0013\u0005=#\u0005%AA\u0002\u0005\u001d\u0002\"CA+EA\u0005\t\u0019AA-\u0011%\t9G\tI\u0001\u0002\u0004\tY'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0015&\u0006BA\u0014\u0003O[#!!+\u0011\t\u0005-\u0016QW\u0007\u0003\u0003[SA!a,\u00022\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003g3\u0016AC1o]>$\u0018\r^5p]&!\u0011qWAW\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiL\u000b\u0003\u0002Z\u0005\u001d\u0016AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u0007TC!a\u001b\u0002(\u0006i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002N\u0006M\u0007cA+\u0002P&\u0019\u0011\u0011\u001b,\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002V\"\n\t\u00111\u0001\u007f\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u001c\t\u0007\u0003;\f\u0019/!4\u000e\u0005\u0005}'bAAq-\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0015\u0018q\u001c\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002l\u0006E\bcA+\u0002n&\u0019\u0011q\u001e,\u0003\u000f\t{w\u000e\\3b]\"I\u0011Q\u001b\u0016\u0002\u0002\u0003\u0007\u0011QZ\u0001\tQ\u0006\u001c\bnQ8eKR\ta0\u0001\u0005u_N#(/\u001b8h)\u0005q\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002l\u0006}\b\"CAk[\u0005\u0005\t\u0019AAg\u0003\u0011!\u0015\r^1\u0011\u0007\u0005=ufE\u00030\u0005\u000f\tI\u0005\u0005\u0007\u0003\n\t=\u0011qEA-\u0003W\ni)\u0004\u0002\u0003\f)\u0019!Q\u0002,\u0002\u000fI,h\u000e^5nK&!!\u0011\u0003B\u0006\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0005\u0007\tQ!\u00199qYf$\u0002\"!$\u0003\u001a\tm!Q\u0004\u0005\b\u0003\u001f\u0012\u0004\u0019AA\u0014\u0011\u001d\t)F\ra\u0001\u00033Bq!a\u001a3\u0001\u0004\tY'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\r\"q\u0006\t\u0006+\n\u0015\"\u0011F\u0005\u0004\u0005O1&AB(qi&|g\u000eE\u0005V\u0005W\t9#!\u0017\u0002l%\u0019!Q\u0006,\u0003\rQ+\b\u000f\\34\u0011%\u0011\tdMA\u0001\u0002\u0004\ti)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!q\u0007\t\u0004?\ne\u0012b\u0001B\u001eA\n1qJ\u00196fGR\u001cB!\u000e+\u0003@A!!\u0011\tB&\u001b\t\u0011\u0019E\u0003\u0003\u0003F\t\u001d\u0013!B:mMRR'B\u0001B%\u0003!9'/\u001b>{Y\u0016$\u0017\u0002\u0002B'\u0005\u0007\u0012q\u0001T8hO&tw-\u0001\bsKB|'\u000f^:TKJ4\u0018nY3\u0011\t\tM#\u0011L\u0007\u0003\u0005+R1Aa\u0016H\u0003\u001d\u0019XM\u001d<jG\u0016LAAa\u0017\u0003V\tq!+\u001a9peR\u001c8+\u001a:wS\u000e,\u0017\u0001\u0006:fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW\r\u0005\u0003\u0003b\t\u0015TB\u0001B2\u0015\r\u00119&S\u0005\u0005\u0005O\u0012\u0019G\u0001\u000bSK2,\u0017m]3TK\u0006\u00148\r[*feZL7-Z\u0001\u000fe\u0016dW-Y:f'\u0016\u0014h/[2f!\u0011\u0011\tG!\u001c\n\t\t=$1\r\u0002\u000f%\u0016dW-Y:f'\u0016\u0014h/[2f\u0003M\u0019XM\u001d<fe\u000e{gNZ5hkJ\fG/[8o!\u0011\u0011)Ha\u001f\u000e\u0005\t]$b\u0001B=\u0017\u0006AA-\u001a9m_fLG/\u0003\u0003\u0003~\t]$aE*feZ,'oQ8oM&<WO]1uS>t\u0017\u0001\u0006:fY\u0016\f7/\u001a,jK^\u001cuN\u001c<feR,'\u000f\u0005\u0003\u0003\u0004\n5UB\u0001BC\u0015\u0011\u00119I!#\u0002\u0015\r|gN^3si\u0016\u00148OC\u0002\u0003\f&\u000bQA^5foNLAAa$\u0003\u0006\n!\"+\u001a7fCN,g+[3x\u0007>tg/\u001a:uKJ\f\u0011\u0003^1tW\u0006\u001b7-Z:t'\u0016\u0014h/[2f!\u0011\u0011\tG!&\n\t\t]%1\r\u0002\u0012)\u0006\u001c8.Q2dKN\u001c8+\u001a:wS\u000e,\u0017A\u0005:fa>\u0014HOR5mi\u0016\u0014X*\u00199qKJ\u00042!\u0015BO\u0013\r\u0011y*\u0012\u0002\u0013%\u0016\u0004xN\u001d;GS2$XM]'baB,'\u000f\u0006\t\u0003$\n\u0015&q\u0015BU\u0005W\u0013iKa,\u00032B\u0011\u0011+\u000e\u0005\b\u0005\u001fj\u0004\u0019\u0001B)\u0011\u001d\u0011i&\u0010a\u0001\u0005?BqA!\u001b>\u0001\u0004\u0011Y\u0007C\u0004\u0003ru\u0002\rAa\u001d\t\u000f\t}T\b1\u0001\u0003\u0002\"9!\u0011S\u001fA\u0002\tM\u0005b\u0002BM{\u0001\u0007!1\u0014\u0015\u0004{\tU\u0006\u0003\u0002B\\\u0005\u0017l!A!/\u000b\t\u0005M&1\u0018\u0006\u0005\u0005{\u0013y,A\u0004gC\u000e$xN]=\u000b\t\t\u0005'1Y\u0001\u0006E\u0016\fgn\u001d\u0006\u0005\u0005\u000b\u00149-A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\u0011I-A\u0002pe\u001eLAA!4\u0003:\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u000fO\u0016tWM]1uKJ+\u0007o\u001c:u)\u0019\u0011\u0019Na8\u0003jB!!Q\u001bBn\u001b\t\u00119NC\u0002\u0003Z\n\f!![8\n\t\tu'q\u001b\u0002\u0005\r&dW\rC\u0004\u0003bz\u0002\rAa9\u0002!I,\u0007o\u001c:u\t\u00164\u0017N\\5uS>t\u0007cA)\u0003f&\u0019!q]#\u0003/5+H\u000e^5SK2,\u0017m]3Bk\u0012LGOU3q_J$\bb\u0002Bv}\u0001\u0007!Q^\u0001\u0014e\u0016\u0004xN\u001d;K_\n\u0014VO\\\"p]R,\u0007\u0010\u001e\t\u0005\u0005_\u001490\u0004\u0002\u0003r*!\u00111\u0004Bz\u0015\r\u0011)pR\u0001\u0004U>\u0014\u0017\u0002\u0002B}\u0005c\u00141CU3q_J$(j\u001c2Sk:\u001cuN\u001c;fqR\f1dZ3oKJ\fG/Z*j]\u001edWMU3mK\u0006\u001cXMU3q_J$HC\u0002B\u0000\u0007K\u0019I\u0004\u0005\u0003\u0004\u0002\r}a\u0002BB\u0002\u00073qAa!\u0002\u0004\u00169!1qAB\n\u001d\u0011\u0019Ia!\u0005\u000f\t\r-1q\u0002\b\u0005\u0003[\u0019i!C\u0001O\u0013\taU*\u0003\u0002K\u0017&\u0011\u0001*S\u0005\u0004\u0007/9\u0015!B3yG\u0016d\u0017\u0002BB\u000e\u0007;\tq#T;mi&\u0014V\r\\3bg\u0016\fU\u000fZ5u%\u0016\u0004xN\u001d;\u000b\u0007\r]q)\u0003\u0003\u0004\"\r\r\"A\u0004)feJ+G.Z1tK\u0012\u000bG/\u0019\u0006\u0005\u00077\u0019i\u0002C\u0004\u0004(}\u0002\ra!\u000b\u0002\u000f]|'o\u001b#jeB!11FB\u001b\u001b\t\u0019iC\u0003\u0003\u00040\rE\u0012\u0001\u00024jY\u0016T1aa\rc\u0003\rq\u0017n\\\u0005\u0005\u0007o\u0019iC\u0001\u0003QCRD\u0007bBB\u001e\u007f\u0001\u00071QH\u0001\ne\u0016dW-Y:f\u0013\u0012\u0004Baa\u0010\u0004J5\u00111\u0011\t\u0006\u0005\u0007\u0007\u001a)%A\u0003vi&d7OC\u0002\u0004H%\u000ba\u0001Z8nC&t\u0017\u0002BB&\u0007\u0003\u00121CU3mK\u0006\u001cX-\u00133J]\u0012\u000bG/\u00192bg\u0016\f1b\u001e:ji\u0016$vNR5mKRQ!1[B)\u0007'\u001ayga\u001d\t\u000f\r\u001d\u0002\t1\u0001\u0004*!91Q\u000b!A\u0002\r]\u0013\u0001C<pe.\u0014un\\6\u0011\t\re31N\u0007\u0003\u00077RAa!\u0018\u0004`\u0005IQo]3s[>$W\r\u001c\u0006\u0005\u0007C\u001a\u0019'\u0001\u0002tg*!1QMB4\u0003\r\u0001x.\u001b\u0006\u0005\u0007S\u00129-\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0007[\u001aYF\u0001\u0005X_J\\'m\\8l\u0011\u001d\u0019\t\b\u0011a\u0001\u00033\nA\u0001Z1uK\"91Q\u000f!A\u0002\u0005\u001d\u0012!\u0002;ji2,\u0017\u0001D5ogR\fgnY3ECR\fWCAB>!\u0011\u0019iha\"\u000f\t\r}41\u0011\b\u0005\u0007\u000b\u0019\t)\u0003\u0002G\u000f&\u00191QQ#\u0002+I+G.Z1tK>3XM\u001d<jK^\u0014V\r]8si&!1\u0011RBF\u00051Ien\u001d;b]\u000e,G)\u0019;b\u0015\r\u0019))R\u0001\baJ,g/[3x)\u0011\tim!%\t\u000f\t\u0005(\t1\u0001\u0003d\u0006qam\u001c:nCR$UO]1uS>tG\u0003BA\u0014\u0007/Cqa!'D\u0001\u0004\u0019Y*A\u0004sK2,\u0017m]3\u0011\t\ru5qT\u0007\u0003\u0007\u000bJAa!)\u0004F\t9!+\u001a7fCN,\u0007fA\u001b\u0004&B!1qUBW\u001b\t\u0019IK\u0003\u0003\u0004,\n\r\u0017AC:uKJ,w\u000e^=qK&!1qVBU\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class MultiReleaseAuditReportComponent
implements Logging {
    private final ReportsService reportsService;
    private final ReleaseSearchService releaseSearchService;
    private final ServerConfiguration serverConfiguration;
    private final ReleaseViewConverter releaseViewConverter;
    private final TaskAccessService taskAccessService;
    private final ReportFilterMapper reportFilterMapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String sanitizeFilename(String string) {
        return MultiReleaseAuditReportComponent$.MODULE$.sanitizeFilename(string);
    }

    public static ReleaseOrderMode DEFAULT_ORDER_MODE() {
        return MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_ORDER_MODE();
    }

    public static int DEFAULT_PAGE_SIZE() {
        return MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_PAGE_SIZE();
    }

    public static int FILENAME_MAX_LENGTH() {
        return MultiReleaseAuditReportComponent$.MODULE$.FILENAME_MAX_LENGTH();
    }

    public static SimpleDateFormat DATETIME_FORMATTER() {
        return MultiReleaseAuditReportComponent$.MODULE$.DATETIME_FORMATTER();
    }

    public static String SINGLE_REPORTS_DIR() {
        return MultiReleaseAuditReportComponent$.MODULE$.SINGLE_REPORTS_DIR();
    }

    public static String SINGLE_TITLE_SEPARATOR() {
        return MultiReleaseAuditReportComponent$.MODULE$.SINGLE_TITLE_SEPARATOR();
    }

    public static String MASTER_TITLE_SEPARATOR() {
        return MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE_SEPARATOR();
    }

    public static String MASTER_TITLE() {
        return MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE();
    }

    public static String ZIP_EXTENSION() {
        return MultiReleaseAuditReportComponent$.MODULE$.ZIP_EXTENSION();
    }

    public static String EXCEL_CONTENT_TYPE() {
        return MultiReleaseAuditReportComponent$.MODULE$.EXCEL_CONTENT_TYPE();
    }

    public static String EXCEL_EXTENSION() {
        return MultiReleaseAuditReportComponent$.MODULE$.EXCEL_EXTENSION();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        MultiReleaseAuditReportComponent multiReleaseAuditReportComponent = this;
        synchronized (multiReleaseAuditReportComponent) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public File generateReport(MultiReleaseAuditReport reportDefinition, ReportJobRunContext reportJobRunContext) {
        String reportName;
        Data data = new Data(reportDefinition.getGeneratedBy(), reportDefinition.getGeneratedOn(), (Seq<ReportFilter>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(reportDefinition.filters()).asScala()));
        Seq releaseIds = this.releaseSearchService.searchAllIdsWithoutPermissionsCheck(data.reportFilters(), (Option)new Some((Object)ReleaseOrderMode.start_date), this.releaseSearchService.searchAllIdsWithoutPermissionsCheck$default$3(), this.releaseSearchService.searchAllIdsWithoutPermissionsCheck$default$4());
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Creating report for ").append(releaseIds.length()).append(" releases in job with id '").append(reportJobRunContext.jobId()).append("'.").toString());
        int totalWorkItems = releaseIds.length() + 3;
        ReportJobProgressMonitor progressMonitor = reportJobRunContext.reportJobProgressMonitor();
        progressMonitor.sendTotalWorkItems(totalWorkItems);
        File workDir = reportJobRunContext.reportStorage().workdir();
        String reportDirName = reportName = reportJobRunContext.reportName();
        Path reportDir = Paths.get(workDir.getPath(), reportDirName);
        Path reportsDir = reportDir.resolve(MultiReleaseAuditReportComponent$.MODULE$.SINGLE_REPORTS_DIR());
        reportsDir.toFile().mkdirs();
        scala.collection.immutable.Map releasesData = (scala.collection.immutable.Map)releaseIds.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Map done = (scala.collection.immutable.Map)tuple2._1();
            ReleaseIdInDatabase id = (ReleaseIdInDatabase)tuple2._2();
            scala.collection.immutable.Map toR = done.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)id.adaptiveReleaseId()), (Object)this.generateSingleReleaseReport(reportsDir, id)));
            progressMonitor.sendCompletedWorkItems(toR.keys().size());
            scala.collection.immutable.Map map = toR;
            return map;
        });
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Creating master report with all releases");
        MultiReleaseAuditReport.Data masterData = new MultiReleaseAuditReport.Data(data.generatedBy(), data.generatedOn(), this.instanceData(), this.reportFilterMapper.map(data.reportFilters()), (Seq<MultiReleaseAuditReport.PerReleaseData>)releasesData.values().toSeq());
        Workbook masterWorkBook = MultiReleaseAuditReport$.MODULE$.getWorkBook(masterData);
        File masterFile = this.writeToFile(reportDir, masterWorkBook, data.generatedOn(), MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE());
        progressMonitor.sendCompletedWorkItems(releaseIds.length() + 1);
        File file = masterFile;
        File fullReport = ZipUtils$.MODULE$.archive((Seq)((TraversableOnce)releasesData.values().map((Function1 & Serializable & scala.Serializable)x$1 -> (File)((Tuple2)x$1.storedPath().get())._1(), Iterable$.MODULE$.canBuildFrom())).toSeq().$plus$colon((Object)file, Seq$.MODULE$.canBuildFrom()), reportDir.resolve(new StringBuilder(0).append(reportName).append(MultiReleaseAuditReportComponent$.MODULE$.ZIP_EXTENSION()).toString()).toFile(), (Option)new Some((Object)workDir.getPath()));
        progressMonitor.sendCompletedWorkItems(releaseIds.length() + 2);
        FileUtils.deleteDirectory((File)reportsDir.toFile());
        masterFile.delete();
        progressMonitor.sendCompletedWorkItems(totalWorkItems);
        return fullReport;
    }

    private MultiReleaseAuditReport.PerReleaseData generateSingleReleaseReport(Path workDir, ReleaseIdInDatabase releaseId) {
        MultiReleaseAuditReport.PerReleaseData perReleaseData;
        try {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Working on report for [").append(releaseId.adaptiveReleaseId().folderlessReleaseId()).append("]").toString());
            Release release = this.reportsService.findReleaseByReleaseIdInDatabase(releaseId);
            AuditReport.Data data = this.reportsService.fetchAuditReportData(release);
            Workbook workBook = AuditReport$.MODULE$.getWorkBook(data);
            Try<Either<Tuple2<Throwable, String>, String>> folder = this.reportsService.formattedReleaseFolderPath(release.getId());
            File stored = this.writeToFile(workDir, workBook, data.releaseTree().release().getStartOrScheduledDate(), data.releaseTree().release().getTitle());
            PlannerReleaseItem root = data.releaseTree().root();
            perReleaseData = new MultiReleaseAuditReport.PerReleaseData(release.getTitle(), release.getOwner(), folder, (Date)Option$.MODULE$.apply((Object)release.getStartDate()).getOrElse((Function0 & Serializable & scala.Serializable)() -> release.getScheduledStartDate()), (Either<Date, Date>)((Either)root.endDate().map((Function1 & Serializable & scala.Serializable)dt -> package$.MODULE$.Left().apply((Object)dt.toDate())).orElse((Function0 & Serializable & scala.Serializable)() -> root.dueDate().map((Function1 & Serializable & scala.Serializable)dt -> package$.MODULE$.Right().apply((Object)dt.toDate()))).get()), this.formatDuration(release), release.getStatus(), data.releaseOverviewData().startedBy(), (Option<Tuple2<File, String>>)new Some((Object)new Tuple2((Object)stored, (Object)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(stored.getPath())).stripPrefix(workDir.getParent().toFile().getPath()))).stripPrefix(File.separator))), data.releaseOverviewData().templateInfo());
        }
        catch (Exception e) {
            throw new IllegalStateException(new StringBuilder(41).append("Unable to generate individual report for ").append(releaseId).toString(), e);
        }
        return perReleaseData;
    }

    private File writeToFile(Path workDir, Workbook workBook, Date date, String title) {
        String sanitizedTitle = MultiReleaseAuditReportComponent$.MODULE$.sanitizeFilename(title);
        String reportFileName = new StringBuilder(0).append(MultiReleaseAuditReportComponent$.MODULE$.DATETIME_FORMATTER().format(date)).append(MultiReleaseAuditReportComponent$.MODULE$.SINGLE_TITLE_SEPARATOR()).append(sanitizedTitle).toString();
        File stored = workDir.resolve(new StringBuilder(0).append(reportFileName).append(MultiReleaseAuditReportComponent$.MODULE$.EXCEL_EXTENSION()).toString()).toFile();
        int fileCounter = 1;
        while (stored.exists()) {
            stored = workDir.resolve(new StringBuilder(0).append(reportFileName).append(MultiReleaseAuditReportComponent$.MODULE$.SINGLE_TITLE_SEPARATOR()).append(fileCounter).append(MultiReleaseAuditReportComponent$.MODULE$.EXCEL_EXTENSION()).toString()).toFile();
            ++fileCounter;
        }
        ResourceManagement$.MODULE$.using((Closeable)new FileOutputStream(stored), (Function1 & Serializable & scala.Serializable)x$1 -> {
            workBook.write(x$1);
            return BoxedUnit.UNIT;
        });
        return stored;
    }

    private ReleaseOverviewReport.InstanceData instanceData() {
        Option<String> instanceName = this.reportsService.getInstanceName();
        Option instanceUrl = Option$.MODULE$.apply((Object)this.serverConfiguration.getServerUrl());
        Option<String> xlrVersion = this.reportsService.getInstanceVersion();
        return new ReleaseOverviewReport.InstanceData(instanceName, (Option<String>)instanceUrl, xlrVersion);
    }

    public Object preview(MultiReleaseAuditReport reportDefinition) {
        AuditReportRequest reportRequest = new AuditReportRequest((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(reportDefinition.filters()).asScala(), Option$.MODULE$.apply((Object)MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_ORDER_MODE()));
        List<Release> releases = this.reportsService.getReleasesForPreview(reportRequest, 0L, MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_PAGE_SIZE());
        ReleaseCountResults releaseCount = this.reportsService.getReleasesCountByStatus(reportRequest);
        List properties = Collections.emptyList();
        List<String> extensions = Collections.singletonList("progress");
        Buffer views = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(releases).asScala()).map((Function1 & Serializable & scala.Serializable)r -> $this.releaseViewConverter.toFullView(r, $this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser(), properties, extensions, 2), Buffer$.MODULE$.canBuildFrom());
        return JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releases"), JavaConverters$.MODULE$.bufferAsJavaListConverter(views).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releaseCount"), (Object)releaseCount)}))).asJava();
    }

    private String formatDuration(Release release) {
        Duration duration = (Duration)Option$.MODULE$.apply((Object)release.getActualDuration()).getOrElse((Function0 & Serializable & scala.Serializable)() -> release.getComputedPlannedDuration());
        return ExcelSheetWriter.PERIOD_FORMATTER.print((ReadablePeriod)duration.toPeriod().normalizedStandard(PeriodType.dayTime()));
    }

    @Autowired
    public MultiReleaseAuditReportComponent(ReportsService reportsService, ReleaseSearchService releaseSearchService, ReleaseService releaseService, ServerConfiguration serverConfiguration, ReleaseViewConverter releaseViewConverter, TaskAccessService taskAccessService, ReportFilterMapper reportFilterMapper) {
        this.reportsService = reportsService;
        this.releaseSearchService = releaseSearchService;
        this.serverConfiguration = serverConfiguration;
        this.releaseViewConverter = releaseViewConverter;
        this.taskAccessService = taskAccessService;
        this.reportFilterMapper = reportFilterMapper;
        Logging.$init$((Logging)this);
    }

    public static class Data
    implements Product,
    scala.Serializable {
        private final String generatedBy;
        private final Date generatedOn;
        private final Seq<ReportFilter> reportFilters;

        public String generatedBy() {
            return this.generatedBy;
        }

        public Date generatedOn() {
            return this.generatedOn;
        }

        public Seq<ReportFilter> reportFilters() {
            return this.reportFilters;
        }

        public Data copy(String generatedBy, Date generatedOn, Seq<ReportFilter> reportFilters) {
            return new Data(generatedBy, generatedOn, reportFilters);
        }

        public String copy$default$1() {
            return this.generatedBy();
        }

        public Date copy$default$2() {
            return this.generatedOn();
        }

        public Seq<ReportFilter> copy$default$3() {
            return this.reportFilters();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Seq<ReportFilter> seq;
            int n = x$1;
            switch (n) {
                case 0: {
                    seq = this.generatedBy();
                    break;
                }
                case 1: {
                    seq = this.generatedOn();
                    break;
                }
                case 2: {
                    seq = this.reportFilters();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return seq;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            String string = this.generatedBy();
            String string2 = data.generatedBy();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Date date = this.generatedOn();
            Date date2 = data.generatedOn();
            if (date == null) {
                if (date2 != null) {
                    return false;
                }
            } else if (!((Object)date).equals(date2)) return false;
            Seq<ReportFilter> seq = this.reportFilters();
            Seq<ReportFilter> seq2 = data.reportFilters();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(String generatedBy, Date generatedOn, Seq<ReportFilter> reportFilters) {
            this.generatedBy = generatedBy;
            this.generatedOn = generatedOn;
            this.reportFilters = reportFilters;
            Product.$init$((Product)this);
        }
    }
}

