/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.dto;

import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.views.Point;
import java.util.List;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;

public class AverageByMonthComputer {
    private List<Point> serie = Lists.newArrayList();
    private DateTime currentDate;
    private long total;
    private long sum;

    public AverageByMonthComputer(DateTime startDate) {
        this.currentDate = startDate;
    }

    public void add(DateTime date, float value) {
        if (this.isMonthChanged(date)) {
            this.addPoint(this.currentDate);
            this.fillMissingMonths(date);
            this.currentDate = date;
            this.resetAccumulators();
        }
        ++this.total;
        this.sum = (long)((float)this.sum + value);
    }

    public List<Point> completeSerie(DateTime lastDate) {
        this.addPoint(this.currentDate);
        this.fillMissingMonths(lastDate.plusMonths(1));
        return this.serie;
    }

    private void addPoint(DateTime date) {
        String pointTitle = date.toString("MMMM", Locale.ENGLISH);
        long middleOfMonth = new DateTime(date.getYear(), date.getMonthOfYear(), 15, 0, 0).getMillis();
        this.serie.add(new Point(pointTitle, (float)middleOfMonth, this.getValue()));
    }

    private void fillMissingMonths(DateTime date) {
        int monthsDifference = Months.monthsBetween((ReadableInstant)this.currentDate, (ReadableInstant)date).getMonths();
        if (monthsDifference > 1) {
            this.resetAccumulators();
            for (int monthToAdd = 1; monthToAdd < monthsDifference; ++monthToAdd) {
                this.addPoint(this.currentDate.plusMonths(monthToAdd));
            }
        }
    }

    private boolean isMonthChanged(DateTime nextDate) {
        return this.currentDate.getMonthOfYear() != nextDate.getMonthOfYear() || this.currentDate.getYear() != nextDate.getYear();
    }

    private void resetAccumulators() {
        this.total = 0L;
        this.sum = 0L;
    }

    private float getValue() {
        return this.total != 0L ? (float)(this.sum / this.total) : 0.0f;
    }
}

