/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.api.internal;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plumbing.DateParam;
import com.xebialabs.xlrelease.api.utils.ResponseHelper;
import com.xebialabs.xlrelease.api.v1.forms.TimeFrame;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile;
import com.xebialabs.xlrelease.plugins.dashboard.service.TileService;
import com.xebialabs.xlrelease.reports.api.internal.MultiReleaseReportForm;
import com.xebialabs.xlrelease.reports.api.internal.ReportResource;
import com.xebialabs.xlrelease.reports.api.internal.UserPermissionsReportForm;
import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReport;
import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReportComponent;
import com.xebialabs.xlrelease.reports.audit.UserPermissionsReport;
import com.xebialabs.xlrelease.reports.excel.ReportExcel;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.reports.service.ReportParams;
import com.xebialabs.xlrelease.reports.utils.ReportUtils;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.udm.reporting.filters.impl.DateFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/export")
@Controller
public class ExportReportsResource {
    private PermissionChecker permissions;
    private ReportExcel reportExcel;
    private TileService tileService;
    private final ReportResource reportResource;

    @Autowired
    public ExportReportsResource(PermissionChecker permissions, ReportExcel reportExcel, TileService tileService, ReportResource reportResource) {
        this.permissions = permissions;
        this.reportExcel = reportExcel;
        this.tileService = tileService;
        this.reportResource = reportResource;
    }

    @GET
    @Path(value="report")
    @Produces(value={"application/octet-stream"})
    public Response exportReportToExcel(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="since") TimeFrame timeFrame, @QueryParam(value="report") ReportResource.ReportType report, @QueryParam(value="tags") String tags, @QueryParam(value="from") @DateParam Date from, @QueryParam(value="to") @DateParam Date to) {
        ReportParams reportParams = ReportParams.apply(timeFrame, from, to, ReportUtils.splitTags(tags), new ArrayList<ReportFilter>(), true, null, true);
        Workbook workbook = this.reportExcel.getWorkBook(report, reportParams);
        StreamingOutput output = arg_0 -> ((Workbook)workbook).write(arg_0);
        return ResponseHelper.streamFile((String)this.getReportFileName(report), (StreamingOutput)output, (String)MultiReleaseAuditReportComponent.EXCEL_CONTENT_TYPE());
    }

    @GET
    @Path(value="tile-report")
    @Produces(value={"application/octet-stream"})
    public Response exportTileReportToExcel(@QueryParam(value="report") ReportResource.ReportType report, @QueryParam(value="tileId") String tileId) {
        Tile tile = this.tileService.findTileById(tileId);
        List filters = (List)tile.getProperty("filters");
        if (filters != null) {
            DateFilter dateFilter = (DateFilter)filters.stream().filter(filter -> filter.getType().instanceOf(Type.valueOf(DateFilter.class))).findFirst().orElse((ReportFilter)new DateFilter(TimeFrame.LAST_SIX_MONTHS));
            ReportParams reportParams = ReportParams.apply(dateFilter.getTimeFrame(), dateFilter.getFrom(), dateFilter.getTo(), null, filters, false, null, true);
            Workbook workbook = this.reportExcel.getWorkBook(report, reportParams);
            StreamingOutput output = arg_0 -> ((Workbook)workbook).write(arg_0);
            return ResponseHelper.streamFile((String)this.getReportFileName(report), (StreamingOutput)output, (String)MultiReleaseAuditReportComponent.EXCEL_CONTENT_TYPE());
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="audit-report/multirelease")
    @Produces(value={"application/json"})
    public Response exportMultiReleaseAuditReportToExcel(MultiReleaseReportForm multiReleaseReportForm) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        MultiReleaseAuditReport reportDefinition = new MultiReleaseAuditReport();
        reportDefinition.setFilters(multiReleaseReportForm.getReportFilters());
        return this.reportResource.submit(reportDefinition);
    }

    @POST
    @Path(value="audit-report/multirelease-preview")
    @Produces(value={"application/json"})
    public Response previewMultiReleaseAuditReportToExcel(MultiReleaseReportForm multiReleaseReportForm) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        MultiReleaseAuditReport reportDefinition = new MultiReleaseAuditReport();
        reportDefinition.setFilters(multiReleaseReportForm.getReportFilters());
        return this.reportResource.preview(reportDefinition);
    }

    @POST
    @Path(value="audit-report/user-access-management")
    @Produces(value={"application/json"})
    public Response exportUserAccessManagementAuditReportToExcel(UserPermissionsReportForm userPermissionsReportForm) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        UserPermissionsReport reportDefinition = new UserPermissionsReport();
        reportDefinition.setFilters(userPermissionsReportForm.getReportFilters());
        return this.reportResource.submit(reportDefinition);
    }

    @POST
    @Path(value="audit-report/user-access-management-preview")
    @Produces(value={"application/json"})
    public Response previewUserAccessManagementAuditReportToExcel(UserPermissionsReportForm userPermissionsReportForm) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        UserPermissionsReport reportDefinition = new UserPermissionsReport();
        reportDefinition.setFilters(userPermissionsReportForm.getReportFilters());
        return this.reportResource.preview(reportDefinition);
    }

    private String getReportFileName(ReportResource.ReportType report) {
        return report.name().toLowerCase() + MultiReleaseAuditReportComponent.EXCEL_EXTENSION();
    }
}

