/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.job.impl;

import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.reports.job.api.ReportDefinition;
import com.xebialabs.xlrelease.reports.job.api.ReportJobProgressMonitor;
import com.xebialabs.xlrelease.reports.job.api.ReportJobRunContext;
import com.xebialabs.xlrelease.reports.job.api.ReportResult;
import com.xebialabs.xlrelease.reports.job.api.ReportStorage;
import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.domain.ReportJobStatus;
import com.xebialabs.xlrelease.reports.job.events.ReportJobAbortedEvent;
import com.xebialabs.xlrelease.reports.job.events.ReportJobCompletedEvent;
import com.xebialabs.xlrelease.reports.job.events.ReportJobFailedEvent;
import com.xebialabs.xlrelease.reports.job.impl.GlobalReportStorage;
import com.xebialabs.xlrelease.reports.job.impl.ReportExecutorService;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstance$;
import com.xebialabs.xlrelease.reports.job.impl.ReportingEngineConfiguration;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.Future;
import org.slf4j.Marker;
import org.springframework.context.ApplicationContext;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u0010!\u00015B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011!9\u0006A!A!\u0002\u0013A\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011\t\u0004!\u0011!Q\u0001\n\rDQ!\u001b\u0001\u0005\u0002)Dqa\u001d\u0001A\u0002\u0013%A\u000fC\u0005\u0002\u0014\u0001\u0001\r\u0011\"\u0003\u0002\u0016!9\u0011\u0011\u0005\u0001!B\u0013)\bbBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!!\u000e\u0001\t\u0003\t9\u0004C\u0004\u0002V\u0001!I!a\u0016\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h!9\u0011Q\u000e\u0001\u0005\n\u0005=\u0004bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003s\u0002A\u0011BA>\u0011\u001d\t\t\t\u0001C\u0005\u0003o:\u0001\"a!!\u0011\u0003\u0001\u0013Q\u0011\u0004\b?\u0001B\t\u0001IAD\u0011\u0019Iw\u0003\"\u0001\u0002\n\"9\u00111R\f\u0005\n\u00055eABAL/\u0011\tI\nC\u0005\u0002\"j\u0011\t\u0011)A\u0005W\"1\u0011N\u0007C\u0001\u0003GCq!!\u001a\u001b\t\u0003\nY\u000bC\u0004\u0002ni!\t%a,\u0003#I+\u0007o\u001c:u\u0015>\u0014\u0017J\\:uC:\u001cWM\u0003\u0002\"E\u0005!\u0011.\u001c9m\u0015\t\u0019C%A\u0002k_\nT!!\n\u0014\u0002\u000fI,\u0007o\u001c:ug*\u0011q\u0005K\u0001\nq2\u0014X\r\\3bg\u0016T!!\u000b\u0016\u0002\u0013a,'-[1mC\n\u001c(\"A\u0016\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001qC\u0007\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VM\u001a\t\u0003kij\u0011A\u000e\u0006\u0003oa\nQa\u001d7gi)T\u0011!O\u0001\tOJL'P\u001f7fI&\u00111H\u000e\u0002\b\u0019><w-\u001b8h\u0003%\u0011X\r]8si*{'\r\u0005\u0002?\u00036\tqH\u0003\u0002AE\u00051Am\\7bS:L!AQ \u0003\u0013I+\u0007o\u001c:u\u0015>\u0014\u0017AE1qa2L7-\u0019;j_:\u001cuN\u001c;fqR\u0004\"!\u0012'\u000e\u0003\u0019S!a\u0012%\u0002\u000f\r|g\u000e^3yi*\u0011\u0011JS\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t1*A\u0002pe\u001eL!!\u0014$\u0003%\u0005\u0003\b\u000f\\5dCRLwN\\\"p]R,\u0007\u0010^\u0001\u001de\u0016\u0004xN\u001d;j]\u001e,enZ5oK\u000e{gNZ5hkJ\fG/[8o!\t\u0001\u0016+D\u0001!\u0013\t\u0011\u0006E\u0001\u000fSKB|'\u000f^5oO\u0016sw-\u001b8f\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002+I,\u0007o\u001c:u\u000bb,7-\u001e;peN+'O^5dKB\u0011\u0001+V\u0005\u0003-\u0002\u0012QCU3q_J$X\t_3dkR|'oU3sm&\u001cW-A\nsKB|'\u000f\u001e&pEJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002Z96\t!L\u0003\u0002\\E\u0005Q!/\u001a9pg&$xN]=\n\u0005uS&a\u0005*fa>\u0014HOS8c%\u0016\u0004xn]5u_JL\u0018aE4m_\n\fGNU3q_J$8\u000b^8sC\u001e,\u0007C\u0001)a\u0013\t\t\u0007EA\nHY>\u0014\u0017\r\u001c*fa>\u0014Ho\u0015;pe\u0006<W-\u0001\u0005fm\u0016tGOQ;t!\t!w-D\u0001f\u0015\t1g%\u0001\u0004fm\u0016tGo]\u0005\u0003Q\u0016\u0014\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003\u0019a\u0014N\\5u}QA1\u000e\\7o_B\f(\u000f\u0005\u0002Q\u0001!)A\b\u0003a\u0001{!)1\t\u0003a\u0001\t\")a\n\u0003a\u0001\u001f\")1\u000b\u0003a\u0001)\")q\u000b\u0003a\u00011\")a\f\u0003a\u0001?\")!\r\u0003a\u0001G\u0006q!/\u001e8oS:<\u0007K]8nSN,W#A;\u0011\u0007=2\b0\u0003\u0002xa\t1q\n\u001d;j_:\u0004R!_A\u0001\u0003\u000bi\u0011A\u001f\u0006\u0003wr\f!bY8oGV\u0014(/\u001a8u\u0015\tih0\u0001\u0003vi&d'\"A@\u0002\t)\fg/Y\u0005\u0004\u0003\u0007Q(A\u0002$viV\u0014X\r\u0005\u00030m\u0006\u001d\u0001\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055!%A\u0002ba&LA!!\u0005\u0002\f\ta!+\u001a9peR\u0014Vm];mi\u0006\u0011\"/\u001e8oS:<\u0007K]8nSN,w\fJ3r)\u0011\t9\"!\b\u0011\u0007=\nI\"C\u0002\u0002\u001cA\u0012A!\u00168ji\"A\u0011q\u0004\u0006\u0002\u0002\u0003\u0007Q/A\u0002yIE\nqB];o]&tw\r\u0015:p[&\u001cX\rI\u0001\tO\u0016$(j\u001c2JIV\u0011\u0011q\u0005\t\u0004_\u0005%\u0012bAA\u0016a\t\u0019\u0011J\u001c;\u0002\u0007I,h\u000e\u0006\u0002\u0002\u0006\u00059QM\\9vKV,G#\u0001=\u0002\t\u0019\f\u0017\u000e\u001c\u000b\u0005\u0003/\tI\u0004C\u0004\u0002<=\u0001\r!!\u0010\u0002\u0013\u0015D8-\u001a9uS>t\u0007\u0003BA \u0003\u001frA!!\u0011\u0002L9!\u00111IA%\u001b\t\t)EC\u0002\u0002H1\na\u0001\u0010:p_Rt\u0014\"A\u0019\n\u0007\u00055\u0003'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00131\u000b\u0002\n)\"\u0014xn^1cY\u0016T1!!\u00141\u0003\u0015!wNU;o)\t\tI\u0006\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\tyF`\u0001\u0004]\u0016$\u0018\u0002BA2\u0003;\u00121!\u0016*J\u0003I\u0019XM\u001c3U_R\fGnV8sW&#X-\\:\u0015\t\u0005]\u0011\u0011\u000e\u0005\b\u0003W\n\u0002\u0019AA\u0014\u0003)!x\u000e^1m\u0013R,Wn]\u0001\u0017g\u0016tGmQ8na2,G/\u001a3X_J\\\u0017\n^3ngR!\u0011qCA9\u0011\u001d\t\u0019H\u0005a\u0001\u0003O\tabY8na2,G/\u001a3Ji\u0016l7/A\u0003bE>\u0014H\u000f\u0006\u0002\u0002\u0018\u0005A1m\\7qY\u0016$X\r\u0006\u0003\u0002\b\u0005u\u0004bBA@)\u0001\u0007\u0011\u0011L\u0001\ne\u0016\u001cX\u000f\u001c;Ve&\fQa\u001d;beR\f\u0011CU3q_J$(j\u001c2J]N$\u0018M\\2f!\t\u0001vc\u0005\u0002\u0018]Q\u0011\u0011QQ\u0001\fGV\u0014(/\u001a8u)&lW-\u0006\u0002\u0002\u0010B!\u0011\u0011SAJ\u001b\u0005a\u0018bAAKy\n!A)\u0019;f\u0005}!UMZ1vYR\u0014V\r]8si*{'\r\u0015:pOJ,7o]'p]&$xN]\n\u000559\nY\n\u0005\u0003\u0002\n\u0005u\u0015\u0002BAP\u0003\u0017\u0011\u0001DU3q_J$(j\u001c2Qe><'/Z:t\u001b>t\u0017\u000e^8s\u0003E\u0011X\r]8si*{'-\u00138ti\u0006t7-\u001a\u000b\u0005\u0003K\u000bI\u000bE\u0002\u0002(ji\u0011a\u0006\u0005\u0007\u0003Cc\u0002\u0019A6\u0015\t\u0005]\u0011Q\u0016\u0005\b\u0003Wj\u0002\u0019AA\u0014)\u0011\t9\"!-\t\u000f\u0005Md\u00041\u0001\u0002(\u0001")
public class ReportJobInstance
implements Logging {
    private final ReportJob reportJob;
    private final ApplicationContext applicationContext;
    private final ReportingEngineConfiguration reportingEngineConfiguration;
    private final ReportExecutorService reportExecutorService;
    private final ReportJobRepository reportJobRepository;
    private final GlobalReportStorage globalReportStorage;
    private final XLReleaseEventBus eventBus;
    private Option<Future<Option<ReportResult>>> runningPromise;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportJobInstance reportJobInstance = this;
        synchronized (reportJobInstance) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private Option<Future<Option<ReportResult>>> runningPromise() {
        return this.runningPromise;
    }

    private void runningPromise_$eq(Option<Future<Option<ReportResult>>> x$1) {
        this.runningPromise = x$1;
    }

    public int getJobId() {
        return Predef$.MODULE$.Integer2int(this.reportJob.getJobId());
    }

    public Option<ReportResult> run() {
        Some some;
        try {
            this.start();
            some = new Some((Object)this.complete(this.doRun()));
        }
        catch (Throwable e) {
            this.fail(e);
            some = None$.MODULE$;
        }
        return some;
    }

    public Future<Option<ReportResult>> enqueue() {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Enqueued ").append($this.reportJob.getJobId()).toString());
        this.runningPromise_$eq((Option<Future<Option<ReportResult>>>)Option$.MODULE$.apply(this.reportExecutorService.submit(() -> this.run())));
        return (Future)this.runningPromise().get();
    }

    public void fail(Throwable exception) {
        block3: {
            block2: {
                ReportJobStatus reportJobStatus = this.reportJob.getStatus();
                ReportJobStatus reportJobStatus2 = ReportJobStatus.ABORTED;
                if (!(reportJobStatus != null ? !((Object)((Object)reportJobStatus)).equals((Object)reportJobStatus2) : reportJobStatus2 != null)) {
                    this.logger().warn((Function0 & Serializable & scala.Serializable)() -> exception.getMessage());
                } else {
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Error while running report job [").append(this.getJobId()).append("]").toString(), (Function0 & Serializable & scala.Serializable)() -> exception);
                }
                ReportJobStatus reportJobStatus3 = this.reportJob.getStatus();
                ReportJobStatus reportJobStatus4 = ReportJobStatus.SUBMITTED;
                if (!(reportJobStatus3 == null ? reportJobStatus4 != null : !((Object)((Object)reportJobStatus3)).equals((Object)reportJobStatus4))) break block2;
                ReportJobStatus reportJobStatus5 = this.reportJob.getStatus();
                ReportJobStatus reportJobStatus6 = ReportJobStatus.STARTED;
                if (reportJobStatus5 != null ? !((Object)((Object)reportJobStatus5)).equals((Object)reportJobStatus6) : reportJobStatus6 != null) break block3;
            }
            this.reportJob.setEndTime(ReportJobInstance$.MODULE$.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$currentTime());
            this.reportJob.setStatus(ReportJobStatus.FAILED);
            this.reportJobRepository.update(this.reportJob);
            this.runningPromise_$eq((Option<Future<Option<ReportResult>>>)None$.MODULE$);
            this.eventBus.publish((XLReleaseEvent)new ReportJobFailedEvent(this.reportJob));
        }
    }

    private URI doRun() {
        ReportDefinition reportDefinition = this.reportJob.getReportDefinition();
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Starting report job [").append(reportDefinition.reportName()).append("] from user [").append(reportDefinition.getGeneratedBy()).append("]").toString());
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)reportDefinition);
        Integer jobId = this.reportJob.getJobId();
        ReportStorage reportStorage = this.globalReportStorage.reportStorage(jobId, reportDefinition.getGeneratedOn());
        DefaultReportJobProgressMonitor reportJobProgressMonitor = new DefaultReportJobProgressMonitor(this);
        ReportJobRunContext runContext = new ReportJobRunContext(jobId, reportJobProgressMonitor, reportStorage, this.reportJob.reportName());
        File resultFile = reportDefinition.run(runContext);
        URI contextUri = reportStorage.workdir().toURI();
        URI resultUri = contextUri.relativize(resultFile.toURI());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Finished report job [").append(reportDefinition.reportName()).append("] on [").append(resultUri).append("]").toString());
        return resultUri;
    }

    public void com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$sendTotalWorkItems(int totalItems) {
        this.reportJob.setTotalWorkItems(Predef$.MODULE$.int2Integer(totalItems));
        this.reportJobRepository.updateProgress(this.reportJob);
    }

    public void com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$sendCompletedWorkItems(int completedItems) {
        this.reportJob.setCompletedWorkItems(Predef$.MODULE$.int2Integer(completedItems));
        this.reportJobRepository.updateProgress(this.reportJob);
    }

    public void abort() {
        block8: {
            block7: {
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Abort report job [").append(this.getJobId()).append("]").toString());
                ReportJobStatus reportJobStatus = this.reportJob.getStatus();
                ReportJobStatus reportJobStatus2 = ReportJobStatus.SUBMITTED;
                if (!(reportJobStatus == null ? reportJobStatus2 != null : !((Object)((Object)reportJobStatus)).equals((Object)reportJobStatus2))) break block7;
                ReportJobStatus reportJobStatus3 = this.reportJob.getStatus();
                ReportJobStatus reportJobStatus4 = ReportJobStatus.STARTED;
                if (reportJobStatus3 != null ? !((Object)((Object)reportJobStatus3)).equals((Object)reportJobStatus4) : reportJobStatus4 != null) break block8;
            }
            this.reportJob.setEndTime(ReportJobInstance$.MODULE$.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$currentTime());
            this.reportJob.setStatus(ReportJobStatus.ABORTED);
            this.reportJobRepository.update(this.reportJob);
            this.eventBus.publish((XLReleaseEvent)new ReportJobAbortedEvent(this.reportJob));
            Option<Future<Option<ReportResult>>> option = this.runningPromise();
            if (option instanceof Some) {
                Some some = (Some)option;
                Future future = (Future)some.value();
                future.cancel(true);
                this.runningPromise_$eq((Option<Future<Option<ReportResult>>>)None$.MODULE$);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("RunningPromise is none for report job [").append(this.getJobId()).append("]").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        }
    }

    private ReportResult complete(URI resultUri) {
        this.reportJob.setResultUri(resultUri.toString());
        this.reportJob.setEndTime(ReportJobInstance$.MODULE$.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$currentTime());
        this.reportJob.setStatus(ReportJobStatus.COMPLETED);
        this.reportJobRepository.update(this.reportJob);
        this.runningPromise_$eq((Option<Future<Option<ReportResult>>>)None$.MODULE$);
        this.eventBus.publish((XLReleaseEvent)new ReportJobCompletedEvent(this.reportJob));
        return this.globalReportStorage.reportResult(this.reportJob);
    }

    private void start() {
        this.reportJob.setNode(this.reportingEngineConfiguration.node());
        this.reportJob.setStartTime(ReportJobInstance$.MODULE$.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$currentTime());
        this.reportJob.setStatus(ReportJobStatus.STARTED);
        this.reportJobRepository.update(this.reportJob);
    }

    public ReportJobInstance(ReportJob reportJob, ApplicationContext applicationContext, ReportingEngineConfiguration reportingEngineConfiguration, ReportExecutorService reportExecutorService, ReportJobRepository reportJobRepository, GlobalReportStorage globalReportStorage, XLReleaseEventBus eventBus) {
        this.reportJob = reportJob;
        this.applicationContext = applicationContext;
        this.reportingEngineConfiguration = reportingEngineConfiguration;
        this.reportExecutorService = reportExecutorService;
        this.reportJobRepository = reportJobRepository;
        this.globalReportStorage = globalReportStorage;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        this.runningPromise = None$.MODULE$;
    }

    public static class DefaultReportJobProgressMonitor
    implements ReportJobProgressMonitor {
        private final ReportJobInstance reportJobInstance;

        @Override
        public void sendTotalWorkItems(int totalItems) {
            this.reportJobInstance.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$sendTotalWorkItems(totalItems);
        }

        @Override
        public void sendCompletedWorkItems(int completedItems) {
            this.reportJobInstance.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$sendCompletedWorkItems(completedItems);
            if (Thread.interrupted()) {
                throw new InterruptedException(new StringBuilder(25).append("Report job [").append(this.reportJobInstance.getJobId()).append("] was aborted").toString());
            }
        }

        public DefaultReportJobProgressMonitor(ReportJobInstance reportJobInstance) {
            this.reportJobInstance = reportJobInstance;
        }
    }
}

