/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.excel;

import com.xebialabs.xlrelease.excel.Export;
import com.xebialabs.xlrelease.reports.dto.TaskDuration;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;

public class TopLongestTaskExport
extends Export {
    private List<TaskDuration> topLongestTasks;
    public static final int TITLE_COLUMN = 0;
    public static final int DURATION_COLUMN = 1;
    public static final int RELEASE_COLUMN = 2;
    public static final int PHASE_COLUMN = 3;
    public static final int OWNER_COLUMN = 4;
    public static final int TEAM_COLUMN = 5;
    private static final String TITLE_HEADER = "Task";
    private static final String DURATION_HEADER = "Duration";
    private static final String RELEASE_HEADER = "Release";
    private static final String PHASE_HEADER = "Phase";
    private static final String OWNER_HEADER = "Owner";
    private static final String TEAM_HEADER = "Team";

    public TopLongestTaskExport(List<TaskDuration> topLongestTasks) {
        this.topLongestTasks = topLongestTasks;
    }

    protected void addContent() {
        for (TaskDuration taskDuration : this.topLongestTasks) {
            XSSFRow row = this.sheet.createRow(this.rowIndex++);
            CellUtil.createCell((Row)row, (int)0, (String)taskDuration.getTitle());
            XSSFCell duration = row.createCell(1);
            duration.setCellValue((double)taskDuration.getDuration());
            CellUtil.createCell((Row)row, (int)2, (String)taskDuration.getRelease());
            CellUtil.createCell((Row)row, (int)3, (String)taskDuration.getPhase());
            String user = taskDuration.getOwner().getFullName();
            if (user == null) {
                user = taskDuration.getOwner().getUsername();
            }
            CellUtil.createCell((Row)row, (int)4, (String)user);
            CellUtil.createCell((Row)row, (int)5, (String)taskDuration.getTeam());
        }
    }

    protected void setColumnsWidth() {
        this.sheet.setColumnWidth(0, TopLongestTaskExport.numberOfCharacter((int)30));
        this.sheet.setColumnWidth(1, TopLongestTaskExport.numberOfCharacter((int)10));
        this.sheet.setColumnWidth(2, TopLongestTaskExport.numberOfCharacter((int)20));
        this.sheet.setColumnWidth(3, TopLongestTaskExport.numberOfCharacter((int)20));
        this.sheet.setColumnWidth(4, TopLongestTaskExport.numberOfCharacter((int)15));
        this.sheet.setColumnWidth(5, TopLongestTaskExport.numberOfCharacter((int)15));
    }

    protected void addHeaderRow() {
        XSSFRow row = this.sheet.createRow(this.rowIndex++);
        CellUtil.createCell((Row)row, (int)0, (String)TITLE_HEADER);
        CellUtil.createCell((Row)row, (int)1, (String)DURATION_HEADER);
        CellUtil.createCell((Row)row, (int)2, (String)RELEASE_HEADER);
        CellUtil.createCell((Row)row, (int)3, (String)PHASE_HEADER);
        CellUtil.createCell((Row)row, (int)4, (String)OWNER_HEADER);
        CellUtil.createCell((Row)row, (int)5, (String)TEAM_HEADER);
        this.sheet.createRow(this.rowIndex++);
    }
}

