/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.reports.db.ArchivedPhasesReports;
import com.xebialabs.xlrelease.reports.db.ArchivedReleasesReports;
import com.xebialabs.xlrelease.reports.db.ArchivedTasksReports;
import com.xebialabs.xlrelease.reports.dto.AverageAndLongestReleaseDuration;
import com.xebialabs.xlrelease.reports.dto.AverageAndLongestTaskDuration;
import com.xebialabs.xlrelease.reports.dto.CompletedReleases;
import com.xebialabs.xlrelease.reports.dto.LongestTaskType;
import com.xebialabs.xlrelease.reports.dto.PhaseDuration;
import com.xebialabs.xlrelease.reports.dto.ReleaseAutomationComputer;
import com.xebialabs.xlrelease.reports.dto.ReleaseAutomationData;
import com.xebialabs.xlrelease.reports.dto.ReleaseDuration;
import com.xebialabs.xlrelease.reports.dto.ReleaseEfficiency;
import com.xebialabs.xlrelease.reports.dto.ReleasesAutomation;
import com.xebialabs.xlrelease.reports.dto.ReleasesDuration;
import com.xebialabs.xlrelease.reports.dto.TaskDuration;
import com.xebialabs.xlrelease.reports.dto.UserParticipation;
import com.xebialabs.xlrelease.reports.service.ReportParams;
import com.xebialabs.xlrelease.views.Point;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportService {
    public static final int TOP_REPORT_SIZE = 100;
    private final ArchivedReleasesReports archivedReleasesReports;
    private final ArchivedPhasesReports archivedPhasesReports;
    private final ArchivedTasksReports archivedTasksReports;

    @Autowired
    public ReportService(ArchivedReleasesReports archivedReleasesReports, ArchivedPhasesReports archivedPhasesReports, ArchivedTasksReports archivedTasksReports) {
        this.archivedReleasesReports = archivedReleasesReports;
        this.archivedPhasesReports = archivedPhasesReports;
        this.archivedTasksReports = archivedTasksReports;
    }

    @Timed
    public ReleasesDuration getReleaseDuration(ReportParams params) {
        List<Point> releaseDuration = this.archivedReleasesReports.getReleaseDuration(params);
        List<ReleaseDuration> topLongestReleases = this.archivedReleasesReports.getLongestReleases(params);
        return new ReleasesDuration(releaseDuration, topLongestReleases);
    }

    @Timed
    public CompletedReleases getCompletedReleases(ReportParams params) {
        return this.archivedReleasesReports.getCompletedReleases(params);
    }

    @Timed
    public AverageAndLongestReleaseDuration getAverageAndLongestReleaseDuration(ReportParams params) {
        return this.archivedReleasesReports.getAverageAndLongestReleaseDuration(params);
    }

    @Timed
    public List<UserParticipation> getTopPeopleMostInvolved(ReportParams params) {
        return this.archivedTasksReports.getTopPeopleInvolved(params);
    }

    @Timed
    public List<TaskDuration> getTopLongestTasks(ReportParams params) {
        return this.archivedTasksReports.getTopLongestTasks(params);
    }

    @Timed
    public List<LongestTaskType> getTopLongestTaskTypes(ReportParams params) {
        return this.archivedTasksReports.getTopLongestTaskTypes(params);
    }

    @Timed
    public AverageAndLongestTaskDuration getAverageAndLongestTaskDuration(ReportParams params) {
        return this.archivedTasksReports.getAverageAndLongestTaskDuration(params);
    }

    @Timed
    public ReleasesAutomation getReleaseAutomationSeries(ReportParams params) {
        ReleaseEfficiency releaseEfficiency = this.archivedTasksReports.getReleaseEfficiency(params);
        List<ReleaseAutomationData> releaseAutomationData = this.getReleaseAutomation(params);
        ReleaseAutomationComputer computer = new ReleaseAutomationComputer(releaseAutomationData, releaseEfficiency);
        return computer.get();
    }

    @Timed
    public List<PhaseDuration> getTopLongestPhases(ReportParams params) {
        return this.archivedPhasesReports.getTopLongestPhases(params);
    }

    @Timed
    public List<Point> getNumberOfReleaseByMonth(ReportParams params) {
        return this.archivedReleasesReports.getNumberOfReleaseByMonth(params);
    }

    @Timed
    public List<ReleaseAutomationData> getReleaseAutomation(ReportParams params) {
        return this.archivedReleasesReports.getReleaseAutomation(params);
    }
}

