/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.excel;

import com.xebialabs.xlrelease.excel.Export;
import com.xebialabs.xlrelease.reports.domain.ReportError;
import com.xebialabs.xlrelease.reports.excel.ErrorSheet;
import com.xebialabs.xlrelease.reports.excel.ExcelSheetWriter;
import com.xebialabs.xlrelease.reports.excel.ExcelStyles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReportWorkbook {
    private static final String WARNING_EMOJI_UNICODE = "\u26a0";
    private XSSFWorkbook workbook;
    private List<ReportError> errors = new ArrayList<ReportError>();
    private AtomicBoolean errorSheetAdded = new AtomicBoolean(false);

    public ReportWorkbook() {
        this.workbook = new XSSFWorkbook();
    }

    public XSSFWorkbook getWorkbookWithoutErrorSheet() {
        Export.preventDynamicDataExchangeAttack((XSSFWorkbook)this.workbook);
        return this.workbook;
    }

    public ExcelSheetWriter createReportSection(String title) {
        return new ExcelSheetWriter(this, this.workbook.createSheet(title));
    }

    public XSSFWorkbook makeWorkbookWithErrors(ExcelStyles styles) {
        this.addErrorSheetIfNecessary(styles);
        Export.preventDynamicDataExchangeAttack((XSSFWorkbook)this.workbook);
        return this.workbook;
    }

    private void addErrorSheetIfNecessary(ExcelStyles styles) {
        if (this.errorSheetAdded.getAndSet(true)) {
            throw new IllegalStateException("Error sheet added more than once");
        }
        if (!this.errors.isEmpty()) {
            ExcelSheetWriter reportSection = this.createReportSection(String.format("%s Report errors (%d)", WARNING_EMOJI_UNICODE, this.errors.size()));
            new ErrorSheet(reportSection).addContent(styles);
        }
    }

    public void addError(ReportError error) {
        if (this.errorSheetAdded.get()) {
            throw new IllegalStateException("Error sheet already added, too late to submit new errors");
        }
        this.errors.add(error);
    }

    public List<ReportError> getErrors() {
        return this.errors;
    }
}

