/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.events.ConfigurationCopiedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicData;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskProfileUpdated;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005=e\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!AA\b\u0001BC\u0002\u0013\u0005Q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!!\u0018\u0001\t\u0003\ty\u0006C\u0004\u0002t\u0001!\t!!\u001e\t\u0011\u0005]\u0004\u0001)C\u0005\u0003sB\u0001\"! \u0001A\u0013%\u0011q\u0010\u0002\u0013%&\u001c8\u000e\u0015:pM&dWmU3sm&\u001cWM\u0003\u0002\u0017/\u000591/\u001a:wS\u000e,'B\u0001\r\u001a\u0003\u0011\u0011\u0018n]6\u000b\u0005iY\u0012!\u0003=me\u0016dW-Y:f\u0015\taR$A\u0005yK\nL\u0017\r\\1cg*\ta$A\u0002d_6\u001c\u0001aE\u0002\u0001C\u001d\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005a\u0013\u0001C4sSjTH.\u001a3\n\u00059J#a\u0002'pO\u001eLgnZ\u0001\fG&LEmU3sm&\u001cW\r\u0005\u00022g5\t!G\u0003\u0002\u00173%\u0011AG\r\u0002\f\u0007&LEmU3sm&\u001cW-A\fd_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011qGO\u0007\u0002q)\u0011\u0011(G\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u001e9\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u00180\u0001\u0005fm\u0016tGOQ;t+\u0005q\u0004CA C\u001b\u0005\u0001%BA!\u001a\u0003\u0019)g/\u001a8ug&\u00111\t\u0011\u0002\t\u000bZ,g\u000e\u001e\"vg\u0006IQM^3oi\n+8\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u001dK%j\u0013\t\u0003\u0011\u0002i\u0011!\u0006\u0005\u0006_\u0015\u0001\r\u0001\r\u0005\u0006k\u0015\u0001\rA\u000e\u0005\u0006y\u0015\u0001\rA\u0010\u0015\u0003\u000b5\u0003\"AT-\u000e\u0003=S!\u0001U)\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002S'\u00069a-Y2u_JL(B\u0001+V\u0003\u0015\u0011W-\u00198t\u0015\t1v+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005A\u0016aA8sO&\u0011!l\u0014\u0002\n\u0003V$xn^5sK\u0012\faa\u0019:fCR,GCA/d!\tq\u0016-D\u0001`\u0015\t\u0001w#\u0001\u0004e_6\f\u0017N\\\u0005\u0003E~\u00131BU5tWB\u0013xNZ5mK\")AM\u0002a\u0001;\u0006Y!/[:l!J|g-\u001b7fQ\t1a\r\u0005\u0002h[6\t\u0001N\u0003\u0002QS*\u0011!n[\u0001\b[\u0016$(/[2t\u0015\taW$\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\tq\u0007NA\u0003US6,G-\u0001\u0004fq&\u001cHo\u001d\u000b\u0003cR\u0004\"A\t:\n\u0005M\u001c#a\u0002\"p_2,\u0017M\u001c\u0005\u0006k\u001e\u0001\rA^\u0001\u000ee&\u001c8\u000e\u0015:pM&dW-\u00133\u0011\u0005]thB\u0001=}!\tI8%D\u0001{\u0015\tYx$\u0001\u0004=e>|GOP\u0005\u0003{\u000e\na\u0001\u0015:fI\u00164\u0017bA@\u0002\u0002\t11\u000b\u001e:j]\u001eT!!`\u0012)\u0005\u001d1\u0017\u0001\u00034j]\u0012\u0014\u00150\u00133\u0015\u0007u\u000bI\u0001C\u0003v\u0011\u0001\u0007a\u000f\u000b\u0002\tM\u0006iQ\r_5tiN\u0014\u0015\u0010V5uY\u0016$2!]A\t\u0011\u0019\t\u0019\"\u0003a\u0001m\u0006)A/\u001b;mK\"\u0012\u0011BZ\u0001\u0012M&tGMQ=JI>\u0013H)\u001a4bk2$HcA/\u0002\u001c!)QO\u0003a\u0001m\"\u0012!BZ\u0001\bM&tG-\u00117m)\t\t\u0019\u0003E\u0003\u0002&\u0005=R,\u0004\u0002\u0002()!\u0011\u0011FA\u0016\u0003\u0011)H/\u001b7\u000b\u0005\u00055\u0012\u0001\u00026bm\u0006LA!!\r\u0002(\t!A*[:uQ\tYa-A\u0006gS:$')\u001f+ji2,GcA/\u0002:!1\u00111\b\u0007A\u0002Y\f\u0001C]5tWB\u0013xNZ5mKRKG\u000f\\3)\u000511\u0017AB;qI\u0006$X\rF\u0002^\u0003\u0007BQ\u0001Z\u0007A\u0002uC#!\u00044\u0002\r\u0011,G.\u001a;f)\u0011\tY%!\u0015\u0011\u0007\t\ni%C\u0002\u0002P\r\u0012A!\u00168ji\")QO\u0004a\u0001m\"\u0012aBZ\u0001\u0005G>\u0004\u0018\u0010F\u0002^\u00033BQ!^\bA\u0002YD#a\u00044\u0002\u001b\u001d,GOU3gKJ,gnY3t)\u0011\t\t'a\u001c\u0011\r\u0005\u0015\u0012qFA2!\u0011\t)'a\u001b\u000e\u0005\u0005\u001d$bAA5q\u0005)\u0011/^3ss&!\u0011QNA4\u0005A\u0011V\r\\3bg\u0016\u0014\u0015m]5d\t\u0006$\u0018\rC\u0003v!\u0001\u0007a\u000f\u000b\u0002\u0011M\u0006Qr-\u001a8fe\u0006$X\rR3gCVdGOU5tWB\u0013xNZ5mKV\tQ,\u0001\bdQ\u0016\u001c7\u000eR;qY&\u001c\u0017\r^3\u0015\t\u0005-\u00131\u0010\u0005\u0007\u0003'\u0011\u0002\u0019\u0001<\u0002+\u001d,g.\u001a:bi\u0016\u0014\u0016n]6Qe>4\u0017\u000e\\3JIV\ta\u000fK\u0002\u0001\u0003\u0007\u0003B!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0004\u0003\u0013+\u0016AC:uKJ,w\u000e^=qK&!\u0011QRAD\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class RiskProfileService
implements Logging {
    private final CiIdService ciIdService;
    private final ConfigurationRepository configurationRepository;
    private final EventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskProfileService riskProfileService = this;
        synchronized (riskProfileService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public RiskProfile create(RiskProfile riskProfile) {
        this.checkDuplicate(riskProfile.getTitle());
        riskProfile.setId(this.generateRiskProfileId());
        this.configurationRepository.create((BaseConfiguration)riskProfile);
        this.eventBus().publish((XLReleaseEvent)new ConfigurationCreatedEvent((BaseConfiguration)riskProfile));
        return riskProfile;
    }

    @Timed
    public boolean exists(String riskProfileId) {
        return this.configurationRepository.exists(riskProfileId);
    }

    @Timed
    public RiskProfile findById(String riskProfileId) {
        return (RiskProfile)this.configurationRepository.read(riskProfileId);
    }

    @Timed
    public boolean existsByTitle(String title) {
        return this.configurationRepository.existsByTypeAndTitle(Type.valueOf(RiskProfile.class), title);
    }

    @Timed
    public RiskProfile findByIdOrDefault(String riskProfileId) {
        RiskProfile riskProfile;
        try {
            riskProfile = (RiskProfile)this.configurationRepository.read(riskProfileId);
        }
        catch (NotFoundException notFoundException) {
            riskProfile = this.generateDefaultRiskProfile();
        }
        return riskProfile;
    }

    @Timed
    public List<RiskProfile> findAll() {
        return this.configurationRepository.findAllByType(Type.valueOf(RiskProfile.class));
    }

    @Timed
    public RiskProfile findByTitle(String riskProfileTitle) {
        List profiles = this.configurationRepository.findAllByTypeAndTitle(Type.valueOf(RiskProfile.class), riskProfileTitle);
        int n = profiles.size();
        switch (n) {
            case 0: {
                throw new NotFoundException(new StringBuilder(40).append("Could not find risk profile for title [").append(riskProfileTitle).append("]").toString(), new Object[0]);
            }
        }
        return (RiskProfile)profiles.get(0);
    }

    @Timed
    public RiskProfile update(RiskProfile riskProfile) {
        RiskProfile currentRiskProfile = this.findById(riskProfile.getId());
        String string = currentRiskProfile.getTitle();
        String string2 = riskProfile.getTitle();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.checkDuplicate(riskProfile.getTitle());
        }
        this.configurationRepository.update((BaseConfiguration)riskProfile);
        this.eventBus().publish((XLReleaseEvent)new RiskProfileUpdated(riskProfile));
        return riskProfile;
    }

    @Timed
    public void delete(String riskProfileId) {
        RiskProfile riskProfile = this.findById(riskProfileId);
        this.configurationRepository.delete(riskProfileId);
        this.eventBus().publish((XLReleaseEvent)new ConfigurationDeletedEvent((BaseConfiguration)riskProfile));
    }

    @Timed
    public RiskProfile copy(String riskProfileId) {
        RiskProfile riskProfile = this.findById(riskProfileId);
        String copyRiskProfileTitle = riskProfile.getTitle();
        while (this.existsByTitle(copyRiskProfileTitle)) {
            copyRiskProfileTitle = RetryTitleGenerator.getNextTitle((String)copyRiskProfileTitle);
        }
        RiskProfile copyRiskProfile = (RiskProfile)Type.valueOf(RiskProfile.class).getDescriptor().newInstance(this.generateRiskProfileId());
        copyRiskProfile.setTitle(copyRiskProfileTitle);
        copyRiskProfile.setRiskProfileAssessors(riskProfile.getRiskProfileAssessors());
        this.configurationRepository.create((BaseConfiguration)copyRiskProfile);
        this.eventBus().publish((XLReleaseEvent)new ConfigurationCopiedEvent((BaseConfiguration)riskProfile, copyRiskProfile.getId()));
        return copyRiskProfile;
    }

    @Timed
    public List<ReleaseBasicData> getReferences(String riskProfileId) {
        return this.configurationRepository.getReferenceReleases(riskProfileId);
    }

    public RiskProfile generateDefaultRiskProfile() {
        RiskProfile defaultRiskProfile = (RiskProfile)Type.valueOf(RiskProfile.class).getDescriptor().newInstance(null);
        ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class))).asScala().filter((Function1 & Serializable)type -> BoxesRunTime.boxToBoolean((boolean)RiskProfileService.$anonfun$generateDefaultRiskProfile$1(type)))).foreach((Function1 & Serializable)t -> {
            defaultRiskProfile.setValueFor(t, BoxesRunTime.unboxToInt((Object)t.getDescriptor().getPropertyDescriptor("score").getDefaultValue()));
            return BoxedUnit.UNIT;
        });
        return defaultRiskProfile;
    }

    private void checkDuplicate(String title) {
        if (this.existsByTitle(title)) {
            throw new ItemAlreadyExistsException("Risk profile '%s' already exist.", new Object[]{title});
        }
    }

    private String generateRiskProfileId() {
        return this.ciIdService.getUniqueId(Type.valueOf(RiskProfile.class), Ids.RISK_PROFILE_CONFIGURATION_ROOT);
    }

    public static final /* synthetic */ boolean $anonfun$generateDefaultRiskProfile$1(Type type) {
        return !type.getDescriptor().isVirtual();
    }

    @Autowired
    public RiskProfileService(CiIdService ciIdService, ConfigurationRepository configurationRepository, EventBus eventBus) {
        this.ciIdService = ciIdService;
        this.configurationRepository = configurationRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

