/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.PhaseDeletedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseDuplicatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseProgressCalculated;
import com.xebialabs.xlrelease.domain.events.TaskCompletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCopiedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskReopenedEvent;
import com.xebialabs.xlrelease.domain.events.TaskSkippedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.risk.domain.progress.ReleaseProgress;
import com.xebialabs.xlrelease.risk.repository.ProgressRepository;
import com.xebialabs.xlrelease.risk.service.ReleaseProgressWithReleaseId;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005mf\u0001\u0002\n\u0014\u0001yA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!)1\b\u0001C\u0001y!)\u0001\u000b\u0001C\u0001#\")!\r\u0001C\u0001G\")!\u000e\u0001C\u0001W\")!\u000f\u0001C\u0001g\")!\u0010\u0001C\u0001w\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002j\u0001!I!a\u001b\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\"9\u00111\u0012\u0001\u0005\n\u00055\u0005bBAI\u0001\u0011%\u00111\u0013\u0002\u0010!J|wM]3tgN+'O^5dK*\u0011A#F\u0001\bg\u0016\u0014h/[2f\u0015\t1r#\u0001\u0003sSN\\'B\u0001\r\u001a\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001b7\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00029\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t13&D\u0001(\u0015\tA\u0013&A\u0003tY\u001a$$NC\u0001+\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u0017(\u0005\u001daunZ4j]\u001e\f!\u0003\u001d:pOJ,7o\u001d*fa>\u001c\u0018\u000e^8ssB\u0011qFM\u0007\u0002a)\u0011\u0011'F\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u001a1\u0005I\u0001&o\\4sKN\u001c(+\u001a9pg&$xN]=\u0002\u0011\u00154XM\u001c;CkN\u0004\"AN\u001d\u000e\u0003]R!\u0001O\f\u0002\r\u00154XM\u001c;t\u0013\tQtG\u0001\u0005Fm\u0016tGOQ;t\u0003\u0019a\u0014N\\5u}Q\u0019Qh\u0010!\u0011\u0005y\u0002Q\"A\n\t\u000b5\u001a\u0001\u0019\u0001\u0018\t\u000bQ\u001a\u0001\u0019A\u001b)\u0005\r\u0011\u0005CA\"O\u001b\u0005!%BA#G\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u000f\"\u000bqAZ1di>\u0014\u0018P\u0003\u0002J\u0015\u0006)!-Z1og*\u00111\nT\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tQ*A\u0002pe\u001eL!a\u0014#\u0003\u0013\u0005+Ho\\<je\u0016$\u0017A\u0004:fY\u0016\f7/Z\"sK\u0006$X\r\u001a\u000b\u0003%V\u0003\"\u0001I*\n\u0005Q\u000b#\u0001B+oSRDQA\u0016\u0003A\u0002]\u000b1C]3mK\u0006\u001cXm\u0011:fCR,G-\u0012<f]R\u0004\"\u0001\u0017/\u000e\u0003eS!\u0001\u000f.\u000b\u0005m;\u0012A\u00023p[\u0006Lg.\u0003\u0002^3\n\u0019\"+\u001a7fCN,7I]3bi\u0016$WI^3oi\"\u0012Aa\u0018\t\u0003m\u0001L!!Y\u001c\u0003\u0013M+(m]2sS\n,\u0017a\u00049iCN,G)\u001e9mS\u000e\fG/\u001a3\u0015\u0005I#\u0007\"B3\u0006\u0001\u00041\u0017\u0001\u00069iCN,G)\u001e9mS\u000e\fG/\u001a3Fm\u0016tG\u000f\u0005\u0002YO&\u0011\u0001.\u0017\u0002\u0015!\"\f7/\u001a#va2L7-\u0019;fI\u00163XM\u001c;)\u0005\u0015y\u0016\u0001\u00049iCN,G)\u001a7fi\u0016$GC\u0001*m\u0011\u0015ig\u00011\u0001o\u0003E\u0001\b.Y:f\t\u0016dW\r^3e\u000bZ,g\u000e\u001e\t\u00031>L!\u0001]-\u0003#AC\u0017m]3EK2,G/\u001a3Fm\u0016tG\u000f\u000b\u0002\u0007?\u0006YA/Y:l'.L\u0007\u000f]3e)\t\u0011F\u000fC\u0003v\u000f\u0001\u0007a/\u0001\tuCN\\7k[5qa\u0016$WI^3oiB\u0011\u0001l^\u0005\u0003qf\u0013\u0001\u0003V1tWN[\u0017\u000e\u001d9fI\u00163XM\u001c;)\u0005\u001dy\u0016!\u0004;bg.\u001cu.\u001c9mKR,G\r\u0006\u0002Sy\")Q\u0010\u0003a\u0001}\u0006\u0011B/Y:l\u0007>l\u0007\u000f\\3uK\u0012,e/\u001a8u!\tAv0C\u0002\u0002\u0002e\u0013!\u0003V1tW\u000e{W\u000e\u001d7fi\u0016$WI^3oi\"\u0012\u0001bX\u0001\fi\u0006\u001c8n\u0011:fCR,G\rF\u0002S\u0003\u0013Aq!a\u0003\n\u0001\u0004\ti!\u0001\tuCN\\7I]3bi\u0016$WI^3oiB\u0019\u0001,a\u0004\n\u0007\u0005E\u0011L\u0001\tUCN\\7I]3bi\u0016$WI^3oi\"\u0012\u0011bX\u0001\u000fi\u0006\u001c8\u000eR;qY&\u001c\u0017\r^3e)\r\u0011\u0016\u0011\u0004\u0005\b\u00037Q\u0001\u0019AA\u000f\u0003=!\u0018m]6D_BLW\rZ#wK:$\bc\u0001-\u0002 %\u0019\u0011\u0011E-\u0003\u001fQ\u000b7o[\"pa&,G-\u0012<f]RD#AC0\u0002\u0017Q\f7o\u001b#fY\u0016$X\r\u001a\u000b\u0004%\u0006%\u0002bBA\u0016\u0017\u0001\u0007\u0011QF\u0001\u0011i\u0006\u001c8\u000eR3mKR,G-\u0012<f]R\u00042\u0001WA\u0018\u0013\r\t\t$\u0017\u0002\u0011)\u0006\u001c8\u000eR3mKR,G-\u0012<f]RD#aC0\u0002\u0019Q\f7o\u001b*f_B,g.\u001a3\u0015\u0007I\u000bI\u0004C\u0004\u0002<1\u0001\r!!\u0010\u0002#Q\f7o\u001b*f_B,g.\u001a3Fm\u0016tG\u000fE\u0002Y\u0003\u007fI1!!\u0011Z\u0005E!\u0016m]6SK>\u0004XM\\3e\u000bZ,g\u000e\u001e\u0015\u0003\u0019}\u000bQ#\u001e9eCR,'+\u001a7fCN,\u0007K]8he\u0016\u001c8\u000fF\u0002S\u0003\u0013Bq!a\u0013\u000e\u0001\u0004\ti%A\u0004sK2,\u0017m]3\u0011\t\u0005=\u0013\u0011K\u0007\u00025&\u0019\u00111\u000b.\u0003\u000fI+G.Z1tK\"\u001aQ\"a\u0016\u0011\t\u0005e\u0013QM\u0007\u0003\u00037R1!RA/\u0015\u0011\ty&!\u0019\u0002\u000f5,GO]5dg*\u0019\u00111M\u000e\u0002\u0011\r|G-\u00195bY\u0016LA!a\u001a\u0002\\\t)A+[7fI\u0006i1\u000f^8sKB\u0013xn\u001a:fgN$B!!\u001c\u0002|A!\u0011qNA<\u001b\t\t\tH\u0003\u0003\u0002t\u0005U\u0014\u0001\u00039s_\u001e\u0014Xm]:\u000b\u0005m+\u0012\u0002BA=\u0003c\u0012qBU3mK\u0006\u001cX\r\u0015:pOJ,7o\u001d\u0005\b\u0003{r\u0001\u0019AA@\u0003q\u0011X\r\\3bg\u0016\u0004&o\\4sKN\u001cx+\u001b;i%\u0016dW-Y:f\u0013\u0012\u00042APAA\u0013\r\t\u0019i\u0005\u0002\u001d%\u0016dW-Y:f!J|wM]3tg^KG\u000f\u001b*fY\u0016\f7/Z%e\u0003a\u0019\u0017\r\\2vY\u0006$XMU3mK\u0006\u001cX\r\u0015:pOJ,7o\u001d\u000b\u0005\u0003\u007f\nI\tC\u0004\u0002L=\u0001\r!!\u0014\u0002#\r\fGnY;mCR,\u0007K]8he\u0016\u001c8\u000f\u0006\u0003\u0002n\u0005=\u0005bBA&!\u0001\u0007\u0011QJ\u0001\u0010SN$\u0016m]6D_6\u0004H.\u001a;fIR!\u0011QSAN!\r\u0001\u0013qS\u0005\u0004\u00033\u000b#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003;\u000b\u0002\u0019AAP\u0003\u0011!\u0018m]6\u0011\t\u0005=\u0013\u0011U\u0005\u0004\u0003GS&\u0001\u0002+bg.D3\u0001AAT!\r1\u0014\u0011V\u0005\u0004\u0003W;$!D#wK:$H*[:uK:,'\u000fK\u0002\u0001\u0003_\u0003B!!-\u000286\u0011\u00111\u0017\u0006\u0004\u0003kS\u0015AC:uKJ,w\u000e^=qK&!\u0011\u0011XAZ\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class ProgressService
implements Logging {
    private final ProgressRepository progressRepository;
    private final EventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ProgressService progressService = this;
        synchronized (progressService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void releaseCreated(ReleaseCreatedEvent releaseCreatedEvent) {
        this.updateReleaseProgress(releaseCreatedEvent.release());
    }

    @Subscribe
    public void phaseDuplicated(PhaseDuplicatedEvent phaseDuplicatedEvent) {
        this.updateReleaseProgress(phaseDuplicatedEvent.phaseDuplicate().getRelease());
    }

    @Subscribe
    public void phaseDeleted(PhaseDeletedEvent phaseDeletedEvent) {
        this.updateReleaseProgress(phaseDeletedEvent.phase().getRelease());
    }

    @Subscribe
    public void taskSkipped(TaskSkippedEvent taskSkippedEvent) {
        this.updateReleaseProgress(taskSkippedEvent.task().getRelease());
    }

    @Subscribe
    public void taskCompleted(TaskCompletedEvent taskCompletedEvent) {
        this.updateReleaseProgress(taskCompletedEvent.task().getRelease());
    }

    @Subscribe
    public void taskCreated(TaskCreatedEvent taskCreatedEvent) {
        this.updateReleaseProgress(taskCreatedEvent.task().getRelease());
    }

    @Subscribe
    public void taskDuplicated(TaskCopiedEvent taskCopiedEvent) {
        this.updateReleaseProgress(taskCopiedEvent.task().getRelease());
    }

    @Subscribe
    public void taskDeleted(TaskDeletedEvent taskDeletedEvent) {
        this.updateReleaseProgress(taskDeletedEvent.task().getRelease());
    }

    @Subscribe
    public void taskReopened(TaskReopenedEvent taskReopenedEvent) {
        this.updateReleaseProgress(taskReopenedEvent.task().getRelease());
    }

    @Timed
    public void updateReleaseProgress(Release release) {
        if (!release.isTemplate()) {
            ReleaseProgressWithReleaseId releaseProgressWithId = this.calculateReleaseProgress(release);
            this.storeProgress(releaseProgressWithId);
            return;
        }
    }

    private ReleaseProgress storeProgress(ReleaseProgressWithReleaseId releaseProgressWithReleaseId) {
        ReleaseProgress savedReleaseProgress = this.progressRepository.createOrUpdate(releaseProgressWithReleaseId.releaseProgress());
        this.eventBus.publish((XLReleaseEvent)new ReleaseProgressCalculated(releaseProgressWithReleaseId.releaseId(), (ReleaseExtension)savedReleaseProgress));
        return savedReleaseProgress;
    }

    private ReleaseProgressWithReleaseId calculateReleaseProgress(Release release) {
        return new ReleaseProgressWithReleaseId(release.getId(), this.calculateProgress(release));
    }

    private ReleaseProgress calculateProgress(Release release) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(32).append("Calculating progress of release ").append(release.getId()).toString());
        List allTasks = release.getAllTasks();
        int totalTasks = allTasks.size();
        int tasksCompleted = CollectionConverters$.MODULE$.ListHasAsScala(allTasks).asScala().count((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)this.isTaskCompleted(task)));
        ReleaseProgress releaseProgress = new ReleaseProgress();
        releaseProgress.setId(new StringBuilder(9).append(release.getId()).append("/progress").toString());
        releaseProgress.setTotalRemainingTasks(totalTasks - tasksCompleted);
        releaseProgress.setTotalTasks(totalTasks);
        scala.collection.immutable.Map phasesProgress = (scala.collection.immutable.Map)CollectionConverters$.MODULE$.ListHasAsScala(release.getPhases()).asScala().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                scala.collection.immutable.Map acc = (scala.collection.immutable.Map)tuple2._1();
                Phase phase = (Phase)tuple2._2();
                int totalPhaseTasks = phase.getAllTasks().size();
                int tasksCompletedInPhase = CollectionConverters$.MODULE$.ListHasAsScala(phase.getAllTasks()).asScala().count((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)this.isTaskCompleted(task)));
                return (scala.collection.immutable.Map)acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)phase.getId()), (Object)new StringBuilder(1).append(totalPhaseTasks).append(";").append(tasksCompletedInPhase).toString()));
            }
            throw new MatchError((Object)tuple2);
        });
        releaseProgress.setPhasesProgress(CollectionConverters$.MODULE$.MapHasAsJava((Map)phasesProgress).asJava());
        return releaseProgress;
    }

    private boolean isTaskCompleted(Task task) {
        return task.isDone() || task.isDoneInAdvance();
    }

    @Autowired
    public ProgressService(ProgressRepository progressRepository, EventBus eventBus) {
        this.progressRepository = progressRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

