package com.xebialabs.xlrelease.risk.builder;

import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;

public class RiskProfileBuilder {

    private String id;
    private String title;
    private Map<String, String> riskAssessors = new HashMap<>();

    public RiskProfileBuilder() {
    }

    public static RiskProfileBuilder newRiskProfile() {
        return new RiskProfileBuilder();
    }

    public RiskProfileBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public RiskProfileBuilder withRiskAssessor(final String riskAssessorKey, final String score) {
        riskAssessors.put(riskAssessorKey, score);
        return this;
    }

    public RiskProfile build() {
        RiskProfile riskProfile = Type.valueOf(RiskProfile.class).getDescriptor().newInstance(id);
        DescriptorRegistry.getSubtypes(Type.valueOf(RiskAssessor.class))
                .stream()
                .filter(t -> !t.getDescriptor().isVirtual())
                .forEach(t -> {
                    riskProfile.setValueFor(t, (int) t.getDescriptor().getPropertyDescriptor("score").getDefaultValue());
                });
        riskProfile.setTitle(title);
        riskProfile.setRiskProfileAssessors(riskAssessors);
        return riskProfile;
    }

    public RiskProfileBuilder withTitle(final String title) {
        this.title = title;
        return this;
    }
}
