package com.xebialabs.xlrelease.risk.spring.config;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import com.codahale.metrics.InstrumentedExecutorService;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory;

@Configuration
@EnableAsync
public class RiskConfiguration {

    public static final String RISK_CALCULATION_EXECUTOR = "riskCalculationExecutor";

    @Bean(name = RISK_CALCULATION_EXECUTOR)
    public RestartableExecutorService riskCalculationExecutor(XlrConfig xlrConfig) {
        return new RestartableExecutorService("risk-calculation", () -> {
            ExecutorService executor = Executors.newFixedThreadPool(4, new PrefixedThreadFactory("risk-calculation", true));
            if (xlrConfig.metrics().enabled()) {
                return new InstrumentedExecutorService(executor, XlrMetricRegistry.metricRegistry(), "riskCalculation");
            }
            return executor;
        });
    }

    @Bean
    public Executor riskCalculationBatchExecutor(XlrConfig xlrConfig) {
        ExecutorService executor = Executors.newFixedThreadPool(2, new PrefixedThreadFactory("risk-calculation-batch", true));
        if (xlrConfig.metrics().enabled()) {
            return new InstrumentedExecutorService(executor, XlrMetricRegistry.metricRegistry(), "riskCalculationBatch");
        }
        return executor;
    }
}
