/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.configuration.RiskCalculationSettings;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskScoreUpdated;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.RiskRepository;
import com.xebialabs.xlrelease.risk.service.RiskCalculator;
import com.xebialabs.xlrelease.risk.service.RiskProfileService;
import com.xebialabs.xlrelease.scheduler.RestartableExecutorService;
import com.xebialabs.xlrelease.utils.Diff;
import com.xebialabs.xlrelease.utils.Diff$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011\r\u0004!\u0011!Q\u0001\n\u0011DQa\u001a\u0001\u0005\u0002!DqA\u001d\u0001C\u0002\u0013%1\u000fC\u0004\u0002\u001a\u0001\u0001\u000b\u0011\u0002;\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u00111\u0004\u0001\u0005\n\u0005e\u0002bBA&\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003?\u0002A\u0011AA1\u0011\u001d\t)\u0007\u0001C\u0005\u0003OBq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002\u0000\u0001!I!!!\t\u000f\u0005E\u0005\u0001\"\u0003\u0002\u0014\"9\u0011\u0011\u0014\u0001\u0005\n\u0005m\u0005bBAW\u0001\u0011%\u0011q\u0016\u0002\f%&\u001c8nU3sm&\u001cWM\u0003\u0002\u00181\u000591/\u001a:wS\u000e,'BA\r\u001b\u0003\u0011\u0011\u0018n]6\u000b\u0005ma\u0012!\u0003=me\u0016dW-Y:f\u0015\tib$A\u0005yK\nL\u0017\r\\1cg*\tq$A\u0002d_6\u001c\u0001aE\u0002\u0001E!\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0007CA\u0015+\u001b\u00051\u0012BA\u0016\u0017\u00059\u0011\u0016n]6DC2\u001cW\u000f\\1u_J\faB]5tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002/c5\tqF\u0003\u000211\u0005Q!/\u001a9pg&$xN]=\n\u0005Iz#A\u0004*jg.\u0014V\r]8tSR|'/_\u0001\u0013e&\u001c8\u000e\u0015:pM&dWmU3sm&\u001cW\r\u0005\u0002*k%\u0011aG\u0006\u0002\u0013%&\u001c8\u000e\u0015:pM&dWmU3sm&\u001cW-A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW\r\u0005\u0002:y5\t!H\u0003\u0002<5\u00051\u0011m\u0019;peNL!!\u0010\u001e\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002A\u00056\t\u0011I\u0003\u000215%\u00111)\u0011\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018\u0001C3wK:$()^:\u0011\u0005\u0019KU\"A$\u000b\u0005!S\u0012AB3wK:$8/\u0003\u0002K\u000f\n\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002/IL7o[\"bY\u000e,H.\u0019;j_:,\u00050Z2vi>\u0014\bCA'Q\u001b\u0005q%BA(\u001b\u0003%\u00198\r[3ek2,'/\u0003\u0002R\u001d\nQ\"+Z:uCJ$\u0018M\u00197f\u000bb,7-\u001e;peN+'O^5dK\"\"aaU1c!\t!v,D\u0001V\u0015\t1v+\u0001\u0006b]:|G/\u0019;j_:T!\u0001W-\u0002\u000f\u0019\f7\r^8ss*\u0011!lW\u0001\u0006E\u0016\fgn\u001d\u0006\u00039v\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002=\u0006\u0019qN]4\n\u0005\u0001,&!C)vC2Lg-[3s\u0003\u00151\u0018\r\\;fC\u0005Y\u0015aF2p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z!\t\u0001U-\u0003\u0002g\u0003\n92i\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011%T7\u000e\\7o_F\u0004\"!\u000b\u0001\t\u000b1B\u0001\u0019A\u0017\t\u000bMB\u0001\u0019\u0001\u001b\t\u000b]B\u0001\u0019\u0001\u001d\t\u000byB\u0001\u0019A \t\u000b\u0011C\u0001\u0019A#\t\u000b-C\u0001\u0019\u0001')\t=\u001c\u0016M\u0019\u0005\u0006G\"\u0001\r\u0001Z\u0001\u0012e&\u001c8.Q:tKN\u001cxN\u001d+za\u0016\u001cX#\u0001;\u0011\tUl\u0018\u0011\u0001\b\u0003mnt!a\u001e>\u000e\u0003aT!!\u001f\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0013B\u0001?%\u0003\u001d\u0001\u0018mY6bO\u0016L!A`@\u0003\t1K7\u000f\u001e\u0006\u0003y\u0012\u0002B!a\u0001\u0002\u00165\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0004sK\u001adWm\u0019;\u000b\t\u0005-\u0011QB\u0001\u0004CBL'\u0002BA\b\u0003#\ta\u0001\u001d7vO&t'bAA\n9\u0005AA-\u001a9m_fLG/\u0003\u0003\u0002\u0018\u0005\u0015!\u0001\u0002+za\u0016\f!C]5tW\u0006\u001b8/Z:t_J$\u0016\u0010]3tA\u0005i2-\u00197dk2\fG/\u001a*jg.\fe\u000eZ+qI\u0006$XMU3mK\u0006\u001cX\r\u0006\u0003\u0002 \u0005\u0015\u0002cA\u0012\u0002\"%\u0019\u00111\u0005\u0013\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003OY\u0001\u0019AA\u0015\u0003%\u0011X\r\\3bg\u0016LE\r\u0005\u0003\u0002,\u0005Mb\u0002BA\u0017\u0003_\u0001\"a\u001e\u0013\n\u0007\u0005EB%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\t9D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003c!C\u0003BA\u0010\u0003wAq!!\u0010\r\u0001\u0004\ty$A\u0004sK2,\u0017m]3\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007R1!!\u0012\u001b\u0003\u0019!w.\\1j]&!\u0011\u0011JA\"\u0005\u001d\u0011V\r\\3bg\u0016\fQbY1mGVd\u0017\r^3SSN\\GCBA(\u00033\ni\u0006\u0005\u0003\u0002R\u0005USBAA*\u0015\r\t)\u0005G\u0005\u0005\u0003/\n\u0019F\u0001\u0003SSN\\\u0007bBA.\u001b\u0001\u0007\u0011qJ\u0001\r_JLw-\u001b8bYJK7o\u001b\u0005\b\u0003{i\u0001\u0019AA \u0003\u001d9W\r\u001e*jg.$B!a\u0014\u0002d!9\u0011q\u0005\bA\u0002\u0005%\u0012AD4fiJK7o\u001b)s_\u001aLG.\u001a\u000b\u0005\u0003S\ny\u0007\u0005\u0003\u0002R\u0005-\u0014\u0002BA7\u0003'\u00121BU5tWB\u0013xNZ5mK\"9\u0011QH\bA\u0002\u0005}\u0012AC;qI\u0006$XMU5tWRA\u0011qJA;\u0003o\nY\bC\u0004\u0002(A\u0001\r!!\u000b\t\u000f\u0005e\u0004\u00031\u0001\u0002P\u0005AqN]5hS:\fG\u000eC\u0004\u0002~A\u0001\r!a\u0014\u0002\u000fU\u0004H-\u0019;fI\u0006)\"/[:l\u0003N\u001cXm]:nK:$8\t[1oO\u0016$GCBAB\u0003\u0013\u000bi\tE\u0002$\u0003\u000bK1!a\"%\u0005\u001d\u0011un\u001c7fC:Dq!a#\u0012\u0001\u0004\ty%A\u0001b\u0011\u001d\ty)\u0005a\u0001\u0003\u001f\n\u0011AY\u0001\rg\u000e|'/Z\"iC:<W\r\u001a\u000b\u0007\u0003\u0007\u000b)*a&\t\u000f\u0005-%\u00031\u0001\u0002P!9\u0011q\u0012\nA\u0002\u0005=\u0013AD4f]\u0016\u0014\u0018\r^3SSN\\\u0017\n\u001a\u000b\u0005\u0003;\u000bY\u000b\u0005\u0003\u0002 \u0006%VBAAQ\u0015\u0011\t\u0019+!*\u0002\t1\fgn\u001a\u0006\u0003\u0003O\u000bAA[1wC&!\u0011QGAQ\u0011\u001d\t9c\u0005a\u0001\u0003S\t!cZ3oKJ\fG/Z!tg\u0016\u001c8o\u001c:JIR!\u0011\u0011FAY\u0011\u001d\t\u0019\f\u0006a\u0001\u0003S\tA\"Y:tKN\u001cxN\u001d(b[\u0016D3\u0001AA\\!\u0011\tI,a0\u000e\u0005\u0005m&bAA_7\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005\u0005\u00171\u0018\u0002\b'\u0016\u0014h/[2f\u0001")
public class RiskService
implements RiskCalculator {
    private final RiskRepository riskRepository;
    private final RiskProfileService riskProfileService;
    private final ReleaseActorService releaseActorService;
    private final ReleaseRepository releaseRepository;
    private final XLReleaseEventBus eventBus;
    @Qualifier(value="riskCalculationExecutor")
    private final RestartableExecutorService riskCalculationExecutor;
    private final ConfigurationRepository configurationRepository;
    private final List<Type> riskAssessorTypes;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Risk calculateRisk(RiskProfile profile, List<RiskAssessor> riskAssessors, String riskId, Release release) {
        return RiskCalculator.calculateRisk$(this, profile, riskAssessors, riskId, release);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskService riskService = this;
        synchronized (riskService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private List<Type> riskAssessorTypes() {
        return this.riskAssessorTypes;
    }

    public void calculateRiskAndUpdateRelease(String releaseId) {
        RiskCalculationSettings riskCalculationSettings = (RiskCalculationSettings)this.configurationRepository.read("Configuration/settings/RiskCalculationSettings");
        if (riskCalculationSettings.isEnabled()) {
            Runnable task = () -> {
                Release release = $this.releaseRepository.findById(releaseId);
                this.calculateRiskAndUpdateRelease(release);
            };
            this.riskCalculationExecutor.submit(task);
            return;
        }
    }

    private void calculateRiskAndUpdateRelease(Release release) {
        RiskCalculationSettings settings = (RiskCalculationSettings)this.configurationRepository.read("Configuration/settings/RiskCalculationSettings");
        if (settings.isEnabled() && release.isPlannedOrActive() && !release.isWorkflow()) {
            Risk originalRisk = this.riskRepository.findByIdOrDefault(this.generateRiskId(release.getId()));
            Risk updatedRisk = this.calculateRisk(originalRisk, release);
            this.updateRisk(release.getId(), originalRisk, updatedRisk);
            return;
        }
    }

    public Risk calculateRisk(Risk originalRisk, Release release) {
        if (release.isPlannedOrActive() && !release.isWorkflow()) {
            RiskCalculationSettings riskCalculationSettings = (RiskCalculationSettings)this.configurationRepository.read("Configuration/settings/RiskCalculationSettings");
            if (riskCalculationSettings.isEnabled()) {
                RiskProfile riskProfileByRelease = this.getRiskProfile(release);
                List riskAssessors = this.riskAssessorTypes().filter((Function1 & Serializable)type -> BoxesRunTime.boxToBoolean((boolean)riskProfileByRelease.hasRiskAssessorEnabled(type))).map((Function1 & Serializable)riskAssessorType -> (RiskAssessor)riskAssessorType.getDescriptor().newInstance(this.generateAssessorId(riskAssessorType.getName())));
                String riskId = this.generateRiskId(release.getId());
                return this.calculateRisk(riskProfileByRelease, (List<RiskAssessor>)riskAssessors, riskId, release);
            }
            return originalRisk;
        }
        return originalRisk;
    }

    public Risk getRisk(String releaseId) {
        String riskId = this.generateRiskId(releaseId);
        return this.riskRepository.findByIdOrDefault(riskId);
    }

    private RiskProfile getRiskProfile(Release release) {
        return (RiskProfile)Option$.MODULE$.apply(release.getProperty("riskProfile")).getOrElse((Function0 & Serializable)() -> $this.riskProfileService.findByIdOrDefault(RiskProfile.DEFAULT_RISK_PROFILE_ID));
    }

    public Risk updateRisk(String releaseId, Risk original, Risk updated) {
        block0: {
            if (!this.scoreChanged(original, updated) && !this.riskAssessmentChanged(original, updated)) break block0;
            Object object = original.getRiskAssessments().isEmpty() ? this.riskRepository.create(updated) : BoxesRunTime.boxToBoolean((boolean)this.riskRepository.update(updated));
            this.logger().info((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Updated risk score for release " + releaseId + " from " + original.getScore() + " to " + updated.getScore() + " and total risk score from " + original.getTotalScore() + " to " + updated.getTotalScore())));
            this.releaseRepository.setRiskScores(releaseId, Predef$.MODULE$.Integer2int(updated.getScore()), Predef$.MODULE$.Integer2int(updated.getTotalScore()));
            this.releaseActorService.updateReleaseRiskScores(releaseId, updated.getScore(), updated.getTotalScore());
            this.eventBus.publish((XLReleaseEvent)new RiskScoreUpdated(releaseId, Option$.MODULE$.apply((Object)original), updated));
        }
        return updated;
    }

    private boolean riskAssessmentChanged(Risk a, Risk b) {
        Function1 & Serializable keyMapping = (Function1 & Serializable)ra -> ra.getRiskAssessorId();
        Function2 & Serializable areEqual = (Function2 & Serializable)(ra1, ra2) -> BoxesRunTime.boxToBoolean((boolean)RiskService.$anonfun$riskAssessmentChanged$2(ra1, ra2));
        Diff diff = Diff$.MODULE$.applyWithKeyMappingAndComparator((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(a.getRiskAssessments()).asScala(), (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(b.getRiskAssessments()).asScala(), (Function1)keyMapping, (Function2)areEqual);
        return diff.updatedEntries().nonEmpty() || diff.newEntries().nonEmpty() || diff.deletedEntries().nonEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scoreChanged(Risk a, Risk b) {
        Integer n = a.getScore();
        Integer n2 = b.getScore();
        if (n == null) {
            if (n2 != null) {
                return true;
            }
        } else if (!((Object)n).equals(n2)) return true;
        Integer n3 = a.getTotalScore();
        Integer n4 = b.getTotalScore();
        if (n3 == null) {
            if (n4 == null) return false;
            return true;
        } else if (((Object)n3).equals(n4)) return false;
        return true;
    }

    private String generateRiskId(String releaseId) {
        return releaseId + "/Risk";
    }

    private String generateAssessorId(String assessorName) {
        return Ids.ROOT_FOLDER_ID + "/" + assessorName;
    }

    public static final /* synthetic */ boolean $anonfun$riskAssessorTypes$1(Type x$1) {
        return !x$1.getDescriptor().isVirtual();
    }

    private static final boolean safeEquals$1(Object x, Object y) {
        Option option = Option$.MODULE$.apply(x);
        Option option2 = Option$.MODULE$.apply(y);
        return !(option != null ? !option.equals(option2) : option2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$riskAssessmentChanged$2(RiskAssessment ra1, RiskAssessment ra2) {
        return RiskService.safeEquals$1(ra1.getScore(), ra2.getScore()) && RiskService.safeEquals$1(ra1.getHeadline(), ra2.getHeadline()) && RiskService.safeEquals$1(ra1.getMessages(), ra2.getMessages());
    }

    public RiskService(RiskRepository riskRepository, RiskProfileService riskProfileService, ReleaseActorService releaseActorService, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus, @Qualifier(value="riskCalculationExecutor") RestartableExecutorService riskCalculationExecutor, ConfigurationRepository configurationRepository) {
        this.riskRepository = riskRepository;
        this.riskProfileService = riskProfileService;
        this.releaseActorService = releaseActorService;
        this.releaseRepository = releaseRepository;
        this.eventBus = eventBus;
        this.riskCalculationExecutor = riskCalculationExecutor;
        this.configurationRepository = configurationRepository;
        Logging.$init$((Logging)this);
        RiskCalculator.$init$(this);
        this.riskAssessorTypes = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class))).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RiskService.$anonfun$riskAssessorTypes$1(x$1)))).toList();
    }
}

