/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.api.v1;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.risk.configuration.RiskGlobalThresholds;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.RiskRepository;
import com.xebialabs.xlrelease.risk.service.RiskProfileService;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/risks")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class RiskApi
implements ApiService {
    private PermissionChecker permissions;
    private RiskProfileService riskProfileService;
    private ConfigurationRepository configurationRepository;
    private RiskRepository riskRepository;

    @Autowired
    public RiskApi(PermissionChecker permissions, RiskRepository riskRepository, ConfigurationRepository configurationRepository, RiskProfileService riskProfileService) {
        this.permissions = permissions;
        this.configurationRepository = configurationRepository;
        this.riskRepository = riskRepository;
        this.riskProfileService = riskProfileService;
    }

    @GET
    @Path(value="/{riskId:.*/Risk}")
    @AllCILevels
    public Risk getRisk(@PathParam(value="riskId") String riskId) {
        this.permissions.checkView(Ids.releaseIdFrom((String)riskId));
        return (Risk)((Object)this.riskRepository.findById(riskId));
    }

    @PublicApiMember
    public Risk getRisk(Release release) {
        return this.getRisk(release.getId() + "/Risk");
    }

    @GET
    @Path(value="/config")
    @AllCILevels
    @PublicApiMember
    public RiskGlobalThresholds getRiskGlobalThresholds() {
        return (RiskGlobalThresholds)this.configurationRepository.read("Configuration/risks/RiskGlobalThresholds");
    }

    @PUT
    @Path(value="/config")
    @AllCILevels
    @PublicApiMember
    public RiskGlobalThresholds updateRiskGlobalThresholds(RiskGlobalThresholds thresholds) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.configurationRepository.update((BaseConfiguration)thresholds);
        return (RiskGlobalThresholds)this.configurationRepository.read(thresholds.getId());
    }

    @GET
    @Path(value="/profiles")
    @PublicApiMember
    public List<RiskProfile> getRiskProfiles() {
        return this.riskProfileService.findAll();
    }

    @GET
    @Path(value="/profiles/{riskProfileId:.*/RiskProfile[^/]*|new}")
    @PublicApiMember
    public RiskProfile getRiskProfile(@PathParam(value="riskProfileId") String riskProfileId) {
        return this.riskProfileService.findByIdOrDefault(riskProfileId);
    }

    @PublicApiMember
    public RiskProfile getRiskProfileByTitle(String title) {
        return this.riskProfileService.findByTitle(title);
    }

    @PUT
    @Path(value="/profiles/{riskProfileId:.*/RiskProfile[^/]*}")
    public RiskProfile updateRiskProfile(@PathParam(value="riskProfileId") String riskProfileId, RiskProfile riskProfile) {
        this.permissions.check(XLReleasePermissions.EDIT_RISK_PROFILE);
        this.validateValues(riskProfile);
        return this.riskProfileService.update(riskProfile);
    }

    @PublicApiMember
    public RiskProfile updateRiskProfile(RiskProfile riskProfile) {
        return this.updateRiskProfile(riskProfile.getId(), riskProfile);
    }

    @POST
    @Path(value="/profiles")
    @PublicApiMember
    public RiskProfile createRiskProfile(RiskProfile riskProfile) {
        this.permissions.check(XLReleasePermissions.EDIT_RISK_PROFILE);
        this.validateValues(riskProfile);
        return this.riskProfileService.create(riskProfile);
    }

    @DELETE
    @Path(value="/profiles/{riskProfileId:.*/RiskProfile[^/]*}")
    public void deleteRiskProfile(@PathParam(value="riskProfileId") String riskProfileId) {
        this.permissions.check(XLReleasePermissions.EDIT_RISK_PROFILE);
        this.riskProfileService.delete(riskProfileId);
    }

    @PublicApiMember
    public void deleteRiskProfile(RiskProfile riskProfile) {
        this.deleteRiskProfile(riskProfile.getId());
    }

    @POST
    @Path(value="/profiles/{riskProfileId:.*/RiskProfile[^/]*}/copy")
    public RiskProfile copyRiskProfile(@PathParam(value="riskProfileId") String riskProfileId) {
        this.permissions.check(XLReleasePermissions.EDIT_RISK_PROFILE);
        return this.riskProfileService.copy(riskProfileId);
    }

    @PublicApiMember
    public RiskProfile copyRiskProfile(RiskProfile riskProfile) {
        return this.copyRiskProfile(riskProfile.getId());
    }

    @GET
    @Path(value="/assessors")
    @AllCILevels
    @PublicApiMember
    public List<RiskAssessor> getAllRiskAssessors() {
        return DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class)).stream().filter(type -> !type.getDescriptor().isVirtual()).map(type -> (RiskAssessor)type.getDescriptor().newInstance(this.generateAssessorId(type.getName()))).collect(Collectors.toList());
    }

    private String generateAssessorId(String name) {
        return MessageFormat.format("{0}/{1}", Ids.ROOT_FOLDER_ID, name);
    }

    public String serviceName() {
        return "riskApi";
    }

    private void validateValues(RiskProfile riskProfile) {
        riskProfile.getRiskProfileAssessors().forEach((profile, score) -> Checks.checkArgument((score.chars().allMatch(Character::isDigit) && Integer.parseInt(score) >= 0 && Integer.parseInt(score) <= 100 ? 1 : 0) != 0, (String)String.format("Incorrect value %s for risk assessor %s. Value must be an integer between 0 and 100", score, profile), (Object[])new Object[0]));
    }
}

