/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseOverdueEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskAbortedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCompletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskFailedEvent;
import com.xebialabs.xlrelease.domain.events.TaskOverdueEvent;
import com.xebialabs.xlrelease.domain.events.TaskSkippedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.events.SynchronizedSubscribe;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskProfileUpdated;
import com.xebialabs.xlrelease.risk.service.RiskService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!1\u0005A!A!\u0002\u00139\u0005\"B)\u0001\t\u0003\u0011\u0006\"\u00025\u0001\t\u0003I\u0007\"B?\u0001\t\u0003q\bbBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002L\u0001!\t!!\u0014\t\u000f\u0005m\u0003\u0001\"\u0001\u0002^!9\u00111\u000e\u0001\u0005\u0002\u00055\u0004bBA>\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u0017\u0003A\u0011BAG\u0011\u001d\tY\n\u0001C\u0001\u0003;Cq!a.\u0001\t\u0013\tIL\u0001\tSSN\\WI^3oi\"\u000bg\u000e\u001a7fe*\u0011acF\u0001\bg\u0016\u0014h/[2f\u0015\tA\u0012$\u0001\u0003sSN\\'B\u0001\u000e\u001c\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001d;\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002=\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g!\tAS&D\u0001*\u0015\tQ3&A\u0003tY\u001a$$NC\u0001-\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u0018*\u0005\u001daunZ4j]\u001e\f\u0011\u0002\u001f7s\u0007>tg-[4\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005MJ\u0012AB2p]\u001aLw-\u0003\u00026e\tI\u0001\f\u001c:D_:4\u0017nZ\u0001\u0018G>tg-[4ve\u0006$\u0018n\u001c8SKB|7/\u001b;pef\u0004\"\u0001O\u001e\u000e\u0003eR!AO\r\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002=s\t92i\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/_\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\bC\u0001\u001d@\u0013\t\u0001\u0015HA\tSK2,\u0017m]3SKB|7/\u001b;pef\f1B]5tWN+'O^5dKB\u00111\tR\u0007\u0002+%\u0011Q)\u0006\u0002\f%&\u001c8nU3sm&\u001cW-\u0001\u000fsSN\\7)\u00197dk2\fG/[8o\u0005\u0006$8\r[#yK\u000e,Ho\u001c:\u0011\u0005!{U\"A%\u000b\u0005)[\u0015AC2p]\u000e,(O]3oi*\u0011A*T\u0001\u0005kRLGNC\u0001O\u0003\u0011Q\u0017M^1\n\u0005AK%\u0001C#yK\u000e,Ho\u001c:\u0002\rqJg.\u001b;?)\u0019\u0019F+\u0016,X1B\u00111\t\u0001\u0005\u0006_\u0019\u0001\r\u0001\r\u0005\u0006m\u0019\u0001\ra\u000e\u0005\u0006{\u0019\u0001\rA\u0010\u0005\u0006\u0003\u001a\u0001\rA\u0011\u0005\u0006\r\u001a\u0001\ra\u0012\u0015\u0003\ri\u0003\"a\u00174\u000e\u0003qS!!\u00180\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002`A\u00069a-Y2u_JL(BA1c\u0003\u0015\u0011W-\u00198t\u0015\t\u0019G-A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005)\u0017aA8sO&\u0011q\r\u0018\u0002\n\u0003V$xn^5sK\u0012\faB]3mK\u0006\u001cXm\u0011:fCR,G\r\u0006\u0002k[B\u0011!e[\u0005\u0003Y\u000e\u0012A!\u00168ji\")an\u0002a\u0001_\u0006\u0019\"/\u001a7fCN,7I]3bi\u0016$WI^3oiB\u0011\u0001/^\u0007\u0002c*\u0011!o]\u0001\u0007KZ,g\u000e^:\u000b\u0005QL\u0012A\u00023p[\u0006Lg.\u0003\u0002wc\n\u0019\"+\u001a7fCN,7I]3bi\u0016$WI^3oi\"\u0012q\u0001\u001f\t\u0003snl\u0011A\u001f\u0006\u0003efI!\u0001 >\u0003\u0013M+(m]2sS\n,\u0017A\u0004:fY\u0016\f7/Z+qI\u0006$X\r\u001a\u000b\u0003U~Dq!!\u0001\t\u0001\u0004\t\u0019!A\nsK2,\u0017m]3Va\u0012\fG/\u001a3Fm\u0016tG\u000fE\u0002q\u0003\u000bI1!a\u0002r\u0005M\u0011V\r\\3bg\u0016,\u0006\u000fZ1uK\u0012,e/\u001a8uQ\tA\u00010\u0001\bsK2,\u0017m]3Pm\u0016\u0014H-^3\u0015\u0007)\fy\u0001C\u0004\u0002\u0012%\u0001\r!a\u0005\u0002'I,G.Z1tK>3XM\u001d3vK\u00163XM\u001c;\u0011\u0007A\f)\"C\u0002\u0002\u0018E\u00141CU3mK\u0006\u001cXm\u0014<fe\u0012,X-\u0012<f]RD#!\u0003=\u0002\u0015Q\f7o\u001b$bS2,G\rF\u0002k\u0003?Aq!!\t\u000b\u0001\u0004\t\u0019#A\buCN\\g)Y5mK\u0012,e/\u001a8u!\r\u0001\u0018QE\u0005\u0004\u0003O\t(a\u0004+bg.4\u0015-\u001b7fI\u00163XM\u001c;)\u0005)A\u0018!\u0004;bg.\u001cu.\u001c9mKR,G\rF\u0002k\u0003_Aq!!\r\f\u0001\u0004\t\u0019$\u0001\nuCN\\7i\\7qY\u0016$X\rZ#wK:$\bc\u00019\u00026%\u0019\u0011qG9\u0003%Q\u000b7o[\"p[BdW\r^3e\u000bZ,g\u000e\u001e\u0015\u0003\u0017a\f1\u0002^1tWN[\u0017\u000e\u001d9fIR\u0019!.a\u0010\t\u000f\u0005\u0005C\u00021\u0001\u0002D\u0005\u0001B/Y:l'.L\u0007\u000f]3e\u000bZ,g\u000e\u001e\t\u0004a\u0006\u0015\u0013bAA$c\n\u0001B+Y:l'.L\u0007\u000f]3e\u000bZ,g\u000e\u001e\u0015\u0003\u0019a\f1\u0002^1tW\u0006\u0013wN\u001d;fIR\u0019!.a\u0014\t\u000f\u0005ES\u00021\u0001\u0002T\u0005\u0001B/Y:l\u0003\n|'\u000f^3e\u000bZ,g\u000e\u001e\t\u0004a\u0006U\u0013bAA,c\n\u0001B+Y:l\u0003\n|'\u000f^3e\u000bZ,g\u000e\u001e\u0015\u0003\u001ba\f1\u0002^1tWV\u0003H-\u0019;fIR\u0019!.a\u0018\t\u000f\u0005\u0005d\u00021\u0001\u0002d\u0005\u0001B/Y:l+B$\u0017\r^3e\u000bZ,g\u000e\u001e\t\u0004a\u0006\u0015\u0014bAA4c\n\u0001B+Y:l+B$\u0017\r^3e\u000bZ,g\u000e\u001e\u0015\u0003\u001da\f1\u0002^1tW>3XM\u001d3vKR\u0019!.a\u001c\t\u000f\u0005Et\u00021\u0001\u0002t\u0005\u0001B/Y:l\u001fZ,'\u000fZ;f\u000bZ,g\u000e\u001e\t\u0004a\u0006U\u0014bAA<c\n\u0001B+Y:l\u001fZ,'\u000fZ;f\u000bZ,g\u000e\u001e\u0015\u0003\u001fa\f1\u0002^1tW\u0012+G.\u001a;fIR\u0019!.a \t\u000f\u0005\u0005\u0005\u00031\u0001\u0002\u0004\u0006\u0001B/Y:l\t\u0016dW\r^3e\u000bZ,g\u000e\u001e\t\u0004a\u0006\u0015\u0015bAADc\n\u0001B+Y:l\t\u0016dW\r^3e\u000bZ,g\u000e\u001e\u0015\u0003!a\fQbY1mGVd\u0017\r^3SSN\\Gc\u00016\u0002\u0010\"9\u0011\u0011S\tA\u0002\u0005M\u0015a\u0002:fY\u0016\f7/\u001a\t\u0005\u0003+\u000b9*D\u0001t\u0013\r\tIj\u001d\u0002\b%\u0016dW-Y:f\u0003]A\u0017M\u001c3mKJK7o\u001b)s_\u001aLG.Z+qI\u0006$X\rF\u0002k\u0003?Cq!!)\u0013\u0001\u0004\t\u0019+A\u0003fm\u0016tG\u000f\u0005\u0003\u0002&\u0006-VBAAT\u0015\r\u0011\u0018\u0011\u0016\u0006\u0003i^IA!!,\u0002(\n\u0011\"+[:l!J|g-\u001b7f+B$\u0017\r^3eQ\r\u0011\u0012\u0011\u0017\t\u0004s\u0006M\u0016bAA[u\n)2+\u001f8dQJ|g.\u001b>fIN+(m]2sS\n,\u0017!\b:v]\u000e\u000bGnY;mCRLwN\\:G_J\u0014\u0016n]6Qe>4\u0017\u000e\\3\u0015\u0007)\fY\fC\u0004\u0002>N\u0001\r!a0\u0002\u0017IL7o\u001b)s_\u001aLG.\u001a\t\u0005\u0003\u0003\f\u0019-\u0004\u0002\u0002*&!\u0011QYAU\u0005-\u0011\u0016n]6Qe>4\u0017\u000e\\3)\u0007\u0001\tI\rE\u0002z\u0003\u0017L1!!4{\u00055)e/\u001a8u\u0019&\u001cH/\u001a8fe\"\u001a\u0001!!5\u0011\t\u0005M\u0017\u0011\\\u0007\u0003\u0003+T1!a6c\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u00037\f)NA\u0004TKJ4\u0018nY3")
public class RiskEventHandler
implements Logging {
    private final XlrConfig xlrConfig;
    private final ConfigurationRepository configurationRepository;
    private final RiskService riskService;
    private final Executor riskCalculationBatchExecutor;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskEventHandler riskEventHandler = this;
        synchronized (riskEventHandler) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void releaseCreated(ReleaseCreatedEvent releaseCreatedEvent) {
        this.calculateRisk(releaseCreatedEvent.release());
    }

    @Subscribe
    public void releaseUpdated(ReleaseUpdatedEvent releaseUpdatedEvent) {
        this.calculateRisk(releaseUpdatedEvent.updated());
    }

    @Subscribe
    public void releaseOverdue(ReleaseOverdueEvent releaseOverdueEvent) {
        this.calculateRisk(releaseOverdueEvent.release());
    }

    @Subscribe
    public void taskFailed(TaskFailedEvent taskFailedEvent) {
        this.calculateRisk(taskFailedEvent.task().getRelease());
    }

    @Subscribe
    public void taskCompleted(TaskCompletedEvent taskCompletedEvent) {
        this.calculateRisk(taskCompletedEvent.task().getRelease());
    }

    @Subscribe
    public void taskSkipped(TaskSkippedEvent taskSkippedEvent) {
        this.calculateRisk(taskSkippedEvent.task().getRelease());
    }

    @Subscribe
    public void taskAborted(TaskAbortedEvent taskAbortedEvent) {
        this.calculateRisk(taskAbortedEvent.task().getRelease());
    }

    @Subscribe
    public void taskUpdated(TaskUpdatedEvent taskUpdatedEvent) {
        this.calculateRisk(taskUpdatedEvent.updated().getRelease());
    }

    @Subscribe
    public void taskOverdue(TaskOverdueEvent taskOverdueEvent) {
        this.calculateRisk(taskOverdueEvent.task().getRelease());
    }

    @Subscribe
    public void taskDeleted(TaskDeletedEvent taskDeletedEvent) {
        this.calculateRisk(taskDeletedEvent.task().getRelease());
    }

    private void calculateRisk(Release release) {
        block0: {
            if (!this.xlrConfig.isRiskCalculationEnabled()) break block0;
            this.riskService.calculateRiskAndUpdateRelease(release);
        }
    }

    @SynchronizedSubscribe
    public void handleRiskProfileUpdate(RiskProfileUpdated event) {
        block0: {
            if (!this.xlrConfig.isRiskCalculationEnabled()) break block0;
            RiskProfile riskProfile = event.riskProfile();
            this.riskCalculationBatchExecutor.execute(() -> this.runCalculationsForRiskProfile(riskProfile));
        }
    }

    private void runCalculationsForRiskProfile(RiskProfile riskProfile) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Running risk calculations after Risk profile ").append(riskProfile.getId()).append(" update").toString());
        this.configurationRepository.getReferences(riskProfile.getId()).forEach(data -> $this.riskService.calculateRiskAndUpdateRelease(data.id()));
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Finished running risk calculations after Risk profile ").append(riskProfile.getId()).append(" update").toString());
    }

    @Autowired
    public RiskEventHandler(XlrConfig xlrConfig, ConfigurationRepository configurationRepository, ReleaseRepository releaseRepository, RiskService riskService, Executor riskCalculationBatchExecutor) {
        this.xlrConfig = xlrConfig;
        this.configurationRepository = configurationRepository;
        this.riskService = riskService;
        this.riskCalculationBatchExecutor = riskCalculationBatchExecutor;
        Logging.$init$((Logging)this);
    }
}

