/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.impl;

import akka.actor.ActorRef;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.RemoteExecution;
import com.xebialabs.xlrelease.domain.RemoteScriptExecution;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.runner.impl.ContainerScriptException;
import com.xebialabs.xlrelease.runner.impl.ExecuteRemotely;
import com.xebialabs.xlrelease.runner.impl.ExecuteRemotelyActor;
import com.xebialabs.xlrelease.runner.impl.ExecuteRemotelyResponse;
import com.xebialabs.xlrelease.runner.impl.JobRunnerService;
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService;
import com.xebialabs.xlrelease.support.akka.spring.SpringExtension;
import java.io.Serializable;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001B\b\u0011\u0001mA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tc\u0001\u0011\t\u0011)A\u0005e!A\u0001\b\u0001B\u0001B\u0003%\u0011\bC\u0003=\u0001\u0011\u0005Q\b\u0003\u0005C\u0001!\u0015\r\u0011\"\u0003D\u0011\u001dY\u0005A1A\u0005\n1Ca!\u0016\u0001!\u0002\u0013i\u0005b\u0002,\u0001\u0005\u0004%I\u0001\u0014\u0005\u0007/\u0002\u0001\u000b\u0011B'\t\u000ba\u0003A\u0011B-\t\u000b\u0011\u0004A\u0011B3\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003bBA,\u0001\u0011\u0005\u0013\u0011\f\u0002\u0018%Vtg.\u001a:TGJL\u0007\u000f^*feZL7-Z%na2T!!\u0005\n\u0002\t%l\u0007\u000f\u001c\u0006\u0003'Q\taA];o]\u0016\u0014(BA\u000b\u0017\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u00181\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00023\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\b\u0012\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\r\u0005s\u0017PU3g!\t\u0019C%D\u0001\u0011\u0013\t)\u0003CA\nSk:tWM]*de&\u0004HoU3sm&\u001cW-A\btaJLgnZ#yi\u0016t7/[8o!\tAs&D\u0001*\u0015\tQ3&\u0001\u0004taJLgn\u001a\u0006\u0003Y5\nA!Y6lC*\u0011a\u0006F\u0001\bgV\u0004\bo\u001c:u\u0013\t\u0001\u0014FA\bTaJLgnZ#yi\u0016t7/[8o\u0003%AHN]\"p]\u001aLw\r\u0005\u00024m5\tAG\u0003\u00026)\u000511m\u001c8gS\u001eL!a\u000e\u001b\u0003\u0013ac'oQ8oM&<\u0017\u0001\u00056pEJ+hN\\3s'\u0016\u0014h/[2f!\t\u0019#(\u0003\u0002<!\t\u0001\"j\u001c2Sk:tWM]*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\tyz\u0004)\u0011\t\u0003G\u0001AQA\n\u0003A\u0002\u001dBQ!\r\u0003A\u0002IBQ\u0001\u000f\u0003A\u0002e\n\u0001\"Y2u_J\u0014VMZ\u000b\u0002\tB\u0011Q)S\u0007\u0002\r*\u0011q\tS\u0001\u0006C\u000e$xN\u001d\u0006\u0002Y%\u0011!J\u0012\u0002\t\u0003\u000e$xN\u001d*fM\u0006\u00112i\\7nC:$'+Z:q_:\u001cXmS3z+\u0005i\u0005C\u0001(T\u001b\u0005y%B\u0001)R\u0003\u0011a\u0017M\\4\u000b\u0003I\u000bAA[1wC&\u0011Ak\u0014\u0002\u0007'R\u0014\u0018N\\4\u0002'\r{W.\\1oIJ+7\u000f]8og\u0016\\U-\u001f\u0011\u0002\u001f\u0015\u0013(o\u001c:NKN\u001c\u0018mZ3LKf\f\u0001#\u0012:s_JlUm]:bO\u0016\\U-\u001f\u0011\u0002\u0019=\u0014'.Z2u\u001b\u0006\u0004\b/\u001a:\u0016\u0003i\u0003\"a\u00172\u000e\u0003qS!!\u00180\u0002\u0011\u0011\fG/\u00192j]\u0012T!a\u00181\u0002\u000f)\f7m[:p]*\u0011\u0011\rG\u0001\nM\u0006\u001cH/\u001a:y[2L!a\u0019/\u0003\u0019=\u0013'.Z2u\u001b\u0006\u0004\b/\u001a:\u0002\u0017\u0005\u001c8.\u00118e\u0003^\f\u0017\u000e^\u000b\u0003M&$2a\u001a:|!\tA\u0017\u000e\u0004\u0001\u0005\u000b)\\!\u0019A6\u0003\u0003Q\u000b\"\u0001\\8\u0011\u0005ui\u0017B\u00018\u001f\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\b9\n\u0005Et\"aA!os\")1o\u0003a\u0001i\u0006I!n\u001c2Sk:tWM\u001d\t\u0003kfl\u0011A\u001e\u0006\u0003']T!\u0001\u001f\u000b\u0002\r\u0011|W.Y5o\u0013\tQhOA\u0005K_\n\u0014VO\u001c8fe\")Ap\u0003a\u0001{\u0006y!/Z7pi\u0016,\u00050Z2vi&|g\u000e\u0005\u0002\u007f\u007f6\tq/C\u0002\u0002\u0002]\u0014qBU3n_R,W\t_3dkRLwN\\\u0001\u000eKb,7-\u001e;f'\u000e\u0014\u0018\u000e\u001d;\u0016\t\u0005\u001d\u00111\u0002\u000b\t\u0003\u0013\ti!!\n\u00026A\u0019\u0001.a\u0003\u0005\u000b)d!\u0019A6\t\u000f\u0005=A\u00021\u0001\u0002\u0012\u000511o\u0019:jaR\u0004B!a\u0005\u0002\"9!\u0011QCA\u000f!\r\t9BH\u0007\u0003\u00033Q1!a\u0007\u001b\u0003\u0019a$o\\8u}%\u0019\u0011q\u0004\u0010\u0002\rA\u0013X\rZ3g\u0013\r!\u00161\u0005\u0006\u0004\u0003?q\u0002bBA\u0014\u0019\u0001\u0007\u0011\u0011F\u0001\u0010S:\u0004X\u000f\u001e)be\u0006lW\r^3sgB9\u00111FA\u0019\u0003#aRBAA\u0017\u0015\r\ty#U\u0001\u0005kRLG.\u0003\u0003\u00024\u00055\"aA'ba\"9\u0011q\u0007\u0007A\u0002\u0005e\u0012!\u0004;za\u0016\u0014VMZ3sK:\u001cW\r\u0005\u0004\u0002<\u0005\u0015\u0013\u0011B\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005!A/\u001f9f\u0015\r\t\u0019EX\u0001\u0005G>\u0014X-\u0003\u0003\u0002H\u0005u\"!\u0004+za\u0016\u0014VMZ3sK:\u001cW-A\bfq\u0016\u001cW\u000f^3SK6|G/\u001a7z)\u0019\ti%a\u0015\u0002VA\u00191%a\u0014\n\u0007\u0005E\u0003CA\fFq\u0016\u001cW\u000f^3SK6|G/\u001a7z%\u0016\u001c\bo\u001c8tK\"9\u0011qB\u0007A\u0002\u0005E\u0001bBA\u0014\u001b\u0001\u0007\u0011\u0011F\u0001\u000fg\u000e\u0014\u0018\u000e\u001d;Fq\u0016\u001cW\u000f^3e)\u0019\tY&!\u0019\u0002fA\u0019Q$!\u0018\n\u0007\u0005}cD\u0001\u0003V]&$\bbBA2\u001d\u0001\u0007\u0011\u0011C\u0001\u0012g\u000e\u0014\u0018\u000e\u001d;Fq\u0016\u001cW\u000f^5p]&#\u0007bBA4\u001d\u0001\u0007\u0011\u0011F\u0001\ba\u0006LHn\\1eQ\r\u0001\u00111\u000e\t\u0005\u0003[\nY(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0005\u0003k\n9(A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\tI(A\u0002pe\u001eLA!! \u0002p\t91+\u001a:wS\u000e,\u0007")
public class RunnerScriptServiceImpl
implements RunnerScriptService {
    private ActorRef actorRef;
    private final SpringExtension springExtension;
    private final XlrConfig xlrConfig;
    private final JobRunnerService jobRunnerService;
    private final String CommandResponseKey;
    private final String ErrorMessageKey;
    private volatile boolean bitmap$0;

    private ActorRef actorRef$lzycompute() {
        RunnerScriptServiceImpl runnerScriptServiceImpl = this;
        synchronized (runnerScriptServiceImpl) {
            if (!this.bitmap$0) {
                this.actorRef = this.springExtension.actorOf(ExecuteRemotelyActor.class, this.springExtension.actorOf$default$2(), this.springExtension.actorOf$default$3(), this.springExtension.actorOf$default$4());
                this.bitmap$0 = true;
            }
        }
        return this.actorRef;
    }

    private ActorRef actorRef() {
        if (!this.bitmap$0) {
            return this.actorRef$lzycompute();
        }
        return this.actorRef;
    }

    private String CommandResponseKey() {
        return this.CommandResponseKey;
    }

    private String ErrorMessageKey() {
        return this.ErrorMessageKey;
    }

    private ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        return mapper;
    }

    private <T> T askAndAwait(JobRunner jobRunner, RemoteExecution remoteExecution) {
        Object object;
        Timeout askTimeout = Timeout$.MODULE$.durationToTimeout(this.xlrConfig.timeouts().releaseActionResponse());
        try {
            ActorRef qual$1 = package$.MODULE$.ask(this.actorRef());
            ExecuteRemotely x$1 = new ExecuteRemotely(jobRunner, remoteExecution);
            Timeout x$2 = askTimeout;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            object = Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3), (Duration)askTimeout.duration());
        }
        catch (Exception e) {
            throw new ContainerScriptException(e.getMessage());
        }
        return (T)object;
    }

    @Override
    public <T> T executeScript(String script, java.util.Map<String, Object> inputParameters, TypeReference<T> typeReference) {
        Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeRemotely(script, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)this.CommandResponseKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            Object commandResponse = some.value();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.objectMapper().readValue(this.objectMapper().writeValueAsString(commandResponse), typeReference));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object result = success.value();
                return (T)result;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
            }
            throw new MatchError((Object)try_);
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)this.ErrorMessageKey())) {
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)this.ErrorMessageKey())), String.class);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    private ExecuteRemotelyResponse executeRemotely(String script, java.util.Map<String, Object> inputParameters) {
        RemoteScriptExecution scriptTask = TaskBuilder.newRemoteExecution((String)script).withInputParameters(inputParameters).build();
        Option<JobRunner> option = this.jobRunnerService.findScriptExecutor();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new ContainerScriptException("Cannot find active remote runner for executing script '" + script + "'");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        JobRunner runner = (JobRunner)some.value();
        JobRunner runner2 = runner;
        return (ExecuteRemotelyResponse)this.askAndAwait(runner2, (RemoteExecution)scriptTask);
    }

    @Override
    public void scriptExecuted(String scriptExecutionId, java.util.Map<String, Object> payload) {
        ExecuteRemotelyResponse x$1 = new ExecuteRemotelyResponse(scriptExecutionId, payload);
        ActorRef x$2 = this.actorRef().$bang$default$2((Object)x$1);
        this.actorRef().$bang((Object)x$1, x$2);
    }

    public RunnerScriptServiceImpl(SpringExtension springExtension, XlrConfig xlrConfig, JobRunnerService jobRunnerService) {
        this.springExtension = springExtension;
        this.xlrConfig = xlrConfig;
        this.jobRunnerService = jobRunnerService;
        this.CommandResponseKey = "commandResponse";
        this.ErrorMessageKey = "errorMessage";
    }
}

