import React from 'react';
import { ReactWrapper } from 'enzyme';
import { DotButton } from '@digital-ai/dot-components';
import { mountWithStoreAndTheme } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { RemoteRunnersPlaceholder, RemoteRunnersPlaceholderProps } from './remote-runners-placeholder.component';
import { initialState } from '../ducks/remote-runners.reducer';
import { RootState } from '../../../../../../../../../core/xlr-ui/app/js/store.types';

const dispatch = jest.fn();
describe('RemoteRunnersPlaceholder component', () => {
    let wrapper: ReactWrapper;

    const onViewChangeMock = jest.fn();

    const defaultProps: RemoteRunnersPlaceholderProps = {
        onViewChange: onViewChangeMock,
    };

    const defaultState: RootState = {
        remoteRunners: initialState,
    };

    const mountComponent = (props: RemoteRunnersPlaceholderProps = defaultProps, state: RootState = defaultState) => {
        wrapper = mountWithStoreAndTheme(<RemoteRunnersPlaceholder {...props} />, dispatch, state);
    };

    afterEach(() => {
        jest.resetAllMocks();
        wrapper.unmount();
    });

    const getAddRemoteRunnerButton = () => wrapper.findWhere((node) => node.is(DotButton) && node.props().className === 'remote-runners-create-btn');

    const searchDotCard = (selector: string) => wrapper.find(`.remote-runners-placeholder ${selector}`);

    it('should show the title and description', () => {
        mountComponent();
        expect(searchDotCard('.remote-runners-title').text()).toStrictEqual('Add remote runner');
        expect(searchDotCard('.remote-runners-description').text()).toContain('Remote runner overview');
    });

    it('should show the add button', () => {
        mountComponent();
        expect(searchDotCard('.remote-runners-buttons button').at(0).text()).toStrictEqual('Add remote runner');
    });

    it("should execute correct handler when 'Add remote runner' button has been clicked", () => {
        mountComponent();
        getAddRemoteRunnerButton().invoke('onClick')();
        expect(onViewChangeMock).toHaveBeenCalledTimes(1);
    });
});
