package com.xebialabs.xlrelease.runner.impl.security.authentication.policy

import com.xebialabs.xlrelease.domain.UserProfile
import com.xebialabs.xlrelease.security.authentication.RunnerAuthenticationToken
import com.xebialabs.xlrelease.security.authentication.policy.UserProfileCreationPolicy
import org.springframework.security.core.Authentication
import org.springframework.stereotype.Component

@Component
class RunnerUserProfileCreationPolicy extends UserProfileCreationPolicy {
  override def order(): Int = 20

  override def policyApplies(authentication: Authentication): Boolean = authentication.isInstanceOf[RunnerAuthenticationToken]

  override def createProfile(authentication: Authentication): UserProfile = null // for runner, we don't create profile
}
