import React from 'react';
import { ReactWrapper } from 'enzyme';
import { Provider } from 'react-redux';
import { mockResizeObserver, mountWithStoreAndTheme } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { initialState, remoteRunners } from '../ducks/remote-runners.reducer';
import { remoteRunnerMock } from '../__mocks__/remote-runners.mocks';
import { RootState } from '../../../../../../../../../core/xlr-ui/app/js/store.types';
import { RemoteRunnersContainer } from './remote-runners-container';
import { RemoteRunnersTableContainer } from './remote-runners-table-container';
import { RemoteRunnersPlaceholder } from './remote-runners-placeholder.component';

const { loadRemoteRunners } = remoteRunners.actions;

describe('RemoteRunnersContainer component', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();

    const defaultState: RootState = {
        remoteRunners: {
            ...initialState,
        },
    };

    const mountComponent = (state: RootState = defaultState) => {
        wrapper = mountWithStoreAndTheme(<RemoteRunnersContainer />, dispatch, state);
        expect(wrapper.find(Provider)).toExist();
        expect(dispatch).toHaveBeenCalledWith(loadRemoteRunners());
    };

    beforeAll(() => {
        mockResizeObserver();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should render remote runners placeholder when there is no remote runner', () => {
        mountComponent();
        expect(wrapper.find(RemoteRunnersPlaceholder)).toExist();
    });

    it('should render remote runners table container when there is some remote runner', () => {
        const state = {
            ...defaultState,
            remoteRunners: {
                ...initialState,
                remoteRunners: [remoteRunnerMock],
            },
        };
        mountComponent(state);
        expect(wrapper.find(RemoteRunnersTableContainer)).toExist();
    });
});
