package com.xebialabs.xlrelease.runner.impl.spring

import com.xebialabs.xlrelease.config.CacheManagementConstants.RUNNER_CACHE_MANAGER_NAME
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.support.cache.caffeine.spring.XlrCaffeineCacheManager
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class RunnerCacheConfiguration(xlrConfig: XlrConfig) {

  @Bean(name = Array(RUNNER_CACHE_MANAGER_NAME))
  def runnerCacheManager() = new XlrCaffeineCacheManager(RUNNER_CACHE_MANAGER_NAME, xlrConfig.getCacheSettings())
}

object RunnerCacheConfiguration {
  final val RUNNER_TOKEN_CACHE_NAME = "runner-token"
}
