package com.xebialabs.xlrelease.runner.impl

import com.xebialabs.xlrelease.runner.domain._
import com.xebialabs.xlrelease.runner.impl.RunnerProxyActor._
import com.xebialabs.xlrelease.runner.impl.RunnerProxyActorSupervisor.RunnerProxyActorTerminated
import com.xebialabs.xlrelease.support.pekko.spring.{ActorFactory, SpringActor}
import org.apache.pekko.actor._

@SpringActor
class RunnerProxyActorSupervisor(actorFactory: ActorFactory, runnerControlService: RunnerControlService) extends Actor with ActorLogging {
  override def receive: Receive = {
    case cmd: RunnerProxyCommand =>
      log.debug(s"Received $cmd")
      createOrFind(cmd.runnerId) forward cmd
    case health: RunnerHealth =>
      log.debug(s"Received health $health")
      createOrFind(health.runnerId) forward health
    case RunnerProxyActorTerminated(runnerId) =>
      log.warning(s"RunnerProxyActor for runner [$runnerId] was terminated. Trying to close the control channel.")
      runnerControlService.closeControlChannel(runnerId)
    case msg =>
      log.error(s"Can't process $msg")
  }

  private def createOrFind(runnerId: RunnerId): ActorRef = {
    val childName = actorName(runnerId)
    val actorRef = context.child(childName).getOrElse {
      log.debug(s"Creating runner proxy for $runnerId")
      actorFactory.childActorOf(classOf[RunnerProxyActor], childName)
    }
    context.watchWith(actorRef, RunnerProxyActorTerminated(runnerId))
    actorRef
  }

  override val supervisorStrategy: OneForOneStrategy = OneForOneStrategy()(SupervisorStrategy.defaultDecider)
}

object RunnerProxyActorSupervisor {
  case class RunnerProxyActorTerminated(runnerId: RunnerId)
}
