import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import { RemoteRunner } from '../remote-runners.types';
import noop from 'lodash/noop';
import { ConfigurationCallbackPayload } from '@xlr-ui/app/features/configuration/types';

export interface RemoteRunnersState {
    isLoading: boolean;
    remoteRunners: RemoteRunner[];
}

export const initialState: RemoteRunnersState = {
    isLoading: false,
    remoteRunners: [],
};

export interface UpdateRemoteRunnerStatePayload {
    enable: boolean;
    id: string;
}

export const remoteRunners = createSlice({
    name: 'remoteRunners',
    initialState,
    reducers: {
        setIsLoading: (state: RemoteRunnersState, action: PayloadAction<boolean>) => {
            state.isLoading = action.payload;
        },
        loadRemoteRunners: (_state: RemoteRunnersState) => noop(),
        setRemoteRunners: (state: RemoteRunnersState, action: PayloadAction<Array<RemoteRunner>>) => {
            state.remoteRunners = action.payload;
        },
        reloadRemoteRunners: (_state: RemoteRunnersState, _action: PayloadAction<ConfigurationCallbackPayload>) => noop(),
        updateRemoteRunnerState: (_state: RemoteRunnersState, _action: PayloadAction<UpdateRemoteRunnerStatePayload>) => noop(),
        deleteRemoteRunner: (_state: RemoteRunnersState, _action: PayloadAction<RemoteRunner>) => noop(),
    },
});
