package com.xebialabs.xlrelease.udm.reporting.api.internal

import com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN
import com.xebialabs.xlrelease.repository.Ids.getName
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.service.CiIdService
import com.xebialabs.xlrelease.udm.reporting.Deployment
import com.xebialabs.xlrelease.udm.reporting.repository.DeploymentRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

import javax.ws.rs._
import javax.ws.rs.core.MediaType

@Path("fixtures/deployment")
@Controller
@Produces(Array(MediaType.APPLICATION_JSON))
@Consumes(Array(MediaType.APPLICATION_JSON))
class DeploymentsFixture @Autowired()(val deploymentRepository: DeploymentRepository,
                                      val permissions: PermissionChecker, val ciIdService: CiIdService) {

  @POST
  def createDeployment(deployment: Deployment): String = {
    permissions.check(ADMIN)
    deployment.setDeploymentId(getName(ciIdService.getUniqueId("Deployment", "")))
    deploymentRepository.create(deployment)
    deployment.getDeploymentId
  }

  @DELETE
  @Path("{deploymentId:.*}")
  def deleteDeployment(@PathParam("deploymentId") deploymentId: String): Unit = {
    permissions.check(ADMIN)
    deploymentRepository.delete(deploymentId)
  }
}
