/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.udm.reporting.api.internal;

import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.udm.reporting.Deployment;
import com.xebialabs.xlrelease.udm.reporting.repository.DeploymentRepository;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.reflect.ScalaSignature;

@Path(value="fixtures/deployment")
@Controller
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001\u0002\u0006\f\u0001iA\u0001\"\t\u0001\u0003\u0006\u0004%\tA\t\u0005\tS\u0001\u0011\t\u0011)A\u0005G!A!\u0006\u0001BC\u0002\u0013\u00051\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u0003-\u0011!\u0019\u0004A!b\u0001\n\u0003!\u0004\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\t\u000bq\u0002A\u0011A\u001f\t\u000bI\u0003A\u0011A*\t\u000bA\u0004A\u0011A9\u0003%\u0011+\u0007\u000f\\8z[\u0016tGo\u001d$jqR,(/\u001a\u0006\u0003\u00195\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001d=\t1!\u00199j\u0015\t\u0001\u0012#A\u0005sKB|'\u000f^5oO*\u0011!cE\u0001\u0004k\u0012l'B\u0001\u000b\u0016\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0017/\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00021\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002)\u0011,\u0007\u000f\\8z[\u0016tGOU3q_NLGo\u001c:z+\u0005\u0019\u0003C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0010\u0003)\u0011X\r]8tSR|'/_\u0005\u0003Q\u0015\u0012A\u0003R3qY>LX.\u001a8u%\u0016\u0004xn]5u_JL\u0018!\u00063fa2|\u00170\\3oiJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\fa\u0016\u0014X.[:tS>t7/F\u0001-!\ti\u0003'D\u0001/\u0015\ty3#\u0001\u0005tK\u000e,(/\u001b;z\u0013\t\tdFA\tQKJl\u0017n]:j_:\u001c\u0005.Z2lKJ\fA\u0002]3s[&\u001c8/[8og\u0002\n1bY5JIN+'O^5dKV\tQ\u0007\u0005\u00027s5\tqG\u0003\u00029'\u000591/\u001a:wS\u000e,\u0017B\u0001\u001e8\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002\u0019\rL\u0017\nZ*feZL7-\u001a\u0011\u0002\rqJg.\u001b;?)\u0011q\u0004)\u0011\"\u0011\u0005}\u0002Q\"A\u0006\t\u000b\u0005:\u0001\u0019A\u0012\t\u000b):\u0001\u0019\u0001\u0017\t\u000bM:\u0001\u0019A\u001b)\u0005\u001d!\u0005CA#Q\u001b\u00051%BA$I\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0013*\u000bqAZ1di>\u0014\u0018P\u0003\u0002L\u0019\u0006)!-Z1og*\u0011QJT\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tq*A\u0002pe\u001eL!!\u0015$\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001E2sK\u0006$X\rR3qY>LX.\u001a8u)\t!v\f\u0005\u0002V9:\u0011aK\u0017\t\u0003/vi\u0011\u0001\u0017\u0006\u00033f\ta\u0001\u0010:p_Rt\u0014BA.\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011QL\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mk\u0002\"\u00021\t\u0001\u0004\t\u0017A\u00033fa2|\u00170\\3oiB\u0011!mY\u0007\u0002\u001f%\u0011Am\u0004\u0002\u000b\t\u0016\u0004Hn\\=nK:$\bF\u0001\u0005g!\t9g.D\u0001i\u0015\tI'.\u0001\u0002sg*\u00111\u000e\\\u0001\u0003oNT\u0011!\\\u0001\u0006U\u00064\u0018\r_\u0005\u0003_\"\u0014A\u0001U(T)\u0006\u0001B-\u001a7fi\u0016$U\r\u001d7ps6,g\u000e\u001e\u000b\u0003eV\u0004\"\u0001H:\n\u0005Ql\"\u0001B+oSRDQA^\u0005A\u0002Q\u000bA\u0002Z3qY>LX.\u001a8u\u0013\u0012DC!\u001e=|yB\u0011q-_\u0005\u0003u\"\u0014\u0011\u0002U1uQB\u000b'/Y7\u0002\u000bY\fG.^3\"\u0003YDS!\u0003@|\u0003\u0007\u0001\"aZ@\n\u0007\u0005\u0005\u0001N\u0001\u0003QCRD\u0017EAA\u0003\u0003EYH-\u001a9m_flWM\u001c;JIjr#& \u0015\u0004\u0013\u0005%\u0001cA4\u0002\f%\u0019\u0011Q\u00025\u0003\r\u0011+E*\u0012+FQ\u0019\u0001\u0011\u0011C>\u0002\u0018A\u0019q-a\u0005\n\u0007\u0005U\u0001N\u0001\u0005D_:\u001cX/\\3tY\t\tI\"\t\u0002\u0002\u001c\u0005\u0001\u0012\r\u001d9mS\u000e\fG/[8o_)\u001cxN\u001c\u0015\u0007\u0001\u0005}10!\n\u0011\u0007\u001d\f\t#C\u0002\u0002$!\u0014\u0001\u0002\u0015:pIV\u001cWm\u001d\u0017\u0003\u00033A3\u0001AA\u0015!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018\u0019\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005M\u0012Q\u0006\u0002\u000b\u0007>tGO]8mY\u0016\u0014\b&\u0002\u0001\u007fw\u0006]\u0012EAA\u001d\u0003M1\u0017\u000e\u001f;ve\u0016\u001cx\u0006Z3qY>LX.\u001a8u\u0001")
public class DeploymentsFixture {
    private final DeploymentRepository deploymentRepository;
    private final PermissionChecker permissions;
    private final CiIdService ciIdService;

    public DeploymentRepository deploymentRepository() {
        return this.deploymentRepository;
    }

    public PermissionChecker permissions() {
        return this.permissions;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @POST
    public String createDeployment(Deployment deployment) {
        this.permissions().check(PlatformPermissions.ADMIN);
        deployment.setDeploymentId(Ids.getName((String)this.ciIdService().getUniqueId("Deployment", "")));
        this.deploymentRepository().create(deployment);
        return deployment.getDeploymentId();
    }

    @DELETE
    @Path(value="{deploymentId:.*}")
    public void deleteDeployment(@PathParam(value="deploymentId") String deploymentId) {
        this.permissions().check(PlatformPermissions.ADMIN);
        this.deploymentRepository().delete(deploymentId);
    }

    @Autowired
    public DeploymentsFixture(DeploymentRepository deploymentRepository, PermissionChecker permissions, CiIdService ciIdService) {
        this.deploymentRepository = deploymentRepository;
        this.permissions = permissions;
        this.ciIdService = ciIdService;
    }
}

