/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.udm.reporting.repository.sql;

import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.udm.reporting.Deployment;
import com.xebialabs.xlrelease.udm.reporting.DeploymentAction;
import com.xebialabs.xlrelease.udm.reporting.DeploymentHistory;
import com.xebialabs.xlrelease.udm.reporting.DeploymentStatus;
import com.xebialabs.xlrelease.udm.reporting.repository.DeploymentRepository;
import com.xebialabs.xlrelease.udm.reporting.repository.sql.DeploymentsSqlBuilder;
import com.xebialabs.xlrelease.udm.reporting.repository.sql.persistence.DeploymentHistoryPersistence;
import com.xebialabs.xlrelease.udm.reporting.repository.sql.persistence.DeploymentPersistence;
import java.util.Date;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Repository
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001\u0002\b\u0010\u0001yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!AA\u0007\u0001BC\u0002\u0013\rQ\u0007\u0003\u0005N\u0001\t\u0005\t\u0015!\u00037\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u00159\u0007\u0001\"\u0011i\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u0015A\b\u0001\"\u0011z\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u0002\"\u0001!\t%a\t\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>!9\u0011\u0011\n\u0001\u0005B\u0005-#aF*rY\u0012+\u0007\u000f\\8z[\u0016tGOU3q_NLGo\u001c:z\u0015\t\u0001\u0012#A\u0002tc2T!AE\n\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0015+\u0005I!/\u001a9peRLgn\u001a\u0006\u0003-]\t1!\u001e3n\u0015\tA\u0012$A\u0005yYJ,G.Z1tK*\u0011!dG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001H\u0001\u0004G>l7\u0001A\n\u0004\u0001})\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002'O5\t\u0011#\u0003\u0002)#\t!B)\u001a9m_flWM\u001c;SKB|7/\u001b;pef\fQ\u0003Z3qY>LX.\u001a8u!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002,]5\tAF\u0003\u0002.\u001f\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\tyCFA\u000bEKBdw._7f]R\u0004VM]:jgR,gnY3\u00029\u0011,\u0007\u000f\\8z[\u0016tG\u000fS5ti>\u0014\u0018\u0010U3sg&\u001cH/\u001a8dKB\u00111FM\u0005\u0003g1\u0012A\u0004R3qY>LX.\u001a8u\u0011&\u001cHo\u001c:z!\u0016\u00148/[:uK:\u001cW-A\u0004eS\u0006dWm\u0019;\u0016\u0003Y\u0002\"a\u000e&\u000f\u0005a:eBA\u001dF\u001d\tQ4I\u0004\u0002<\u0005:\u0011A(\u0011\b\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fu\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000f\n\u0005iY\u0012B\u0001\r\u001a\u0013\t!u#\u0001\u0002eE&\u0011\u0001C\u0012\u0006\u0003\t^I!\u0001S%\u0002\u0015M\u000bHNQ;jY\u0012,'O\u0003\u0002\u0011\r&\u00111\n\u0014\u0002\b\t&\fG.Z2u\u0015\tA\u0015*\u0001\u0005eS\u0006dWm\u0019;!\u0003\u0019a\u0014N\\5u}Q!\u0001KU*U!\t\t\u0006!D\u0001\u0010\u0011\u0015IS\u00011\u0001+\u0011\u0015\u0001T\u00011\u00012\u0011\u0015!T\u0001q\u00017Q\u0011!f\u000bZ3\u0011\u0005]\u0013W\"\u0001-\u000b\u0005eS\u0016AC1o]>$\u0018\r^5p]*\u00111\fX\u0001\bM\u0006\u001cGo\u001c:z\u0015\tif,A\u0003cK\u0006t7O\u0003\u0002`A\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001b\u0003\ry'oZ\u0005\u0003Gb\u0013\u0011\"U;bY&4\u0017.\u001a:\u0002\u000bY\fG.^3\"\u0003\u0019\f1C]3q_J$\u0018N\\4Tc2$\u0015.\u00197fGR\faa\u0019:fCR,GCA5m!\t\u0001#.\u0003\u0002lC\t!QK\\5u\u0011\u0015ig\u00011\u0001o\u0003)!W\r\u001d7ps6,g\u000e\u001e\t\u0003_Bl\u0011aE\u0005\u0003cN\u0011!\u0002R3qY>LX.\u001a8u\u0003\u0019)\b\u000fZ1uKR\u0019\u0011\u000e\u001e<\t\u000bU<\u0001\u0019\u00018\u0002\u0011=\u0014\u0018nZ5oC2DQa^\u0004A\u00029\fq!\u001e9eCR,G-\u0001\u0004eK2,G/\u001a\u000b\u0003SjDQa\u001f\u0005A\u0002q\fA\u0002Z3qY>LX.\u001a8u\u0013\u0012\u00042!`A\u0002\u001d\tqx\u0010\u0005\u0002>C%\u0019\u0011\u0011A\u0011\u0002\rA\u0013X\rZ3g\u0013\u0011\t)!a\u0002\u0003\rM#(/\u001b8h\u0015\r\t\t!I\u0001\u0007KbL7\u000f^:\u0015\t\u00055\u00111\u0003\t\u0004A\u0005=\u0011bAA\tC\t9!i\\8mK\u0006t\u0007\"B>\n\u0001\u0004a\u0018\u0001\u00034j]\u0012\u0014\u00150\u00133\u0015\t\u0005e\u0011q\u0004\t\u0005A\u0005ma.C\u0002\u0002\u001e\u0005\u0012aa\u00149uS>t\u0007\"B>\u000b\u0001\u0004a\u0018\u0001\u00044j]\u0012\u0014\u0015\u0010V1tW&#G\u0003BA\u0013\u0003o\u0001R!a\n\u000229tA!!\u000b\u0002.9\u0019Q(a\u000b\n\u0003\tJ1!a\f\"\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\r\u00026\t\u00191+Z9\u000b\u0007\u0005=\u0012\u0005\u0003\u0004\u0002:-\u0001\r\u0001`\u0001\u0007i\u0006\u001c8.\u00133\u0002\u001f\u0019Lg\u000e\u001a%jgR|'/\u001f\"z\u0013\u0012$B!a\u0010\u0002HA1\u0011qEA\u0019\u0003\u0003\u00022a\\A\"\u0013\r\t)e\u0005\u0002\u0012\t\u0016\u0004Hn\\=nK:$\b*[:u_JL\b\"B>\r\u0001\u0004a\u0018A\b3fY\u0016$X-Q;u_\u001e+g.\u001a:bi\u0016$G)\u001a9m_flWM\u001c;t)\rI\u0017Q\n\u0005\u0007\u0003si\u0001\u0019\u0001?)%\u0001\t\t\u0006ZA0\u0003G\n)'a\u001c\u0002r\u0005m\u0014Q\u0010\t\u0005\u0003'\nY&\u0004\u0002\u0002V)\u0019\u0011,a\u0016\u000b\u0007\u0005ec,A\u0006ue\u0006t7/Y2uS>t\u0017\u0002BA/\u0003+\u0012Q\u0002\u0016:b]N\f7\r^5p]\u0006d\u0017EAA1\u0003m\u0011X\r]8si&tw\r\u0016:b]N\f7\r^5p]6\u000bg.Y4fe\u0006Y\u0001O]8qC\u001e\fG/[8oI\t\t9'\u0003\u0003\u0002j\u0005-\u0014\u0001\u0003*F#VK%+\u0012#\u000b\t\u00055\u0014QK\u0001\f!J|\u0007/Y4bi&|g.A\u0005jg>d\u0017\r^5p]\u0012\u0012\u00111O\u0005\u0005\u0003k\n9(\u0001\bS\u000b\u0006#ulQ(N\u001b&#F+\u0012#\u000b\t\u0005e\u0014QK\u0001\n\u0013N|G.\u0019;j_:\f1B]8mY\n\f7m\u001b$pe2\u0012\u0011qP\u0012\u0003\u0003\u0003\u0003B!a\n\u0002\u0004&!\u0011QQA\u001b\u0005%!\u0006N]8xC\ndW\rK\u0002\u0001\u0003\u0013\u0003B!a#\u0002\u00126\u0011\u0011Q\u0012\u0006\u0004\u0003\u001fs\u0016AC:uKJ,w\u000e^=qK&!\u00111SAG\u0005)\u0011V\r]8tSR|'/\u001f")
public class SqlDeploymentRepository
implements DeploymentRepository {
    private final DeploymentPersistence deploymentPersistence;
    private final DeploymentHistoryPersistence deploymentHistoryPersistence;
    private final SqlBuilder.Dialect dialect;

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Override
    public void create(Deployment deployment) {
        this.deploymentPersistence.insert(deployment);
        DeploymentHistory history = new DeploymentHistory();
        history.setDeploymentId(deployment.getDeploymentId());
        history.setOldStatus(deployment.getStatus());
        history.setNewStatus(deployment.getStatus());
        history.setChangeDate(new Date());
        history.setAction(DeploymentAction.fromStatus(null, deployment.getStatus()));
        history.setTaskOwner(deployment.getTaskOwner());
        history.setTaskTeam(deployment.getTaskTeam());
        this.deploymentHistoryPersistence.insert(history);
    }

    @Override
    public void update(Deployment original, Deployment updated) {
        block0: {
            this.deploymentPersistence.update(updated);
            DeploymentStatus deploymentStatus = original.getStatus();
            DeploymentStatus deploymentStatus2 = updated.getStatus();
            if (!(deploymentStatus == null ? deploymentStatus2 != null : !((Object)((Object)deploymentStatus)).equals((Object)deploymentStatus2))) break block0;
            DeploymentHistory history = new DeploymentHistory();
            history.setDeploymentId(updated.getDeploymentId());
            history.setOldStatus(original.getStatus());
            history.setNewStatus(updated.getStatus());
            history.setChangeDate(new Date());
            history.setAction(DeploymentAction.fromStatus(original.getStatus(), updated.getStatus()));
            history.setTaskOwner(updated.getTaskOwner());
            history.setTaskTeam(updated.getTaskTeam());
            this.deploymentHistoryPersistence.insert(history);
        }
    }

    @Override
    public void delete(String deploymentId) {
        this.deploymentPersistence.delete(deploymentId);
    }

    @Override
    public boolean exists(String deploymentId) {
        return this.deploymentPersistence.exists(deploymentId);
    }

    @Override
    public Option<Deployment> findById(String deploymentId) {
        return this.deploymentPersistence.findById(deploymentId);
    }

    @Override
    public Seq<Deployment> findByTaskId(String taskId) {
        Tuple2 query = new DeploymentsSqlBuilder(this.dialect()).withTaskId(taskId).build();
        return this.deploymentPersistence.findByQuery((Tuple2<String, Seq<Object>>)query);
    }

    @Override
    public Seq<DeploymentHistory> findHistoryById(String deploymentId) {
        return this.deploymentHistoryPersistence.findById(deploymentId);
    }

    @Override
    public void deleteAutoGeneratedDeployments(String taskId) {
        this.deploymentPersistence.deleteAllAutoGenerated(taskId);
    }

    public SqlDeploymentRepository(DeploymentPersistence deploymentPersistence, DeploymentHistoryPersistence deploymentHistoryPersistence, @Qualifier(value="reportingSqlDialect") SqlBuilder.Dialect dialect) {
        this.deploymentPersistence = deploymentPersistence;
        this.deploymentHistoryPersistence = deploymentHistoryPersistence;
        this.dialect = dialect;
    }
}

