package com.xebialabs.xlrelease.webhooks.service.script

import com.xebialabs.xlrelease.script.XlrScriptContext
import com.xebialabs.xlrelease.webhooks.consumers.StatusWebhookEventSource

private class CleanupScriptContextBuilder(connection: StatusWebhookEventSource) extends BaseScriptContextBuilder(connection) {

  override val scriptProperty: String = CleanupScriptProperty

  override protected def doBuild(context: XlrScriptContext): Unit = {
    addConnectionServerAttributes(context)
    addConnectionAttributes(context)
    addScript(context)
  }
}

object CleanupScriptContextBuilder {
  def createCleanupScriptContext(connection: StatusWebhookEventSource): XlrScriptContext = {
    new CleanupScriptContextBuilder(connection).build()
  }
}
