package com.xebialabs.xlrelease.webhooks.service.script

import com.xebialabs.xlrelease.script.XlrScriptContext
import com.xebialabs.xlrelease.webhooks.consumers.StatusWebhookEventSource

private class StatusScriptContextBuilder(connection: StatusWebhookEventSource) extends BaseScriptContextBuilder(connection) {

  override val scriptProperty: String = StatusScriptProperty

  override protected def doBuild(context: XlrScriptContext): Unit = {
    addConnectionAttributes(context)
    addConnectionServerAttributes(context)
    addScript(context)
  }
}

object StatusScriptContextBuilder {
  def createStatusScriptContext(connection: StatusWebhookEventSource): XlrScriptContext = {
    new StatusScriptContextBuilder(connection).build()
  }
}
