package com.xebialabs.xlplatform.webhooks.domain

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlplatform.webhooks.authentication.RequestAuthenticationMethod

import scala.beans.BeanProperty

@Metadata(virtual = true)
trait RequestAuthentication {
  self: BaseConfigurationItem =>
  type EndpointType <: BaseConfigurationItem with Endpoint

  @BeanProperty
  @Property(label = "Endpoint for this RequestAuthenticationConfig", asContainment = true)
  var endpoint: EndpointType = _

  def requestAuthentication: RequestAuthenticationMethod

}
