/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.processor.impl.css.AbstractCssUrlRewritingProcessor;
import ro.isdc.wro.model.resource.processor.support.ImageUrlRewriter;
import ro.isdc.wro.model.resource.support.MutableResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.ResourceAuthorizationManager;

public class CssUrlRewritingProcessor
extends AbstractCssUrlRewritingProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssUrlRewritingProcessor.class);
    public static final String ALIAS = "cssUrlRewriting";
    @Inject
    private ResourceAuthorizationManager authorizationManager;
    @Inject
    private ReadOnlyContext context;

    protected void onUrlReplaced(String replacedUrl) {
        String allowedUrl = StringUtils.removeStart((String)replacedUrl, (String)this.getUrlPrefix());
        LOG.debug("adding allowed url: {}", (Object)allowedUrl);
        if (this.authorizationManager instanceof MutableResourceAuthorizationManager) {
            ((MutableResourceAuthorizationManager)this.authorizationManager).add(allowedUrl);
        }
    }

    protected String replaceImageUrl(String cssUri, String imageUrl) {
        String contextPath = this.context.getRequest() != null ? this.context.getRequest().getContextPath() : null;
        ImageUrlRewriter.RewriterContext rewriterContext = new ImageUrlRewriter.RewriterContext().setAggregatedFolderPath(this.context.getAggregatedFolderPath()).setProxyPrefix(this.getUrlPrefix()).setContextPath(contextPath);
        return new ImageUrlRewriter(rewriterContext).rewrite(cssUri, imageUrl);
    }

    public final boolean isUriAllowed(String uri) {
        return this.authorizationManager.isAuthorized(uri);
    }

    protected void onProcessCompleted() {
    }
}

